/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage1.spec;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectCollection;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectEntry;
import com.espertech.esper.common.internal.compile.stage1.spec.PluggableObjectRegistry;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;

public class PluggableObjectRegistryImpl
implements PluggableObjectRegistry {
    private PluggableObjectCollection[] collections;

    public PluggableObjectRegistryImpl(PluggableObjectCollection[] collections) {
        this.collections = collections;
    }

    @Override
    public Pair<Class, PluggableObjectEntry> lookup(String nameSpace, String name) {
        if (nameSpace != null) {
            for (int i = 0; i < this.collections.length; ++i) {
                Pair<Class, PluggableObjectEntry> entry;
                Map<String, Pair<Class, PluggableObjectEntry>> names = this.collections[i].getPluggables().get(nameSpace);
                if (names == null || (entry = names.get(name)) == null) continue;
                return entry;
            }
            return null;
        }
        HashSet<String> entriesDuplicate = null;
        Map.Entry<String, Pair<Class, PluggableObjectEntry>> found = null;
        for (int i = 0; i < this.collections.length; ++i) {
            for (Map.Entry<String, Map<String, Pair<Class, PluggableObjectEntry>>> collEntry : this.collections[i].getPluggables().entrySet()) {
                for (Map.Entry<String, Pair<Class, PluggableObjectEntry>> viewEntry : collEntry.getValue().entrySet()) {
                    if (!viewEntry.getKey().equals(name)) continue;
                    if (found != null) {
                        if (entriesDuplicate == null) {
                            entriesDuplicate = new HashSet<String>();
                        }
                        entriesDuplicate.add(viewEntry.getKey());
                        continue;
                    }
                    found = viewEntry;
                }
            }
        }
        if (entriesDuplicate != null) {
            entriesDuplicate.add((String)found.getKey());
            throw new IllegalStateException("Duplicate entries for '" + name + "' found in namespaces " + Arrays.toString(entriesDuplicate.toArray()));
        }
        return found == null ? null : (Pair)found.getValue();
    }
}

