/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.filterspec.FilterForEvalConstantAnyTypeForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamInValueForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class FilterSpecCompilerConsolidateUtil {
    protected static void consolidate(FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        boolean haveConsolidated;
        HashMap<Pair<ExprFilterSpecLookupableForge, FilterOperator>, ArrayList<FilterSpecPlanPathTripletForge>> mapOfParams = new HashMap<Pair<ExprFilterSpecLookupableForge, FilterOperator>, ArrayList<FilterSpecPlanPathTripletForge>>();
        do {
            haveConsolidated = false;
            mapOfParams.clear();
            for (FilterSpecPlanPathTripletForge currenttriplet : filterParamExprMap.getTriplets()) {
                FilterOperator op;
                ExprFilterSpecLookupableForge lookupable = currenttriplet.getParam().getLookupable();
                Pair<ExprFilterSpecLookupableForge, FilterOperator> key = new Pair<ExprFilterSpecLookupableForge, FilterOperator>(lookupable, op = currenttriplet.getParam().getFilterOperator());
                ArrayList<FilterSpecPlanPathTripletForge> existingParam = (ArrayList<FilterSpecPlanPathTripletForge>)mapOfParams.get(key);
                if (existingParam == null) {
                    existingParam = new ArrayList<FilterSpecPlanPathTripletForge>();
                    mapOfParams.put(key, existingParam);
                }
                existingParam.add(currenttriplet);
            }
            for (List entry : mapOfParams.values()) {
                if (entry.size() <= 1) continue;
                haveConsolidated = true;
                FilterSpecCompilerConsolidateUtil.consolidate(entry, filterParamExprMap, statementName);
            }
        } while (haveConsolidated);
    }

    private static void consolidate(List<FilterSpecPlanPathTripletForge> items, FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        boolean eligible = false;
        FilterOperator op = items.get(0).getParam().getFilterOperator();
        if (op == FilterOperator.NOT_EQUAL) {
            eligible = FilterSpecCompilerConsolidateUtil.handleConsolidateNotEqual(items, filterParamExprMap, statementName);
        }
        if (!eligible) {
            for (int i = 1; i < items.size(); ++i) {
                filterParamExprMap.removeValue(items.get(i));
            }
        }
    }

    private static boolean handleConsolidateNotEqual(List<FilterSpecPlanPathTripletForge> parameters, FilterSpecParaForgeMap filterParamExprMap, String statementName) {
        FilterSpecPlanPathTripletForge triplet3;
        Object param;
        for (FilterSpecPlanPathTripletForge triplet2 : parameters) {
            param = triplet2.getParam();
            if (param instanceof FilterSpecParamConstantForge || param instanceof FilterSpecParamEventPropForge || param instanceof FilterSpecParamEventPropIndexedForge) continue;
            return false;
        }
        ArrayList<FilterSpecParamInValueForge> values = new ArrayList<FilterSpecParamInValueForge>();
        ExprNode lastNotEqualsExprNode = null;
        for (FilterSpecPlanPathTripletForge triplet3 : parameters) {
            FilterSpecParamForge param2 = triplet3.getParam();
            if (param2 instanceof FilterSpecParamConstantForge) {
                FilterSpecParamConstantForge constantParam = (FilterSpecParamConstantForge)param2;
                Object constant = constantParam.getFilterConstant();
                values.add(new FilterForEvalConstantAnyTypeForge(constant));
            } else if (param2 instanceof FilterSpecParamEventPropForge) {
                eventProp = (FilterSpecParamEventPropForge)param2;
                values.add(new FilterForEvalEventPropForge(((FilterSpecParamEventPropForge)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropForge)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropForge)eventProp).getExprIdentNodeEvaluator(), ((FilterSpecParamEventPropForge)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropForge)eventProp).getCoercionType())));
            } else if (param2 instanceof FilterSpecParamEventPropIndexedForge) {
                eventProp = (FilterSpecParamEventPropIndexedForge)param2;
                values.add(new FilterForEvalEventPropIndexedForge(((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventAsName(), ((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventIndex(), ((FilterSpecParamEventPropIndexedForge)eventProp).getResultEventProperty(), ((FilterSpecParamEventPropIndexedForge)eventProp).getEventType(), ((FilterSpecParamEventPropIndexedForge)eventProp).isMustCoerce(), JavaClassHelper.getBoxedType(((FilterSpecParamEventPropIndexedForge)eventProp).getCoercionType())));
            } else {
                throw new IllegalStateException("Unknown filter parameter:" + param2.toString());
            }
            lastNotEqualsExprNode = filterParamExprMap.removeEntry(triplet3);
        }
        param = new FilterSpecParamInForge(parameters.get(0).getParam().getLookupable(), FilterOperator.NOT_IN_LIST_OF_VALUES, values);
        triplet3 = new FilterSpecPlanPathTripletForge((FilterSpecParamForge)param, null);
        filterParamExprMap.put(lastNotEqualsExprNode, triplet3);
        return true;
    }
}

