/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHelper;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHint;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprContextPropertyNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterOptimizableNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeDeployTimeConst;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprRelationalOpNode;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamConstantForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamContextPropForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamDeployTimeConstParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamEventPropIndexedForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamValueLimitedExprForge;
import com.espertech.esper.common.internal.type.RelationalOpEnum;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class FilterSpecCompilerIndexPlannerEquals {
    protected static FilterSpecParamForge handleEqualsAndRelOp(ExprNode constituent, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, String statementName, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        ExprNodeDeployTimeConst deployTimeConst;
        ExprFilterSpecLookupableForge lookupable;
        ExprContextPropertyNode ctxNode;
        ExprFilterOptimizableNode filterOptimizableNode;
        FilterOperator op;
        if (constituent instanceof ExprEqualsNode) {
            ExprEqualsNode equalsNode = (ExprEqualsNode)constituent;
            if (!equalsNode.isIs()) {
                op = FilterOperator.EQUAL;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.NOT_EQUAL;
                }
            } else {
                op = FilterOperator.IS;
                if (equalsNode.isNotEquals()) {
                    op = FilterOperator.IS_NOT;
                }
            }
        } else {
            ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
            if (relNode.getRelationalOpEnum() == RelationalOpEnum.GT) {
                op = FilterOperator.GREATER;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LT) {
                op = FilterOperator.LESS;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.LE) {
                op = FilterOperator.LESS_OR_EQUAL;
            } else if (relNode.getRelationalOpEnum() == RelationalOpEnum.GE) {
                op = FilterOperator.GREATER_OR_EQUAL;
            } else {
                throw new IllegalStateException("Opertor '" + relNode.getRelationalOpEnum() + "' not mapped");
            }
        }
        ExprNode left = constituent.getChildNodes()[0];
        ExprNode right = constituent.getChildNodes()[1];
        if (right.getForge().getForgeConstantType().isCompileTimeConstant() && left instanceof ExprFilterOptimizableNode && (filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left)).getFilterLookupEligible()) {
            ExprFilterSpecLookupableForge lookupable2 = filterOptimizableNode.getFilterLookupable();
            Object constant = right.getForge().getExprEvaluator().evaluate(null, true, null);
            constant = FilterSpecCompilerIndexPlannerHelper.handleConstantsCoercion(lookupable2, constant);
            return new FilterSpecParamConstantForge(lookupable2, op, constant);
        }
        if (left.getForge().getForgeConstantType().isCompileTimeConstant() && right instanceof ExprFilterOptimizableNode && (filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right)).getFilterLookupEligible()) {
            ExprFilterSpecLookupableForge lookupable3 = filterOptimizableNode.getFilterLookupable();
            Object constant = left.getForge().getExprEvaluator().evaluate(null, true, null);
            constant = FilterSpecCompilerIndexPlannerHelper.handleConstantsCoercion(lookupable3, constant);
            FilterOperator opReversed = op.isComparisonOperator() ? op.reversedRelationalOp() : op;
            return new FilterSpecParamConstantForge(lookupable3, opReversed, constant);
        }
        if (left instanceof ExprIdentNode && right instanceof ExprIdentNode) {
            ExprIdentNode identNodeLeft = (ExprIdentNode)left;
            ExprIdentNode identNodeRight = (ExprIdentNode)right;
            if (identNodeLeft.getStreamId() == 0 && identNodeLeft.getFilterLookupEligible() && identNodeRight.getStreamId() != 0) {
                return FilterSpecCompilerIndexPlannerEquals.handleProperty(op, identNodeLeft, identNodeRight, arrayEventTypes, statementName);
            }
            if (identNodeRight.getStreamId() == 0 && identNodeRight.getFilterLookupEligible() && identNodeLeft.getStreamId() != 0) {
                op = FilterSpecCompilerIndexPlannerEquals.getReversedOperator(constituent, op);
                return FilterSpecCompilerIndexPlannerEquals.handleProperty(op, identNodeRight, identNodeLeft, arrayEventTypes, statementName);
            }
        }
        if (left instanceof ExprFilterOptimizableNode && right instanceof ExprContextPropertyNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            ctxNode = (ExprContextPropertyNode)((Object)right);
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(lookupable.getReturnType(), ctxNode.getValueType(), lookupable.getExpression());
                return new FilterSpecParamContextPropForge(lookupable, op, ctxNode.getPropertyName(), ctxNode.getGetter(), numberCoercer);
            }
        }
        if (left instanceof ExprContextPropertyNode && right instanceof ExprFilterOptimizableNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right);
            ctxNode = (ExprContextPropertyNode)((Object)left);
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                op = FilterSpecCompilerIndexPlannerEquals.getReversedOperator(constituent, op);
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(lookupable.getReturnType(), ctxNode.getValueType(), lookupable.getExpression());
                return new FilterSpecParamContextPropForge(lookupable, op, ctxNode.getPropertyName(), ctxNode.getGetter(), numberCoercer);
            }
        }
        if (left instanceof ExprFilterOptimizableNode && right.getForge().getForgeConstantType().isDeployTimeTimeConstant() && right instanceof ExprNodeDeployTimeConst) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)left);
            deployTimeConst = (ExprNodeDeployTimeConst)((Object)right);
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                EPType returnType = right.getForge().getEvaluationType();
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(lookupable.getReturnType(), returnType, lookupable.getExpression());
                return new FilterSpecParamDeployTimeConstParamForge(lookupable, op, deployTimeConst, returnType, numberCoercer);
            }
        }
        if (left.getForge().getForgeConstantType().isDeployTimeTimeConstant() && left instanceof ExprNodeDeployTimeConst && right instanceof ExprFilterOptimizableNode) {
            filterOptimizableNode = (ExprFilterOptimizableNode)((Object)right);
            deployTimeConst = (ExprNodeDeployTimeConst)((Object)left);
            lookupable = filterOptimizableNode.getFilterLookupable();
            if (filterOptimizableNode.getFilterLookupEligible()) {
                EPType returnType = left.getForge().getEvaluationType();
                op = FilterSpecCompilerIndexPlannerEquals.getReversedOperator(constituent, op);
                SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(lookupable.getReturnType(), returnType, lookupable.getExpression());
                return new FilterSpecParamDeployTimeConstParamForge(lookupable, op, deployTimeConst, returnType, numberCoercer);
            }
        }
        ExprNode lookupable4 = null;
        ExprNode value = null;
        FilterOperator opWReverse = op;
        if (FilterSpecCompilerIndexPlannerHelper.isLimitedLookupableExpression(left) && FilterSpecCompilerIndexPlannerHelper.isLimitedValueExpression(right)) {
            lookupable4 = left;
            value = right;
        } else if (FilterSpecCompilerIndexPlannerHelper.isLimitedLookupableExpression(right) && FilterSpecCompilerIndexPlannerHelper.isLimitedValueExpression(left)) {
            lookupable4 = right;
            value = left;
            opWReverse = FilterSpecCompilerIndexPlannerEquals.getReversedOperator(constituent, op);
        }
        if (lookupable4 != null) {
            return FilterSpecCompilerIndexPlannerEquals.handleLimitedExpr(opWReverse, lookupable4, value, taggedEventTypes, arrayEventTypes, allTagNamesOrdered, raw, services);
        }
        return null;
    }

    private static FilterSpecParamForge handleLimitedExpr(FilterOperator op, ExprNode lookupable, ExprNode value, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        ExprFilterSpecLookupableForge lookupableForge;
        EPType lookupableType = lookupable.getForge().getEvaluationType();
        EPType valueType = value.getForge().getEvaluationType();
        if (lookupable instanceof ExprIdentNode) {
            if (!FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.VALUECOMPOSITE, raw, services)) {
                return null;
            }
            ExprIdentNode identNode = (ExprIdentNode)lookupable;
            if (!identNode.getFilterLookupEligible()) {
                return null;
            }
            lookupableForge = identNode.getFilterLookupable();
        } else {
            if (!FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.LKUPCOMPOSITE, raw, services)) {
                return null;
            }
            lookupableForge = FilterSpecCompilerIndexPlannerHelper.makeLimitedLookupableForgeMayNull(lookupable, raw, services);
            if (lookupableForge == null) {
                return null;
            }
        }
        MatchedEventConvertorForge convertor = FilterSpecCompilerIndexPlannerHelper.getMatchEventConvertor(value, taggedEventTypes, arrayEventTypes, allTagNamesOrdered);
        SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(lookupableType, valueType, lookupableForge.getExpression());
        return new FilterSpecParamValueLimitedExprForge(lookupableForge, op, value, convertor, numberCoercer);
    }

    private static FilterOperator getReversedOperator(ExprNode constituent, FilterOperator op) {
        if (!(constituent instanceof ExprRelationalOpNode)) {
            return op;
        }
        ExprRelationalOpNode relNode = (ExprRelationalOpNode)constituent;
        RelationalOpEnum relationalOpEnum = relNode.getRelationalOpEnum();
        if (relationalOpEnum == RelationalOpEnum.GT) {
            return FilterOperator.LESS;
        }
        if (relationalOpEnum == RelationalOpEnum.LT) {
            return FilterOperator.GREATER;
        }
        if (relationalOpEnum == RelationalOpEnum.LE) {
            return FilterOperator.GREATER_OR_EQUAL;
        }
        if (relationalOpEnum == RelationalOpEnum.GE) {
            return FilterOperator.LESS_OR_EQUAL;
        }
        return op;
    }

    private static FilterSpecParamForge handleProperty(FilterOperator op, ExprIdentNode identNodeLeft, ExprIdentNode identNodeRight, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName) throws ExprValidationException {
        EPType rightType;
        String propertyName = identNodeLeft.getResolvedPropertyName();
        EPType leftType = identNodeLeft.getForge().getEvaluationType();
        SimpleNumberCoercer numberCoercer = FilterSpecCompilerIndexPlannerHelper.getNumberCoercer(leftType, rightType = identNodeRight.getForge().getEvaluationType(), propertyName);
        boolean isMustCoerce = numberCoercer != null;
        EPTypeClass numericCoercionType = JavaClassHelper.getBoxedType((EPTypeClass)leftType);
        String streamName = identNodeRight.getResolvedStreamName();
        if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(streamName)) {
            EventType innerEventType = FilterSpecCompilerIndexPlannerHelper.getArrayInnerEventType(arrayEventTypes, streamName);
            Pair<Integer, String> indexAndProp = FilterSpecCompilerIndexPlannerHelper.getStreamIndex(identNodeRight.getResolvedPropertyName());
            return new FilterSpecParamEventPropIndexedForge(identNodeLeft.getFilterLookupable(), op, identNodeRight.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), innerEventType, isMustCoerce, numberCoercer, numericCoercionType);
        }
        return new FilterSpecParamEventPropForge(identNodeLeft.getFilterLookupable(), op, identNodeRight.getResolvedStreamName(), identNodeRight.getResolvedPropertyName(), identNodeRight.getExprEvaluatorIdent(), isMustCoerce, numberCoercer, numericCoercionType);
    }
}

