/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.HintEnum;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerExecution;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerArgs;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerConsolidateUtil;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexLimitedLookupableGetterForge;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerConstituent;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompilerIndexPlannerHint;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecExprNodeVisitorLookupableLimitedExpr;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecExprNodeVisitorValueLimitedExpr;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecParaForgeMap;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecPlanPathTripletForge;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprFilterSpecLookupableForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprStreamRefNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.filter.ExprFilterReboolValueNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprAndNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeStreamUseCollectVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSubselectDeclaredDotVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeTableAccessFinderVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVariableVisitor;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitorWithParent;
import com.espertech.esper.common.internal.epl.pattern.core.MatchedEventConvertorForge;
import com.espertech.esper.common.internal.event.map.MapEventType;
import com.espertech.esper.common.internal.event.property.IndexedProperty;
import com.espertech.esper.common.internal.event.property.NestedProperty;
import com.espertech.esper.common.internal.event.property.Property;
import com.espertech.esper.common.internal.event.property.PropertyParser;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropDoubleForge;
import com.espertech.esper.common.internal.filterspec.FilterForEvalEventPropIndexedDoubleForge;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamExprNodeForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamFilterForEvalDoubleForge;
import com.espertech.esper.common.internal.filterspec.FilterSpecParamForge;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class FilterSpecCompilerIndexPlannerHelper {
    protected static ExprNode decomposePopulateConsolidate(FilterSpecParaForgeMap filterParamExprMap, boolean performConditionPlanning, List<ExprNode> validatedNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        List<ExprNode> constituents = FilterSpecCompilerIndexPlannerHelper.decomposeCheckAggregation(validatedNodes);
        ExprNode topLevelControl = null;
        if (performConditionPlanning) {
            ArrayList<ExprNode> valueOnlyConstituents = null;
            for (ExprNode node : constituents) {
                FilterSpecExprNodeVisitorValueLimitedExpr visitor = new FilterSpecExprNodeVisitorValueLimitedExpr();
                node.accept(visitor);
                if (!visitor.isLimited()) continue;
                if (valueOnlyConstituents == null) {
                    valueOnlyConstituents = new ArrayList<ExprNode>();
                }
                valueOnlyConstituents.add(node);
            }
            if (valueOnlyConstituents != null) {
                constituents.removeAll(valueOnlyConstituents);
                topLevelControl = ExprNodeUtilityMake.connectExpressionsByLogicalAndWhenNeeded(valueOnlyConstituents);
            }
        }
        HashSet reboolExpressions = new HashSet();
        Function<String, Boolean> limitedExprExists = reboolExpression -> !reboolExpressions.add(reboolExpression);
        for (ExprNode constituent : constituents) {
            FilterSpecPlanPathTripletForge triplet = FilterSpecCompilerIndexPlannerConstituent.makeFilterParam(constituent, performConditionPlanning, limitedExprExists, args.taggedEventTypes, args.arrayEventTypes, args.allTagNamesOrdered, args.statementRawInfo.getStatementName(), args.streamTypeService, args.statementRawInfo, args.compileTimeServices);
            filterParamExprMap.put(constituent, triplet);
        }
        FilterSpecCompilerConsolidateUtil.consolidate(filterParamExprMap, args.statementRawInfo.getStatementName());
        return topLevelControl;
    }

    protected static SimpleNumberCoercer getNumberCoercer(EPType leftType, EPType rightType, String expression) throws ExprValidationException {
        EPType numericCoercionType = JavaClassHelper.getBoxedType(leftType);
        if (numericCoercionType == null || numericCoercionType == EPTypeNull.INSTANCE || rightType == null || rightType == EPTypeNull.INSTANCE) {
            return null;
        }
        EPTypeClass leftClass = (EPTypeClass)leftType;
        EPTypeClass rightClass = (EPTypeClass)rightType;
        if (rightClass.getType() != leftClass.getType() && JavaClassHelper.isNumeric(rightType)) {
            if (!JavaClassHelper.canCoerce(rightClass.getType(), leftClass.getType())) {
                FilterSpecCompilerIndexPlannerHelper.throwConversionError(rightClass.getType(), leftClass.getType(), expression);
            }
            return SimpleNumberCoercerFactory.getCoercer(rightType, (EPTypeClass)numericCoercionType);
        }
        return null;
    }

    protected static void throwConversionError(Class fromType, Class toType, String propertyName) throws ExprValidationException {
        String text = "Implicit conversion from datatype '" + fromType.getSimpleName() + "' to '" + toType.getSimpleName() + "' for property '" + propertyName + "' is not allowed (strict filter type coercion)";
        throw new ExprValidationException(text);
    }

    protected static MatchedEventConvertorForge getMatchEventConvertor(ExprNode value, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, LinkedHashSet<String> allTagNamesOrdered) throws ExprValidationException {
        ExprNodeStreamUseCollectVisitor streamUseCollectVisitor = new ExprNodeStreamUseCollectVisitor();
        value.accept(streamUseCollectVisitor);
        HashSet<Integer> streams = new HashSet<Integer>(streamUseCollectVisitor.getReferenced().size());
        for (ExprStreamRefNode streamRefNode : streamUseCollectVisitor.getReferenced()) {
            if (streamRefNode.getStreamReferencedIfAny() == null) continue;
            streams.add(streamRefNode.getStreamReferencedIfAny());
        }
        return new MatchedEventConvertorForge(taggedEventTypes, arrayEventTypes, allTagNamesOrdered, streams, true);
    }

    protected static Pair<Integer, String> getStreamIndex(String resolvedPropertyName) {
        Property property = PropertyParser.parseAndWalkLaxToSimple(resolvedPropertyName);
        if (!(property instanceof NestedProperty)) {
            throw new IllegalStateException("Expected a nested property providing an index for array match '" + resolvedPropertyName + "'");
        }
        NestedProperty nested = (NestedProperty)property;
        if (nested.getProperties().size() < 2) {
            throw new IllegalStateException("Expected a nested property name for array match '" + resolvedPropertyName + "', none found");
        }
        if (!(nested.getProperties().get(0) instanceof IndexedProperty)) {
            throw new IllegalStateException("Expected an indexed property for array match '" + resolvedPropertyName + "', please provide an index");
        }
        int index = ((IndexedProperty)nested.getProperties().get(0)).getIndex();
        nested.getProperties().remove(0);
        StringWriter writer = new StringWriter();
        nested.toPropertyEPL(writer);
        return new Pair<Integer, String>(index, writer.toString());
    }

    protected static List<ExprNode> decomposeCheckAggregation(List<ExprNode> validatedNodes) throws ExprValidationException {
        ArrayList<ExprNode> constituents = new ArrayList<ExprNode>();
        for (ExprNode validated : validatedNodes) {
            if (validated instanceof ExprAndNode) {
                FilterSpecCompilerIndexPlannerHelper.recursiveAndConstituents(constituents, validated);
            } else {
                constituents.add(validated);
            }
            LinkedList<ExprAggregateNode> aggregateExprNodes = new LinkedList<ExprAggregateNode>();
            ExprAggregateNodeUtil.getAggregatesBottomUp(validated, aggregateExprNodes);
            if (aggregateExprNodes.isEmpty()) continue;
            throw new ExprValidationException("Aggregation functions not allowed within filters");
        }
        return constituents;
    }

    private static void recursiveAndConstituents(List<ExprNode> constituents, ExprNode exprNode) {
        for (ExprNode inner : exprNode.getChildNodes()) {
            if (inner instanceof ExprAndNode) {
                FilterSpecCompilerIndexPlannerHelper.recursiveAndConstituents(constituents, inner);
                continue;
            }
            constituents.add(inner);
        }
    }

    protected static boolean isLimitedValueExpression(ExprNode node) {
        FilterSpecExprNodeVisitorValueLimitedExpr visitor = new FilterSpecExprNodeVisitorValueLimitedExpr();
        node.accept(visitor);
        return visitor.isLimited();
    }

    protected static EventType getArrayInnerEventType(LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String streamName) {
        Pair<EventType, String> arrayEventType = arrayEventTypes.get(streamName);
        Object prop = ((MapEventType)arrayEventType.getFirst()).getTypes().get(streamName);
        return ((EventType[])prop)[0];
    }

    protected static Object handleConstantsCoercion(ExprFilterSpecLookupableForge lookupable, Object constant) throws ExprValidationException {
        EPTypeClass identNodeType = lookupable.getReturnType();
        if (!JavaClassHelper.isNumeric(identNodeType)) {
            return constant;
        }
        if (constant == null) {
            return null;
        }
        if (!JavaClassHelper.canCoerce(constant.getClass(), identNodeType.getType())) {
            FilterSpecCompilerIndexPlannerHelper.throwConversionError(constant.getClass(), identNodeType.getType(), lookupable.getExpression());
        }
        Class<?> identNodeTypeBoxed = JavaClassHelper.getBoxedType(identNodeType).getType();
        return JavaClassHelper.coerceBoxed((Number)constant, identNodeTypeBoxed);
    }

    protected static FilterSpecParamFilterForEvalDoubleForge getIdentNodeDoubleEval(ExprIdentNode node, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, String statementName) {
        if (node.getStreamId() == 0) {
            return null;
        }
        if (arrayEventTypes != null && !arrayEventTypes.isEmpty() && arrayEventTypes.containsKey(node.getResolvedStreamName())) {
            Pair<Integer, String> indexAndProp = FilterSpecCompilerIndexPlannerHelper.getStreamIndex(node.getResolvedPropertyName());
            EventType eventType = FilterSpecCompilerIndexPlannerHelper.getArrayInnerEventType(arrayEventTypes, node.getResolvedStreamName());
            return new FilterForEvalEventPropIndexedDoubleForge(node.getResolvedStreamName(), indexAndProp.getFirst(), indexAndProp.getSecond(), eventType);
        }
        return new FilterForEvalEventPropDoubleForge(node.getResolvedStreamName(), node.getResolvedPropertyName(), node.getExprEvaluatorIdent());
    }

    protected static boolean isLimitedLookupableExpression(ExprNode node) {
        FilterSpecExprNodeVisitorLookupableLimitedExpr visitor = new FilterSpecExprNodeVisitorLookupableLimitedExpr();
        node.accept(visitor);
        return visitor.isLimited() && visitor.isHasStreamZeroReference();
    }

    protected static ExprFilterSpecLookupableForge makeLimitedLookupableForgeMayNull(ExprNode lookupable, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        if (!FilterSpecCompilerIndexPlannerHelper.hasLevelOrHint(FilterSpecCompilerIndexPlannerHint.LKUPCOMPOSITE, raw, services)) {
            return null;
        }
        EPTypeClass lookupableType = (EPTypeClass)lookupable.getForge().getEvaluationType();
        String expression = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(lookupable);
        FilterSpecCompilerIndexLimitedLookupableGetterForge getterForge = new FilterSpecCompilerIndexLimitedLookupableGetterForge(lookupable);
        DataInputOutputSerdeForge serde = services.getSerdeResolver().serdeForFilter(lookupableType, raw);
        return new ExprFilterSpecLookupableForge(expression, getterForge, null, lookupableType, true, serde);
    }

    protected static FilterSpecPlanPathTripletForge makeRemainingNode(List<ExprNode> unassignedExpressions, FilterSpecCompilerArgs args) throws ExprValidationException {
        if (unassignedExpressions.isEmpty()) {
            throw new IllegalArgumentException();
        }
        ExprNode exprNode = unassignedExpressions.size() == 1 ? unassignedExpressions.get(0) : FilterSpecCompilerIndexPlannerHelper.makeValidateAndNode(unassignedExpressions, args);
        FilterSpecParamForge param = FilterSpecCompilerIndexPlannerHelper.makeBooleanExprParam(exprNode, args);
        return new FilterSpecPlanPathTripletForge(param, null);
    }

    private static ExprAndNode makeValidateAndNode(List<ExprNode> remainingExprNodes, FilterSpecCompilerArgs args) throws ExprValidationException {
        ExprAndNode andNode = ExprNodeUtilityMake.connectExpressionsByLogicalAnd(remainingExprNodes);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(args.streamTypeService, args.statementRawInfo, args.compileTimeServices).withAllowBindingConsumption(true).withContextDescriptor(args.contextDescriptor).build();
        andNode.validate(validationContext);
        return andNode;
    }

    protected static boolean hasLevelOrHint(FilterSpecCompilerIndexPlannerHint requiredHint, StatementRawInfo raw, StatementCompileTimeServices services) throws ExprValidationException {
        ConfigurationCompilerExecution.FilterIndexPlanning config = services.getConfiguration().getCompiler().getExecution().getFilterIndexPlanning();
        if (config == ConfigurationCompilerExecution.FilterIndexPlanning.ADVANCED) {
            return true;
        }
        List<String> hints = HintEnum.FILTERINDEX.getHintAssignedValues(raw.getAnnotations());
        if (hints == null) {
            return false;
        }
        for (String hint : hints) {
            String[] hintAtoms = HintEnum.splitCommaUnlessInParen(hint);
            for (int i = 0; i < hintAtoms.length; ++i) {
                String hintAtom = hintAtoms[i];
                String hintLowercase = hintAtom.toLowerCase(Locale.ENGLISH).trim();
                FilterSpecCompilerIndexPlannerHint found = null;
                for (FilterSpecCompilerIndexPlannerHint available : FilterSpecCompilerIndexPlannerHint.values()) {
                    if (!hintLowercase.equals(available.getNameLowercase())) continue;
                    found = available;
                    if (requiredHint != available) continue;
                    return true;
                }
                if (found != null) continue;
                throw new ExprValidationException("Unrecognized filterindex hint value '" + hintAtom + "'");
            }
        }
        return false;
    }

    private static FilterSpecParamForge makeBooleanExprParam(ExprNode exprNode, FilterSpecCompilerArgs args) {
        boolean hasSubselectFilterStream = FilterSpecCompilerIndexPlannerHelper.determineSubselectFilterStream(exprNode);
        boolean hasTableAccess = FilterSpecCompilerIndexPlannerHelper.determineTableAccessFilterStream(exprNode);
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor(args.compileTimeServices.getVariableCompileTimeResolver());
        exprNode.accept(visitor);
        boolean hasVariable = visitor.isHasVariables();
        EPTypeClass evalType = (EPTypeClass)exprNode.getForge().getEvaluationType();
        DataInputOutputSerdeForge serdeForge = args.compileTimeServices.getSerdeResolver().serdeForFilter(evalType, args.statementRawInfo);
        ExprFilterSpecLookupableForge lookupable = new ExprFilterSpecLookupableForge(".boolean_expression", null, null, evalType, false, serdeForge);
        final LinkedHashMap rebools = new LinkedHashMap();
        ExprNodeVisitorWithParent reboolVisitor = new ExprNodeVisitorWithParent(){

            @Override
            public boolean isVisit(ExprNode exprNode) {
                return true;
            }

            @Override
            public void visit(ExprNode exprNode, ExprNode parentExprNode) {
                if (exprNode instanceof ExprFilterReboolValueNode) {
                    rebools.put((ExprFilterReboolValueNode)exprNode, parentExprNode);
                }
            }
        };
        exprNode.accept(reboolVisitor);
        for (Map.Entry entry : rebools.entrySet()) {
            ExprNodeUtilityModify.replaceChildNode((ExprNode)entry.getValue(), (ExprNode)entry.getKey(), ((ExprFilterReboolValueNode)entry.getKey()).getValueExpression());
        }
        return new FilterSpecParamExprNodeForge(lookupable, FilterOperator.BOOLEAN_EXPRESSION, exprNode, args.taggedEventTypes, args.arrayEventTypes, args.streamTypeService, hasSubselectFilterStream, hasTableAccess, hasVariable, args.compileTimeServices);
    }

    private static boolean determineTableAccessFilterStream(ExprNode exprNode) {
        ExprNodeTableAccessFinderVisitor visitor = new ExprNodeTableAccessFinderVisitor();
        exprNode.accept(visitor);
        return visitor.isHasTableAccess();
    }

    private static boolean determineSubselectFilterStream(ExprNode exprNode) {
        ExprNodeSubselectDeclaredDotVisitor visitor = new ExprNodeSubselectDeclaredDotVisitor();
        exprNode.accept(visitor);
        if (visitor.getSubselects().isEmpty()) {
            return false;
        }
        for (ExprSubselectNode subselectNode : visitor.getSubselects()) {
            if (!subselectNode.isFilterStreamSubselect()) continue;
            return true;
        }
        return false;
    }
}

