/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.internal.compile.stage2.FilterSpecExprNodeVisitorLookupableLimitedExpr;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.ops.ExprEqualsNode;
import com.espertech.esper.common.internal.epl.expression.ops.ExprInNodeImpl;
import com.espertech.esper.common.internal.epl.expression.ops.ExprOrNode;

public class FilterSpecCompilerIndexPlannerOrToInRewrite {
    public static ExprNode rewriteOrToInIfApplicable(ExprNode constituent, boolean rewriteRegardlessOfLookupable) {
        ExprNode commonExpressionNode;
        ExprNode rhs;
        ExprNode[] childNodes;
        if (!(constituent instanceof ExprOrNode) || constituent.getChildNodes().length < 2) {
            return constituent;
        }
        for (ExprNode child : childNodes = constituent.getChildNodes()) {
            if (!(child instanceof ExprEqualsNode)) {
                return constituent;
            }
            ExprEqualsNode equalsNode = (ExprEqualsNode)child;
            if (!equalsNode.isIs() && !equalsNode.isNotEquals()) continue;
            return constituent;
        }
        ExprNode lhs = childNodes[0].getChildNodes()[0];
        if (ExprNodeUtilityCompare.deepEquals(lhs, rhs = childNodes[0].getChildNodes()[1], false)) {
            return constituent;
        }
        if (FilterSpecCompilerIndexPlannerOrToInRewrite.isExprExistsInAllEqualsChildNodes(childNodes, lhs)) {
            commonExpressionNode = lhs;
        } else if (FilterSpecCompilerIndexPlannerOrToInRewrite.isExprExistsInAllEqualsChildNodes(childNodes, rhs)) {
            commonExpressionNode = rhs;
        } else {
            return constituent;
        }
        if (!rewriteRegardlessOfLookupable) {
            FilterSpecExprNodeVisitorLookupableLimitedExpr lookupableVisitor = new FilterSpecExprNodeVisitorLookupableLimitedExpr();
            commonExpressionNode.accept(lookupableVisitor);
            if (!lookupableVisitor.isHasStreamZeroReference() || !lookupableVisitor.isLimited()) {
                return constituent;
            }
        }
        ExprInNodeImpl in = new ExprInNodeImpl(false);
        in.addChildNode(commonExpressionNode);
        for (int i = 0; i < constituent.getChildNodes().length; ++i) {
            ExprNode child = constituent.getChildNodes()[i];
            int nodeindex = ExprNodeUtilityCompare.deepEquals(commonExpressionNode, childNodes[i].getChildNodes()[0], false) ? 1 : 0;
            in.addChildNode(child.getChildNodes()[nodeindex]);
        }
        try {
            in.validateWithoutContext();
        }
        catch (ExprValidationException ex) {
            return constituent;
        }
        return in;
    }

    private static boolean isExprExistsInAllEqualsChildNodes(ExprNode[] childNodes, ExprNode search) {
        for (ExprNode child : childNodes) {
            ExprNode lhs = child.getChildNodes()[0];
            ExprNode rhs = child.getChildNodes()[1];
            if (!ExprNodeUtilityCompare.deepEquals(lhs, search, false) && !ExprNodeUtilityCompare.deepEquals(rhs, search, false)) {
                return false;
            }
            if (!ExprNodeUtilityCompare.deepEquals(lhs, rhs, false)) continue;
            return false;
        }
        return true;
    }
}

