/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage2;

import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInSingleRowFunction;
import com.espertech.esper.common.internal.epl.enummethod.dot.ExprLambdaGoesNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeWithChainSpec;
import com.espertech.esper.common.internal.epl.expression.declared.compiletime.ExprDeclaredNode;
import com.espertech.esper.common.internal.epl.expression.dot.core.ExprDotNode;
import com.espertech.esper.common.internal.epl.expression.funcs.ExprPlugInSingleRowNode;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.expression.table.ExprTableAccessNode;
import com.espertech.esper.common.internal.epl.expression.variable.ExprVariableNode;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeVisitor;
import com.espertech.esper.common.internal.epl.script.core.ExprNodeScript;

public class FilterSpecExprNodeVisitorBooleanLimitedExprPrequalify
implements ExprNodeVisitor {
    private boolean limited = true;

    @Override
    public boolean isVisit(ExprNode exprNode) {
        return this.limited;
    }

    @Override
    public void visit(ExprNode exprNode) {
        ExprDotNode node;
        if (exprNode instanceof ExprVariableNode) {
            ExprVariableNode node2 = (ExprVariableNode)((Object)exprNode);
            if (!node2.getVariableMetadata().isConstant()) {
                this.limited = false;
            }
        } else if (exprNode instanceof ExprTableAccessNode || exprNode instanceof ExprSubselectNode || exprNode instanceof ExprLambdaGoesNode || exprNode instanceof ExprNodeScript || exprNode instanceof ExprDeclaredNode) {
            this.limited = false;
        } else if (exprNode instanceof ExprPlugInSingleRowNode) {
            ExprPlugInSingleRowNode plugIn = (ExprPlugInSingleRowNode)exprNode;
            if (plugIn.getConfig() != null && plugIn.getConfig().getFilterOptimizable() == ConfigurationCompilerPlugInSingleRowFunction.FilterOptimizable.DISABLED) {
                this.limited = false;
            }
            if (plugIn.isLocalInlinedClass()) {
                this.limited = false;
            }
        } else if (exprNode instanceof ExprDotNode && (node = (ExprDotNode)exprNode).isLocalInlinedClass()) {
            this.limited = false;
        }
        if (exprNode instanceof ExprNodeWithChainSpec && !((ExprNodeWithChainSpec)((Object)exprNode)).getChainSpec().isEmpty()) {
            this.limited = false;
        }
    }

    public boolean isLimited() {
        return this.limited;
    }
}

