/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.compile.stage3;

import com.espertech.esper.common.internal.compile.stage1.Compilable;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.context.util.ContextPropertyRegistry;
import java.io.Serializable;

public class StatementBaseInfo {
    private final Compilable compilable;
    private StatementSpecCompiled statementSpec;
    private final Serializable userObjectCompileTime;
    private final StatementRawInfo statementRawInfo;
    private final String optionalModuleName;

    public StatementBaseInfo(Compilable compilable, StatementSpecCompiled statementSpec, Serializable userObjectCompileTime, StatementRawInfo statementRawInfo, String optionalModuleName) {
        this.compilable = compilable;
        this.statementSpec = statementSpec;
        this.userObjectCompileTime = userObjectCompileTime;
        this.statementRawInfo = statementRawInfo;
        this.optionalModuleName = optionalModuleName;
    }

    public Compilable getCompilable() {
        return this.compilable;
    }

    public StatementSpecCompiled getStatementSpec() {
        return this.statementSpec;
    }

    public String getStatementName() {
        return this.statementRawInfo.getStatementName();
    }

    public Serializable getUserObjectCompileTime() {
        return this.userObjectCompileTime;
    }

    public int getStatementNumber() {
        return this.statementRawInfo.getStatementNumber();
    }

    public StatementRawInfo getStatementRawInfo() {
        return this.statementRawInfo;
    }

    public String getModuleName() {
        return this.optionalModuleName;
    }

    public ContextPropertyRegistry getContextPropertyRegistry() {
        if (this.statementRawInfo.getOptionalContextDescriptor() == null) {
            return null;
        }
        return this.statementRawInfo.getOptionalContextDescriptor().getContextPropertyRegistry();
    }

    public String getContextName() {
        if (this.statementRawInfo.getOptionalContextDescriptor() == null) {
            return null;
        }
        return this.statementRawInfo.getOptionalContextDescriptor().getContextName();
    }

    public void setStatementSpec(StatementSpecCompiled statementSpec) {
        this.statementSpec = statementSpec;
    }
}

