/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.activator;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorForge;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorNamedWindow;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.contained.PropertyEvaluatorForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.join.querygraph.QueryGraphForge;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowDeployTimeResolver;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;

public class ViewableActivatorNamedWindowForge
implements ViewableActivatorForge {
    private final NamedWindowConsumerStreamSpec spec;
    private final NamedWindowMetaData namedWindow;
    private final ExprNode filterEvaluator;
    private final QueryGraphForge filterQueryGraph;
    private final boolean subquery;
    private final PropertyEvaluatorForge optPropertyEvaluator;

    public ViewableActivatorNamedWindowForge(NamedWindowConsumerStreamSpec spec, NamedWindowMetaData namedWindow, ExprNode filterEvaluator, QueryGraphForge filterQueryGraph, boolean subquery, PropertyEvaluatorForge optPropertyEvaluator) {
        this.spec = spec;
        this.namedWindow = namedWindow;
        this.filterEvaluator = filterEvaluator;
        this.filterQueryGraph = filterQueryGraph;
        this.subquery = subquery;
        this.optPropertyEvaluator = optPropertyEvaluator;
    }

    @Override
    public CodegenExpression makeCodegen(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.spec.getNamedWindowConsumerId() == -1) {
            throw new IllegalStateException("Unassigned named window consumer id");
        }
        CodegenMethod method = parent.makeChild(ViewableActivatorNamedWindow.EPTYPE, this.getClass(), (CodegenScope)classScope);
        CodegenExpression filter = this.filterEvaluator == null ? CodegenExpressionBuilder.constantNull() : ExprNodeUtilityCodegen.codegenEvaluator(this.filterEvaluator.getForge(), method, this.getClass(), classScope);
        method.getBlock().declareVar(ViewableActivatorNamedWindow.EPTYPE, "activator", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getViewableActivatorFactory", new CodegenExpression[0]).add("createNamedWindow", new CodegenExpression[0])).exprDotMethod(CodegenExpressionBuilder.ref("activator"), "setNamedWindow", NamedWindowDeployTimeResolver.makeResolveNamedWindow(this.namedWindow, symbols.getAddInitSvc(method))).exprDotMethod(CodegenExpressionBuilder.ref("activator"), "setNamedWindowConsumerId", CodegenExpressionBuilder.constant(this.spec.getNamedWindowConsumerId())).exprDotMethod(CodegenExpressionBuilder.ref("activator"), "setFilterEvaluator", filter).exprDotMethod(CodegenExpressionBuilder.ref("activator"), "setFilterQueryGraph", this.filterQueryGraph == null ? CodegenExpressionBuilder.constantNull() : this.filterQueryGraph.make(method, symbols, classScope)).exprDotMethod(CodegenExpressionBuilder.ref("activator"), "setSubquery", CodegenExpressionBuilder.constant(this.subquery)).exprDotMethod(CodegenExpressionBuilder.ref("activator"), "setOptPropertyEvaluator", this.optPropertyEvaluator == null ? CodegenExpressionBuilder.constantNull() : this.optPropertyEvaluator.make(method, symbols, classScope)).exprDotMethod(symbols.getAddInitSvc(method), "addReadyCallback", CodegenExpressionBuilder.ref("activator")).methodReturn(CodegenExpressionBuilder.ref("activator"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }
}

