/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createindex;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.createindex.StatementAgentInstanceFactoryCreateIndexResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.lookup.IndexMultiKey;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanIndexItem;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyFactory;
import com.espertech.esper.common.internal.epl.table.update.TableUpdateStrategyRedoCallback;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.view.core.Viewable;
import com.espertech.esper.common.internal.view.core.ViewableDefaultImpl;

public class StatementAgentInstanceFactoryCreateIndex
implements StatementAgentInstanceFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(StatementAgentInstanceFactoryCreateIndex.class);
    private EventType eventType;
    private String indexName;
    private String indexModuleName;
    private QueryPlanIndexItem explicitIndexDesc;
    private IndexMultiKey indexMultiKey;
    private NamedWindow namedWindow;
    private Table table;
    private Viewable viewable;

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
        this.viewable = new ViewableDefaultImpl(eventType);
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndexModuleName(String indexModuleName) {
        this.indexModuleName = indexModuleName;
    }

    public void setExplicitIndexDesc(QueryPlanIndexItem explicitIndexDesc) {
        this.explicitIndexDesc = explicitIndexDesc;
    }

    public void setIndexMultiKey(IndexMultiKey indexMultiKey) {
        this.indexMultiKey = indexMultiKey;
    }

    public void setNamedWindow(NamedWindow namedWindow) {
        this.namedWindow = namedWindow;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public EventType getStatementEventType() {
        return this.eventType;
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
        if (this.table != null && this.indexMultiKey.isUnique()) {
            for (TableUpdateStrategyRedoCallback callback : this.table.getUpdateStrategyCallbacks()) {
                if (!callback.isMerge()) continue;
                TableUpdateStrategyFactory.validateNewUniqueIndex(callback.getTableUpdatedProperties(), this.indexMultiKey.getHashIndexedProps());
            }
        }
        try {
            if (this.namedWindow != null) {
                this.namedWindow.validateAddIndex(statementContext.getDeploymentId(), statementContext.getStatementName(), this.indexName, this.indexModuleName, this.explicitIndexDesc, this.indexMultiKey);
            } else {
                this.table.validateAddIndex(statementContext.getDeploymentId(), statementContext.getStatementName(), this.indexName, this.indexModuleName, this.explicitIndexDesc, this.indexMultiKey);
            }
        }
        catch (ExprValidationException ex) {
            throw new EPException(ex.getMessage(), ex);
        }
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
        if (this.namedWindow != null) {
            this.namedWindow.removeIndexReferencesStmtMayRemoveIndex(this.indexMultiKey, statementContext.getDeploymentId(), statementContext.getStatementName());
        } else {
            this.table.removeIndexReferencesStmtMayRemoveIndex(this.indexMultiKey, statementContext.getDeploymentId(), statementContext.getStatementName());
        }
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        AgentInstanceMgmtCallback stopCallback;
        if (this.namedWindow != null) {
            NamedWindowInstance processorInstance = this.namedWindow.getNamedWindowInstance(agentInstanceContext);
            if (processorInstance.getRootViewInstance().isVirtualDataWindow()) {
                final VirtualDWView virtualDWView = processorInstance.getRootViewInstance().getVirtualDataWindow();
                virtualDWView.handleStartIndex(this.indexName, this.explicitIndexDesc);
                stopCallback = new AgentInstanceMgmtCallback(){

                    @Override
                    public void stop(AgentInstanceStopServices services) {
                        virtualDWView.handleStopIndex(StatementAgentInstanceFactoryCreateIndex.this.indexName, StatementAgentInstanceFactoryCreateIndex.this.explicitIndexDesc);
                    }
                };
            } else {
                try {
                    processorInstance.getRootViewInstance().addExplicitIndex(this.indexName, this.indexModuleName, this.explicitIndexDesc, isRecoveringResilient);
                }
                catch (ExprValidationException e) {
                    throw new EPException("Failed to create index: " + e.getMessage(), e);
                }
                stopCallback = new AgentInstanceMgmtCallback(){

                    @Override
                    public void stop(AgentInstanceStopServices services) {
                        NamedWindowInstance instance = StatementAgentInstanceFactoryCreateIndex.this.namedWindow.getNamedWindowInstance(services.getAgentInstanceContext());
                        if (instance != null) {
                            instance.removeExplicitIndex(StatementAgentInstanceFactoryCreateIndex.this.indexName, StatementAgentInstanceFactoryCreateIndex.this.indexModuleName);
                        }
                    }
                };
            }
        } else {
            try {
                TableInstance instance = this.table.getTableInstance(agentInstanceContext.getAgentInstanceId());
                instance.addExplicitIndex(this.indexName, this.indexModuleName, this.explicitIndexDesc, isRecoveringResilient);
            }
            catch (ExprValidationException ex) {
                throw new EPException("Failed to create index: " + ex.getMessage(), ex);
            }
            stopCallback = new AgentInstanceMgmtCallback(){

                @Override
                public void stop(AgentInstanceStopServices services) {
                    TableInstance instance = StatementAgentInstanceFactoryCreateIndex.this.table.getTableInstance(services.getAgentInstanceContext().getAgentInstanceId());
                    if (instance != null) {
                        instance.removeExplicitIndex(StatementAgentInstanceFactoryCreateIndex.this.indexName, StatementAgentInstanceFactoryCreateIndex.this.indexModuleName);
                    }
                }
            };
        }
        return new StatementAgentInstanceFactoryCreateIndexResult(this.viewable, stopCallback, agentInstanceContext);
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext, agentInstanceId);
    }
}

