/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createtable;

import com.espertech.esper.common.client.EventPropertyValueGetter;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.MultiKeyFromMultiKey;
import com.espertech.esper.common.internal.collection.MultiKeyFromObjectArray;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.createtable.StatementAgentInstanceFactoryCreateTableResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowFactory;
import com.espertech.esper.common.internal.epl.table.core.Table;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;
import com.espertech.esper.common.internal.epl.table.core.TableInstanceViewable;
import com.espertech.esper.common.internal.epl.table.core.TableMetadataInternalEventToPublic;
import com.espertech.esper.common.internal.epl.table.core.TableSerdes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementAgentInstanceFactoryCreateTable
implements StatementAgentInstanceFactory,
StatementReadyCallback {
    public static final EPTypeClass EPTYPE = new EPTypeClass(StatementAgentInstanceFactoryCreateTable.class);
    private static final Logger log = LoggerFactory.getLogger(StatementAgentInstanceFactoryCreateTable.class);
    private EventType publicEventType;
    private String tableName;
    private TableMetadataInternalEventToPublic eventToPublic;
    private AggregationRowFactory aggregationRowFactory;
    private DataInputOutputSerde aggregationSerde;
    private EventPropertyValueGetter primaryKeyGetter;
    private DataInputOutputSerde primaryKeySerde;
    private MultiKeyFromObjectArray primaryKeyObjectArrayTransform;
    private MultiKeyFromMultiKey primaryKeyIntoTableTransform;
    private DataInputOutputSerde[] propertyForges;
    private Table table;

    public void setEventToPublic(TableMetadataInternalEventToPublic eventToPublic) {
        this.eventToPublic = eventToPublic;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPublicEventType(EventType publicEventType) {
        this.publicEventType = publicEventType;
    }

    public void setAggregationRowFactory(AggregationRowFactory aggregationRowFactory) {
        this.aggregationRowFactory = aggregationRowFactory;
    }

    public void setAggregationSerde(DataInputOutputSerde aggregationSerde) {
        this.aggregationSerde = aggregationSerde;
    }

    public void setPrimaryKeyGetter(EventPropertyValueGetter primaryKeyGetter) {
        this.primaryKeyGetter = primaryKeyGetter;
    }

    public void setPrimaryKeySerde(DataInputOutputSerde primaryKeySerde) {
        this.primaryKeySerde = primaryKeySerde;
    }

    public void setPrimaryKeyObjectArrayTransform(MultiKeyFromObjectArray primaryKeyObjectArrayTransform) {
        this.primaryKeyObjectArrayTransform = primaryKeyObjectArrayTransform;
    }

    public void setPrimaryKeyIntoTableTransform(MultiKeyFromMultiKey primaryKeyIntoTableTransform) {
        this.primaryKeyIntoTableTransform = primaryKeyIntoTableTransform;
    }

    public void setPropertyForges(DataInputOutputSerde[] propertyForges) {
        this.propertyForges = propertyForges;
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        this.table = statementContext.getTableManagementService().getTable(statementContext.getDeploymentId(), this.tableName);
        if (this.table == null) {
            throw new IllegalStateException("Table '" + this.tableName + "' has not be registered");
        }
        this.table.setStatementContextCreateTable(statementContext);
        this.table.setEventToPublic(this.eventToPublic);
        this.table.setAggregationRowFactory(this.aggregationRowFactory);
        this.table.setTableSerdes(new TableSerdes(this.propertyForges, this.aggregationSerde));
        this.table.setPrimaryKeyGetter(this.primaryKeyGetter);
        this.table.setPrimaryKeySerde(this.primaryKeySerde);
        this.table.setPrimaryKeyObjectArrayTransform(this.primaryKeyObjectArrayTransform);
        this.table.setPrimaryKeyIntoTableTransform(this.primaryKeyIntoTableTransform);
        this.table.tableReady();
    }

    @Override
    public EventType getStatementEventType() {
        return this.publicEventType;
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
        statementContext.getTableManagementService().destroyTable(statementContext.getDeploymentId(), this.tableName);
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        TableInstance tableState = agentInstanceContext.getTableManagementService().allocateTableInstance(this.table, agentInstanceContext);
        TableInstanceViewable finalView = new TableInstanceViewable(this.table, tableState);
        AgentInstanceMgmtCallback stop = new AgentInstanceMgmtCallback(){

            @Override
            public void stop(AgentInstanceStopServices services) {
                TableInstance instance = StatementAgentInstanceFactoryCreateTable.this.table.getTableInstance(agentInstanceContext.getAgentInstanceId());
                if (instance == null) {
                    log.warn("Table instance by name '" + StatementAgentInstanceFactoryCreateTable.this.tableName + "' has not been found");
                } else {
                    instance.destroy();
                }
            }
        };
        return new StatementAgentInstanceFactoryCreateTableResult(finalView, stop, agentInstanceContext, tableState);
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext, agentInstanceId);
    }
}

