/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createtable;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.meta.EventTypeApplicationType;
import com.espertech.esper.common.client.meta.EventTypeIdPair;
import com.espertech.esper.common.client.meta.EventTypeMetadata;
import com.espertech.esper.common.client.meta.EventTypeTypeClass;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.EventTypeBusModifier;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.client.util.StateMgmtIndexDescHash;
import com.espertech.esper.common.client.util.StateMgmtSetting;
import com.espertech.esper.common.client.util.StatementProperty;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlan;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyPlanner;
import com.espertech.esper.common.internal.compile.stage1.spec.AnnotationDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.ColumnDesc;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateTableColumn;
import com.espertech.esper.common.internal.compile.stage1.spec.CreateTableDesc;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementInformationalsUtil;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtFields;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtProvider;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethod;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethodResult;
import com.espertech.esper.common.internal.context.aifactory.createtable.StatementAgentInstanceFactoryCreateTableForge;
import com.espertech.esper.common.internal.context.aifactory.createtable.StmtClassForgeableAIFactoryProviderCreateTable;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryProvider;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.context.module.StatementInformationalsCompileTime;
import com.espertech.esper.common.internal.context.module.StatementProvider;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorSlotPairForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowStateForgeDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationStateFactoryForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationUseFlags;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprIdentNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityModify;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprTypedNoEvalNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.join.queryplan.QueryPlanAttributionKeyStatement;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectSubscriberDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.table.compiletime.TableAccessAnalysisResult;
import com.espertech.esper.common.internal.epl.table.compiletime.TableColumnDesc;
import com.espertech.esper.common.internal.epl.table.compiletime.TableColumnDescAgg;
import com.espertech.esper.common.internal.epl.table.compiletime.TableColumnDescTyped;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetaData;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumn;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnAggregation;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnPairAggAccess;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnPairAggMethod;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnPairPlainCol;
import com.espertech.esper.common.internal.epl.table.compiletime.TableMetadataColumnPlain;
import com.espertech.esper.common.internal.epl.util.EPLValidationUtil;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventType;
import com.espertech.esper.common.internal.event.core.BaseNestableEventUtil;
import com.espertech.esper.common.internal.event.core.EventPropertyGetterSPI;
import com.espertech.esper.common.internal.event.core.EventTypeNameUtil;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventPropertyDesc;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventPropertyUtility;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeUtility;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClass;
import com.espertech.esper.common.internal.settings.ClasspathImportEPTypeUtil;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceCompileTime;
import com.espertech.esper.common.internal.statemgmtsettings.StateMgmtSettingDefault;
import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class StmtForgeMethodCreateTable
implements StmtForgeMethod {
    public static final String INTERNAL_RESERVED_PROPERTY = "internal-reserved";
    private final StatementBaseInfo base;

    public StmtForgeMethodCreateTable(StatementBaseInfo base) {
        this.base = base;
    }

    @Override
    public StmtForgeMethodResult make(String packageName, String classPostfix, StatementCompileTimeServices services) throws ExprValidationException {
        try {
            return this.build(packageName, classPostfix, services);
        }
        catch (ExprValidationException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new ExprValidationException("Unexpected exception creating table '" + this.base.getStatementSpec().getRaw().getCreateTableDesc().getTableName() + "': " + t.getMessage(), t);
        }
    }

    private StmtForgeMethodResult build(String packageName, String classPostfix, StatementCompileTimeServices services) throws ExprValidationException {
        CreateTableDesc createDesc = this.base.getStatementSpec().getRaw().getCreateTableDesc();
        String tableName = createDesc.getTableName();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        FabricCharge fabricCharge = services.getStateMgmtSettingsProvider().newCharge();
        EPLValidationUtil.validateAlreadyExistsTableOrVariable(tableName, services.getVariableCompileTimeResolver(), services.getTableCompileTimeResolver(), services.getEventTypeCompileTimeResolver());
        this.validateKeyTypes(createDesc.getColumns(), services.getClasspathImportServiceCompileTime(), services.getClassProvidedClasspathExtension());
        Pair<List<TableColumnDesc>, List<StmtClassForgeableFactory>> columnsValidated = this.validateExpressions(createDesc.getColumns(), services);
        List<TableColumnDesc> columnDescs = columnsValidated.getFirst();
        additionalForgeables.addAll((Collection)columnsValidated.getSecond());
        TableAccessAnalysisResult plan = this.analyzePlanAggregations(createDesc.getTableName(), columnDescs, this.base.getStatementRawInfo(), services);
        additionalForgeables.addAll(plan.getAdditionalForgeables());
        NameAccessModifier visibility = plan.getPublicEventType().getMetadata().getAccessModifier();
        String contextName = this.base.getStatementRawInfo().getContextName();
        NameAccessModifier contextVisibility = null;
        String contextModuleName = null;
        if (contextName != null) {
            ContextMetaData contextDetail = services.getContextCompileTimeResolver().getContextInfo(contextName);
            if (contextDetail == null) {
                throw new ExprValidationException("Failed to find context '" + contextName + "'");
            }
            contextVisibility = contextDetail.getContextVisibility();
            contextModuleName = contextDetail.getContextModuleName();
        }
        StateMgmtSetting stateMgmtSettingsPrimaryKey = StateMgmtSettingDefault.INSTANCE;
        if (plan.getPrimaryKeyTypes() != null && plan.getPrimaryKeyTypes().length > 0) {
            StateMgmtIndexDescHash hash = new StateMgmtIndexDescHash(plan.getPrimaryKeyColumns(), plan.getPrimaryKeyMultikeyClasses(), true);
            stateMgmtSettingsPrimaryKey = services.getStateMgmtSettingsProvider().index().indexHash(fabricCharge, QueryPlanAttributionKeyStatement.INSTANCE, tableName, plan.getInternalEventType(), hash, this.base.getStatementRawInfo());
        }
        StateMgmtSetting stateMgmtSettingsUnkeyed = StateMgmtSettingDefault.INSTANCE;
        if (plan.getPrimaryKeyTypes() == null || plan.getPrimaryKeyTypes().length == 0) {
            stateMgmtSettingsUnkeyed = services.getStateMgmtSettingsProvider().tableUnkeyed(fabricCharge, tableName, plan, this.base.getStatementRawInfo());
        }
        services.getStateMgmtSettingsProvider().table(fabricCharge, tableName, plan, this.base.getStatementRawInfo());
        TableMetaData tableMetaData = new TableMetaData(tableName, this.base.getModuleName(), visibility, contextName, contextVisibility, contextModuleName, plan.getInternalEventType(), plan.getPublicEventType(), plan.getPrimaryKeyColumns(), plan.getPrimaryKeyTypes(), plan.getPrimaryKeyColNums(), plan.getTableColumns(), plan.getColsAggMethod().length, stateMgmtSettingsPrimaryKey, stateMgmtSettingsUnkeyed);
        services.getTableCompileTimeRegistry().newTable(tableMetaData);
        String aiFactoryProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementAIFactoryProvider.class, classPostfix);
        String statementFieldsClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementFields.class, classPostfix);
        String statementProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementProvider.class, classPostfix);
        StatementAgentInstanceFactoryCreateTableForge forge = new StatementAgentInstanceFactoryCreateTableForge(aiFactoryProviderClassName, tableMetaData.getTableName(), plan, services.getSerdeResolver().isTargetHA());
        CodegenPackageScope packageScope = new CodegenPackageScope(packageName, statementFieldsClassName, services.isInstrumented(), services.getConfiguration().getCompiler().getByteCode());
        ArrayList<StmtClassForgeable> forgeables = new ArrayList<StmtClassForgeable>(2);
        for (StmtClassForgeableFactory additional : additionalForgeables) {
            forgeables.add(additional.make(packageScope, classPostfix));
        }
        StmtClassForgeableAIFactoryProviderCreateTable aiFactoryForgeable = new StmtClassForgeableAIFactoryProviderCreateTable(aiFactoryProviderClassName, packageScope, forge, tableName);
        forgeables.add(aiFactoryForgeable);
        SelectSubscriberDescriptor selectSubscriberDescriptor = new SelectSubscriberDescriptor();
        StatementInformationalsCompileTime informationals = StatementInformationalsUtil.getInformationals(this.base, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), true, selectSubscriberDescriptor, packageScope, services);
        informationals.getProperties().put(StatementProperty.CREATEOBJECTNAME, createDesc.getTableName());
        forgeables.add(new StmtClassForgeableStmtProvider(aiFactoryProviderClassName, statementProviderClassName, informationals, packageScope));
        forgeables.add(new StmtClassForgeableStmtFields(statementFieldsClassName, packageScope));
        return new StmtForgeMethodResult(forgeables, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), packageScope, fabricCharge);
    }

    private void validateKeyTypes(List<CreateTableColumn> columns, ClasspathImportServiceCompileTime classpathImportService, ClasspathExtensionClass classpathExtension) throws ExprValidationException {
        for (CreateTableColumn col : columns) {
            if (col.getPrimaryKey() == null || !col.getPrimaryKey().booleanValue()) continue;
            String msg = "Column '" + col.getColumnName() + "' may not be tagged as primary key";
            if (col.getOptExpression() != null) {
                throw new ExprValidationException(msg + ", an expression cannot become a primary key column");
            }
            Object type = EventTypeUtility.buildType(new ColumnDesc(col.getColumnName(), col.getOptType().toEPL()), classpathImportService, classpathExtension);
            if (type instanceof EPTypeClass) continue;
            throw new ExprValidationException(msg + ", received unexpected event type '" + type + "'");
        }
    }

    private Pair<List<TableColumnDesc>, List<StmtClassForgeableFactory>> validateExpressions(List<CreateTableColumn> columns, StatementCompileTimeServices services) throws ExprValidationException {
        HashSet<String> columnNames = new HashSet<String>();
        ArrayList<TableColumnDescAgg> descriptors = new ArrayList<TableColumnDescAgg>();
        int positionInDeclaration = 0;
        ArrayList additionalForgeables = new ArrayList(2);
        for (CreateTableColumn column : columns) {
            TableColumnDesc descriptor;
            String msgprefix = "For column '" + column.getColumnName() + "'";
            if (columnNames.contains(column.getColumnName())) {
                throw new ExprValidationException("Column '" + column.getColumnName() + "' is listed more than once");
            }
            columnNames.add(column.getColumnName());
            EventType optionalEventType = StmtForgeMethodCreateTable.validateExpressionGetEventType(msgprefix, column.getAnnotations(), services);
            if (column.getOptExpression() != null) {
                Pair<ExprAggregateNode, List<StmtClassForgeableFactory>> pair = this.validateAggregationExpr(column.getOptExpression(), optionalEventType, services);
                descriptor = new TableColumnDescAgg(positionInDeclaration, column.getColumnName(), pair.getFirst(), optionalEventType);
                additionalForgeables.addAll(pair.getSecond());
            } else {
                Object unresolvedType = EventTypeUtility.buildType(new ColumnDesc(column.getColumnName(), column.getOptType().toEPL()), services.getClasspathImportServiceCompileTime(), services.getClassProvidedClasspathExtension());
                descriptor = new TableColumnDescTyped(positionInDeclaration, column.getColumnName(), unresolvedType, column.getPrimaryKey() == null ? false : column.getPrimaryKey());
            }
            descriptors.add((TableColumnDescAgg)descriptor);
            ++positionInDeclaration;
        }
        return new Pair<List<TableColumnDesc>, List<StmtClassForgeableFactory>>(descriptors, additionalForgeables);
    }

    private static EventType validateExpressionGetEventType(String msgprefix, List<AnnotationDesc> annotations, StatementCompileTimeServices services) throws ExprValidationException {
        Map<String, List<AnnotationDesc>> annos = AnnotationUtil.mapByNameLowerCase(annotations);
        List<AnnotationDesc> typeAnnos = annos.remove("type");
        if (!annos.isEmpty()) {
            throw new ExprValidationException(msgprefix + " unrecognized annotation '" + annos.keySet().iterator().next() + "'");
        }
        EventType optionalType = null;
        if (typeAnnos != null) {
            String typeName = AnnotationUtil.getExpectSingleStringValue(msgprefix, typeAnnos);
            optionalType = services.getEventTypeCompileTimeResolver().getTypeByName(typeName);
            if (optionalType == null) {
                throw new ExprValidationException(msgprefix + " failed to find event type '" + typeName + "'");
            }
        }
        return optionalType;
    }

    private Pair<ExprAggregateNode, List<StmtClassForgeableFactory>> validateAggregationExpr(ExprNode columnExpressionType, EventType optionalProvidedType, StatementCompileTimeServices services) throws ExprValidationException {
        boolean[] istreamOnly;
        String[] streamNames;
        EventType[] types;
        ClasspathImportServiceCompileTime classpathImportService = services.getClasspathImportServiceCompileTime();
        if (optionalProvidedType != null) {
            types = new EventType[]{optionalProvidedType};
            streamNames = new String[]{types[0].getName()};
            istreamOnly = new boolean[]{false};
        } else {
            types = new EventType[]{};
            streamNames = new String[]{};
            istreamOnly = new boolean[]{};
        }
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(types, streamNames, istreamOnly, false, false);
        ExprValidationContext validationContext = new ExprValidationContextBuilder(streamTypeService, this.base.getStatementRawInfo(), services).build();
        for (ExprNode childNode : columnExpressionType.getChildNodes()) {
            if (!(childNode instanceof ExprIdentNode)) continue;
            ExprIdentNode identNode = (ExprIdentNode)childNode;
            String propname = identNode.getFullUnresolvedName().trim();
            EPTypeClass clazz = null;
            if (propname.toLowerCase(Locale.ENGLISH).trim().equals("object")) {
                clazz = EPTypePremade.OBJECT.getEPType();
            } else {
                Class<?> resolvedClass = JavaClassHelper.getClassForSimpleName(propname, classpathImportService.getClassForNameProvider());
                if (resolvedClass != null) {
                    clazz = ClassHelperGenericType.getClassEPType(resolvedClass);
                }
            }
            ClasspathImportException ex = null;
            if (clazz == null) {
                ClassDescriptor descriptor = ClassDescriptor.parseTypeText(propname);
                Class resolvedClass = null;
                try {
                    resolvedClass = classpathImportService.resolveClass(descriptor.getClassIdentifier(), false, services.getClassProvidedClasspathExtension());
                }
                catch (ClasspathImportException e) {
                    ex = e;
                }
                if (resolvedClass != null) {
                    clazz = ClasspathImportEPTypeUtil.parameterizeType(false, resolvedClass, descriptor, (ClasspathImportService)services.getClasspathImportServiceCompileTime(), services.getClassProvidedClasspathExtension());
                }
            }
            if (clazz != null) {
                ExprTypedNoEvalNode typeNode = new ExprTypedNoEvalNode(propname, clazz);
                ExprNodeUtilityModify.replaceChildNode(columnExpressionType, identNode, typeNode);
                continue;
            }
            if (optionalProvidedType != null) continue;
            if (ex != null) {
                throw new ExprValidationException("Failed to resolve type '" + propname + "': " + ex.getMessage(), ex);
            }
            throw new ExprValidationException("Failed to resolve type '" + propname + "'");
        }
        ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.CREATETABLECOLUMN, columnExpressionType, validationContext);
        if (!(validated instanceof ExprAggregateNode)) {
            throw new ExprValidationException("Expression '" + ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(validated) + "' is not an aggregation");
        }
        ExprAggregateNode aggregateNode = (ExprAggregateNode)validated;
        return new Pair<ExprAggregateNode, List<StmtClassForgeableFactory>>(aggregateNode, validationContext.getAdditionalForgeables());
    }

    private TableAccessAnalysisResult analyzePlanAggregations(String tableName, List<TableColumnDesc> columns, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        HashMap<TableColumnDesc, AggregationForgeFactory> aggregationFactories = new HashMap<TableColumnDesc, AggregationForgeFactory>();
        for (TableColumnDesc column : columns) {
            if (!(column instanceof TableColumnDescAgg)) continue;
            TableColumnDescAgg agg = (TableColumnDescAgg)column;
            AggregationForgeFactory factory = agg.getAggregation().getFactory();
            aggregationFactories.put(column, factory);
        }
        ArrayList<TableColumnDescTyped> plainColumns = new ArrayList<TableColumnDescTyped>();
        ArrayList<TableColumnDescAgg> methodAggColumns = new ArrayList<TableColumnDescAgg>();
        ArrayList<TableColumnDescAgg> accessAggColumns = new ArrayList<TableColumnDescAgg>();
        LinkedHashMap<String, Object> allColumnsPublicTypes = new LinkedHashMap<String, Object>();
        for (TableColumnDesc column : columns) {
            if (column instanceof TableColumnDescTyped) {
                TableColumnDescTyped typed = (TableColumnDescTyped)column;
                plainColumns.add(typed);
                allColumnsPublicTypes.put(column.getColumnName(), typed.getUnresolvedType());
                continue;
            }
            TableColumnDescAgg agg = (TableColumnDescAgg)column;
            AggregationForgeFactory aggFactory = (AggregationForgeFactory)aggregationFactories.get(agg);
            if (aggFactory.isAccessAggregation()) {
                accessAggColumns.add(agg);
            } else {
                methodAggColumns.add(agg);
            }
            Object type = agg.getAggregation().getEvaluationType();
            type = type == null ? EPTypeNull.INSTANCE : type;
            allColumnsPublicTypes.put(column.getColumnName(), type);
        }
        LinkedHashMap<String, TableMetadataColumn> columnMetadata = new LinkedHashMap<String, TableMetadataColumn>();
        LinkedHashMap<String, Object> allColumnPrivateTypes = new LinkedHashMap<String, Object>();
        allColumnPrivateTypes.put(INTERNAL_RESERVED_PROPERTY, EPTypePremade.OBJECT.getEPType());
        int indexPlain = 1;
        TableMetadataColumnPairPlainCol[] assignPairsPlain = new TableMetadataColumnPairPlainCol[plainColumns.size()];
        for (TableColumnDescTyped typedColumn : plainColumns) {
            allColumnPrivateTypes.put(typedColumn.getColumnName(), typedColumn.getUnresolvedType());
            columnMetadata.put(typedColumn.getColumnName(), new TableMetadataColumnPlain(typedColumn.getColumnName(), typedColumn.isKey(), indexPlain));
            assignPairsPlain[indexPlain - 1] = new TableMetadataColumnPairPlainCol(typedColumn.getPositionInDeclaration(), indexPlain);
            ++indexPlain;
        }
        LinkedHashMap<String, Object> allColumnPrivateTypesCompiled = EventTypeUtility.compileMapTypeProperties(allColumnPrivateTypes, services.getEventTypeCompileTimeResolver());
        LinkedHashMap<String, Object> allColumnsPublicTypesCompiled = EventTypeUtility.compileMapTypeProperties(allColumnsPublicTypes, services.getEventTypeCompileTimeResolver());
        NameAccessModifier visibility = services.getModuleVisibilityRules().getAccessModifierTable(this.base, tableName);
        String internalName = EventTypeNameUtil.getTableInternalTypeName(tableName);
        EventTypeMetadata internalMetadata = new EventTypeMetadata(internalName, this.base.getModuleName(), EventTypeTypeClass.TABLE_INTERNAL, EventTypeApplicationType.OBJECTARR, visibility, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        ObjectArrayEventType internalEventType = BaseNestableEventUtil.makeOATypeCompileTime(internalMetadata, allColumnPrivateTypesCompiled, null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
        services.getEventTypeCompileTimeRegistry().newType(internalEventType);
        String publicName = EventTypeNameUtil.getTablePublicTypeName(tableName);
        EventTypeMetadata publicMetadata = new EventTypeMetadata(publicName, this.base.getModuleName(), EventTypeTypeClass.TABLE_PUBLIC, EventTypeApplicationType.OBJECTARR, visibility, EventTypeBusModifier.NONBUS, false, EventTypeIdPair.unassigned());
        ObjectArrayEventType publicEventType = BaseNestableEventUtil.makeOATypeCompileTime(publicMetadata, allColumnsPublicTypesCompiled, null, null, null, null, services.getBeanEventTypeFactoryPrivate(), services.getEventTypeCompileTimeResolver());
        services.getEventTypeCompileTimeRegistry().newType(publicEventType);
        AggregationForgeFactory[] methodFactories = new AggregationForgeFactory[methodAggColumns.size()];
        int index = 0;
        TableMetadataColumnPairAggMethod[] assignPairsMethod = new TableMetadataColumnPairAggMethod[methodAggColumns.size()];
        for (TableColumnDescAgg column : methodAggColumns) {
            AggregationForgeFactory factory = (AggregationForgeFactory)aggregationFactories.get(column);
            EPChainableType optionalEnumerationType = EPChainableTypeHelper.optionalFromEnumerationExpr(statementRawInfo, services, column.getAggregation());
            methodFactories[index] = factory;
            AggregationPortableValidation bindingInfo = factory.getAggregationPortableValidation();
            String expression = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(factory.getAggregationExpression());
            columnMetadata.put(column.getColumnName(), new TableMetadataColumnAggregation(column.getColumnName(), false, index, bindingInfo, expression, true, optionalEnumerationType));
            assignPairsMethod[index] = new TableMetadataColumnPairAggMethod(column.getPositionInDeclaration());
            ++index;
        }
        AggregationStateFactoryForge[] stateFactories = new AggregationStateFactoryForge[accessAggColumns.size()];
        AggregationAccessorSlotPairForge[] accessAccessorForges = new AggregationAccessorSlotPairForge[accessAggColumns.size()];
        TableMetadataColumnPairAggAccess[] assignPairsAccess = new TableMetadataColumnPairAggAccess[accessAggColumns.size()];
        int accessNum = 0;
        for (TableColumnDescAgg column : accessAggColumns) {
            AggregationStateFactoryForge forge;
            AggregationForgeFactory factory = (AggregationForgeFactory)aggregationFactories.get(column);
            stateFactories[accessNum] = forge = factory.getAggregationStateFactory(false, false);
            AggregationAccessorForge accessor = factory.getAccessorForge();
            AggregationPortableValidation bindingInfo = factory.getAggregationPortableValidation();
            accessAccessorForges[accessNum] = new AggregationAccessorSlotPairForge(accessNum, accessor);
            String expression = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(factory.getAggregationExpression());
            EPChainableType optionalEnumerationType = EPChainableTypeHelper.optionalFromEnumerationExpr(statementRawInfo, services, column.getAggregation());
            columnMetadata.put(column.getColumnName(), new TableMetadataColumnAggregation(column.getColumnName(), false, index, bindingInfo, expression, false, optionalEnumerationType));
            assignPairsAccess[accessNum] = new TableMetadataColumnPairAggAccess(column.getPositionInDeclaration(), accessor);
            ++index;
            ++accessNum;
        }
        ArrayList<String> primaryKeyColumns = new ArrayList<String>();
        ArrayList<EPTypeClass> primaryKeyTypes = new ArrayList<EPTypeClass>();
        ArrayList<EventPropertyGetterSPI> primaryKeyGetters = new ArrayList<EventPropertyGetterSPI>();
        ArrayList<Integer> primaryKeyColNums = new ArrayList<Integer>();
        int colNum = -1;
        for (TableColumnDescTyped typedColumn : plainColumns) {
            ++colNum;
            if (!typedColumn.isKey()) continue;
            primaryKeyColumns.add(typedColumn.getColumnName());
            EPType keyType = internalEventType.getPropertyEPType(typedColumn.getColumnName());
            if (keyType == null || keyType == EPTypeNull.INSTANCE) {
                throw new ExprValidationException("Column '" + typedColumn.getColumnName() + "' is null-type and may not be used in a primary key");
            }
            primaryKeyTypes.add((EPTypeClass)keyType);
            primaryKeyGetters.add(internalEventType.getGetterSPI(typedColumn.getColumnName()));
            primaryKeyColNums.add(colNum + 1);
        }
        String[] primaryKeyColumnArray = null;
        EPType[] primaryKeyTypeArray = null;
        EventPropertyGetterSPI[] primaryKeyGetterArray = null;
        int[] primaryKeyColNumsArray = null;
        if (!primaryKeyColumns.isEmpty()) {
            primaryKeyColumnArray = primaryKeyColumns.toArray(new String[primaryKeyColumns.size()]);
            primaryKeyTypeArray = primaryKeyTypes.toArray(new EPTypeClass[primaryKeyTypes.size()]);
            primaryKeyGetterArray = primaryKeyGetters.toArray(new EventPropertyGetterSPI[primaryKeyTypes.size()]);
            primaryKeyColNumsArray = IntArrayUtil.toArray(primaryKeyColNums);
        }
        AggregationRowStateForgeDesc forgeDesc = new AggregationRowStateForgeDesc(methodFactories, null, stateFactories, accessAccessorForges, new AggregationUseFlags(false, false, false));
        MultiKeyPlan multiKeyPlan = MultiKeyPlanner.planMultiKey(primaryKeyTypeArray, false, statementRawInfo, services.getSerdeResolver());
        DataInputOutputSerdeForge[] propertyForges = new DataInputOutputSerdeForge[internalEventType.getPropertyNames().length - 1];
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(multiKeyPlan.getMultiKeyForgeables());
        for (int i = 1; i < internalEventType.getPropertyNames().length; ++i) {
            String propertyName = internalEventType.getPropertyNames()[i];
            Object propertyType = internalEventType.getTypes().get(propertyName);
            SerdeEventPropertyDesc desc = SerdeEventPropertyUtility.forgeForEventProperty(publicEventType, propertyName, propertyType, statementRawInfo, services.getSerdeResolver());
            propertyForges[i - 1] = desc.getForge();
            for (EventType eventType : desc.getNestedTypes()) {
                List<StmtClassForgeableFactory> serdeForgeables = SerdeEventTypeUtility.plan(eventType, statementRawInfo, services.getSerdeEventTypeRegistry(), services.getSerdeResolver(), services.getStateMgmtSettingsProvider());
                additionalForgeables.addAll(serdeForgeables);
            }
        }
        return new TableAccessAnalysisResult(columnMetadata, internalEventType, propertyForges, publicEventType, assignPairsPlain, assignPairsMethod, assignPairsAccess, forgeDesc, primaryKeyColumnArray, primaryKeyGetterArray, (EPTypeClass[])primaryKeyTypeArray, primaryKeyColNumsArray, multiKeyPlan.getClassRef(), additionalForgeables);
    }
}

