/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createvariable;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryUtil;
import com.espertech.esper.common.internal.context.aifactory.createvariable.CreateVariableView;
import com.espertech.esper.common.internal.context.aifactory.createvariable.StatementAgentInstanceFactoryCreateVariableResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.ExprEvaluatorContextStatement;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewSimpleWProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.variable.compiletime.VariableMetaData;
import com.espertech.esper.common.internal.epl.variable.core.VariableManagementService;
import com.espertech.esper.common.internal.epl.variable.core.VariableReader;
import com.espertech.esper.common.internal.util.NullableObject;
import java.util.ArrayList;

public class StatementAgentInstanceFactoryCreateVariable
implements StatementAgentInstanceFactory,
StatementReadyCallback {
    public static final EPTypeClass EPTYPE = new EPTypeClass(StatementAgentInstanceFactoryCreateVariable.class);
    private String variableName;
    private ExprEvaluator variableInitialValueExpr;
    private ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider;

    public void setResultSetProcessorFactoryProvider(ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider) {
        this.resultSetProcessorFactoryProvider = resultSetProcessorFactoryProvider;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setVariableInitialValueExpr(ExprEvaluator variableInitialValueExpr) {
        this.variableInitialValueExpr = variableInitialValueExpr;
    }

    public ResultSetProcessorFactoryProvider getResultSetProcessorFactoryProvider() {
        return this.resultSetProcessorFactoryProvider;
    }

    @Override
    public EventType getStatementEventType() {
        return this.resultSetProcessorFactoryProvider.getResultEventType();
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        VariableMetaData meta = moduleIncidentals.getVariables().get(this.variableName);
        if (meta == null) {
            throw new UnsupportedOperationException("Missing variable information '" + this.variableName + "'");
        }
        if (meta.getValueWhenAvailable() == null && this.variableInitialValueExpr != null && meta.getOptionalContextName() == null && !recovery) {
            Object initialValue = this.variableInitialValueExpr.evaluate(null, true, new ExprEvaluatorContextStatement(statementContext, false));
            VariableManagementService svc = statementContext.getVariableManagementService();
            svc.checkAndWrite(statementContext.getDeploymentId(), this.variableName, -1, initialValue);
            svc.commit();
            svc.setLocalVersion();
        }
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
        statementContext.getVariableManagementService().removeVariableIfFound(statementContext.getDeploymentId(), this.variableName);
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(final AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        VariableManagementService variableService = agentInstanceContext.getVariableManagementService();
        final String deploymentId = agentInstanceContext.getDeploymentId();
        final int agentInstanceId = agentInstanceContext.getAgentInstanceId();
        ArrayList<AgentInstanceMgmtCallback> stopCallbacks = new ArrayList<AgentInstanceMgmtCallback>(2);
        if (agentInstanceContext.getContextProperties() != null) {
            NullableObject<Object> initialValue = null;
            if (this.variableInitialValueExpr != null) {
                initialValue = new NullableObject<Object>(this.variableInitialValueExpr.evaluate(null, true, agentInstanceContext));
            }
            agentInstanceContext.getVariableManagementService().allocateVariableState(agentInstanceContext.getDeploymentId(), this.variableName, agentInstanceContext.getAgentInstanceId(), isRecoveringResilient, initialValue, agentInstanceContext.getEventBeanTypedEventFactory());
        }
        stopCallbacks.add(new AgentInstanceMgmtCallback(){

            @Override
            public void stop(AgentInstanceStopServices services) {
                services.getAgentInstanceContext().getVariableManagementService().deallocateVariableState(services.getAgentInstanceContext().getDeploymentId(), StatementAgentInstanceFactoryCreateVariable.this.variableName, agentInstanceContext.getAgentInstanceId());
            }
        });
        VariableReader reader = variableService.getReader(deploymentId, this.variableName, agentInstanceContext.getAgentInstanceId());
        final CreateVariableView createVariableView = new CreateVariableView(this, agentInstanceContext, reader);
        variableService.registerCallback(deploymentId, this.variableName, agentInstanceContext.getAgentInstanceId(), createVariableView);
        stopCallbacks.add(new AgentInstanceMgmtCallback(){

            @Override
            public void stop(AgentInstanceStopServices services) {
                services.getAgentInstanceContext().getVariableManagementService().unregisterCallback(deploymentId, StatementAgentInstanceFactoryCreateVariable.this.variableName, agentInstanceId, createVariableView);
            }
        });
        Pair<ResultSetProcessor, AggregationService> pair = StatementAgentInstanceFactoryUtil.startResultSetAndAggregation(this.resultSetProcessorFactoryProvider, agentInstanceContext, false, null);
        OutputProcessViewSimpleWProcessor out = new OutputProcessViewSimpleWProcessor(agentInstanceContext, pair.getFirst());
        out.setParent(createVariableView);
        createVariableView.setChild(out);
        AgentInstanceMgmtCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
        return new StatementAgentInstanceFactoryCreateVariableResult(out, stopCallback, agentInstanceContext);
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext, agentInstanceId);
    }
}

