/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.createwindow;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.activator.ViewableActivationResult;
import com.espertech.esper.common.internal.context.activator.ViewableActivatorFilter;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleIncidentals;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactory;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryUtil;
import com.espertech.esper.common.internal.context.aifactory.createwindow.StatementAgentInstanceFactoryCreateNWResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.module.StatementReadyCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceUtil;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationService;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindow;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowRootViewInstance;
import com.espertech.esper.common.internal.epl.namedwindow.core.NamedWindowTailViewInstance;
import com.espertech.esper.common.internal.epl.output.core.OutputProcessViewSimpleWProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessorFactoryProvider;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWView;
import com.espertech.esper.common.internal.epl.virtualdw.VirtualDWViewFactory;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryUtil;
import com.espertech.esper.common.internal.view.core.ViewProcessingException;
import com.espertech.esper.common.internal.view.core.Viewable;
import com.espertech.esper.common.internal.view.core.ViewablePair;
import java.util.ArrayList;
import javax.naming.NamingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementAgentInstanceFactoryCreateNW
implements StatementAgentInstanceFactory,
StatementReadyCallback {
    public static final EPTypeClass EPTYPE = new EPTypeClass(StatementAgentInstanceFactoryCreateNW.class);
    private static final Logger log = LoggerFactory.getLogger(StatementAgentInstanceFactoryCreateNW.class);
    private ViewableActivatorFilter activator;
    private String namedWindowName;
    private ViewFactory[] viewFactories;
    private ExprEvaluator insertFromFilter;
    private NamedWindow insertFromNamedWindow;
    private EventType asEventType;
    private ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider;

    public void setActivator(ViewableActivatorFilter activator) {
        this.activator = activator;
    }

    public void setNamedWindowName(String namedWindowName) {
        this.namedWindowName = namedWindowName;
    }

    public void setViewFactories(ViewFactory[] viewFactories) {
        this.viewFactories = viewFactories;
    }

    public void setInsertFromNamedWindow(NamedWindow insertFromNamedWindow) {
        this.insertFromNamedWindow = insertFromNamedWindow;
    }

    public void setInsertFromFilter(ExprEvaluator insertFromFilter) {
        this.insertFromFilter = insertFromFilter;
    }

    public void setAsEventType(EventType asEventType) {
        this.asEventType = asEventType;
    }

    public void setResultSetProcessorFactoryProvider(ResultSetProcessorFactoryProvider resultSetProcessorFactoryProvider) {
        this.resultSetProcessorFactoryProvider = resultSetProcessorFactoryProvider;
    }

    @Override
    public EventType getStatementEventType() {
        return this.activator.getEventType();
    }

    @Override
    public void ready(StatementContext statementContext, ModuleIncidentals moduleIncidentals, boolean recovery) {
        NamedWindow namedWindow = statementContext.getNamedWindowManagementService().getNamedWindow(statementContext.getDeploymentId(), this.namedWindowName);
        namedWindow.setStatementContext(statementContext);
    }

    @Override
    public void statementCreate(StatementContext statementContext) {
        if (statementContext.getContextRuntimeDescriptor() != null && this.asEventType != null) {
            NamedWindow namedWindow = statementContext.getNamedWindowManagementService().getNamedWindow(statementContext.getDeploymentId(), this.namedWindowName);
            statementContext.getFilterSharedLookupableRepository().applyLookupableFromType(this.asEventType, namedWindow.getRootView().getEventType(), statementContext.getStatementId());
        }
    }

    @Override
    public void statementDestroy(StatementContext statementContext) {
        if (this.viewFactories[0] instanceof VirtualDWViewFactory) {
            ((VirtualDWViewFactory)this.viewFactories[0]).destroy();
        }
        statementContext.getNamedWindowManagementService().destroyNamedWindow(statementContext.getDeploymentId(), this.namedWindowName);
    }

    @Override
    public StatementAgentInstanceFactoryResult newContext(AgentInstanceContext agentInstanceContext, boolean isRecoveringResilient) {
        Viewable finalView;
        Viewable topView;
        NamedWindowInstance namedWindowInstance;
        Viewable eventStreamParentViewable;
        ViewableActivationResult viewableActivationResult;
        ArrayList<AgentInstanceMgmtCallback> stopCallbacks = new ArrayList<AgentInstanceMgmtCallback>();
        try {
            viewableActivationResult = this.activator.activate(agentInstanceContext, false, isRecoveringResilient);
            stopCallbacks.add(viewableActivationResult.getStopCallback());
            eventStreamParentViewable = viewableActivationResult.getViewable();
            NamedWindow namedWindow = agentInstanceContext.getNamedWindowManagementService().getNamedWindow(agentInstanceContext.getDeploymentId(), this.namedWindowName);
            if (namedWindow == null) {
                throw new RuntimeException("Failed to obtain named window '" + this.namedWindowName + "'");
            }
            namedWindowInstance = new NamedWindowInstance(namedWindow, agentInstanceContext);
            NamedWindowRootViewInstance rootView = namedWindowInstance.getRootViewInstance();
            AgentInstanceViewFactoryChainContext viewFactoryChainContext = new AgentInstanceViewFactoryChainContext(agentInstanceContext, true, null, null, null);
            ViewablePair viewables = ViewFactoryUtil.materialize(this.viewFactories, eventStreamParentViewable, viewFactoryChainContext, stopCallbacks);
            eventStreamParentViewable.setChild(rootView);
            rootView.setParent(eventStreamParentViewable);
            topView = viewables.getTop();
            rootView.setChild((View)topView);
            finalView = viewables.getLast();
            CreateNWVirtualDWMgmtCallback envStopCallback = null;
            if (finalView instanceof VirtualDWView) {
                String objectName = "/virtualdw/" + this.namedWindowName;
                VirtualDWView virtualDWView = (VirtualDWView)((Object)finalView);
                try {
                    agentInstanceContext.getRuntimeEnvContext().bind(objectName, (Object)virtualDWView.getVirtualDataWindow());
                }
                catch (NamingException e) {
                    throw new ViewProcessingException("Invalid name for adding to context:" + e.getMessage(), e);
                }
                envStopCallback = new CreateNWVirtualDWMgmtCallback(virtualDWView, objectName);
            }
            CreateNWAllInOneMgmtCallback allInOneStopMethod = new CreateNWAllInOneMgmtCallback(namedWindow, envStopCallback);
            stopCallbacks.add(allInOneStopMethod);
            NamedWindowTailViewInstance tailView = namedWindowInstance.getTailViewInstance();
            finalView.setChild(tailView);
            tailView.setParent(finalView);
            finalView = tailView;
            Pair<ResultSetProcessor, AggregationService> pair = StatementAgentInstanceFactoryUtil.startResultSetAndAggregation(this.resultSetProcessorFactoryProvider, agentInstanceContext, false, null);
            OutputProcessViewSimpleWProcessor out = new OutputProcessViewSimpleWProcessor(agentInstanceContext, pair.getFirst());
            finalView.setChild(out);
            out.setParent(finalView);
            finalView = out;
            if (this.insertFromNamedWindow != null && !isRecoveringResilient) {
                this.handleInsertFrom(agentInstanceContext, namedWindowInstance);
            }
        }
        catch (RuntimeException ex) {
            AgentInstanceMgmtCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
            AgentInstanceUtil.stopSafe(stopCallback, agentInstanceContext);
            throw new EPException(ex.getMessage(), ex);
        }
        AgentInstanceMgmtCallback stopCallback = AgentInstanceUtil.finalizeSafeStopCallbacks(stopCallbacks);
        return new StatementAgentInstanceFactoryCreateNWResult(finalView, stopCallback, agentInstanceContext, eventStreamParentViewable, topView, namedWindowInstance, viewableActivationResult);
    }

    public boolean[] getPriorFlagPerStream() {
        return null;
    }

    @Override
    public StatementAgentInstanceLock obtainAgentInstanceLock(StatementContext statementContext, int agentInstanceId) {
        return AgentInstanceUtil.newLock(statementContext, agentInstanceId);
    }

    private void handleInsertFrom(AgentInstanceContext agentInstanceContext, NamedWindowInstance processorInstance) {
        NamedWindowInstance sourceWindowInstances = this.insertFromNamedWindow.getNamedWindowInstance(agentInstanceContext);
        ArrayList<EventBean> events = new ArrayList<EventBean>();
        if (this.insertFromFilter != null) {
            EventBean[] eventsPerStream = new EventBean[1];
            for (EventBean candidate : sourceWindowInstances.getTailViewInstance()) {
                eventsPerStream[0] = candidate;
                Boolean result = (Boolean)this.insertFromFilter.evaluate(eventsPerStream, true, agentInstanceContext);
                if (result == null || !result.booleanValue()) continue;
                events.add(candidate);
            }
        } else {
            for (EventBean eventBean : sourceWindowInstances.getTailViewInstance()) {
                events.add(eventBean);
            }
        }
        if (events.size() > 0) {
            EventType rootViewType = processorInstance.getRootViewInstance().getEventType();
            EventBean[] convertedEvents = EventTypeUtility.typeCast(events, rootViewType, agentInstanceContext.getEventBeanTypedEventFactory(), agentInstanceContext.getEventTypeAvroHandler());
            processorInstance.getRootViewInstance().update(convertedEvents, null);
        }
    }

    @Override
    public AIRegistryRequirements getRegistryRequirements() {
        return AIRegistryRequirements.noRequirements();
    }

    public String getAsEventTypeName() {
        return this.asEventType == null ? null : this.asEventType.getName();
    }

    public static class CreateNWVirtualDWMgmtCallback
    implements AgentInstanceMgmtCallback {
        private final VirtualDWView virtualDWView;
        private final String objectName;

        public CreateNWVirtualDWMgmtCallback(VirtualDWView virtualDWView, String objectName) {
            this.virtualDWView = virtualDWView;
            this.objectName = objectName;
        }

        @Override
        public void stop(AgentInstanceStopServices stopServices) {
            try {
                this.virtualDWView.destroy();
                stopServices.getAgentInstanceContext().getRuntimeEnvContext().unbind(this.objectName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    public static class CreateNWAllInOneMgmtCallback
    implements AgentInstanceMgmtCallback {
        private final NamedWindow namedWindow;
        private final AgentInstanceMgmtCallback optionalEnvStopCallback;

        public CreateNWAllInOneMgmtCallback(NamedWindow namedWindow, AgentInstanceMgmtCallback optionalEnvStopCallback) {
            this.namedWindow = namedWindow;
            this.optionalEnvStopCallback = optionalEnvStopCallback;
        }

        @Override
        public void stop(AgentInstanceStopServices services) {
            NamedWindowInstance instance = this.namedWindow.getNamedWindowInstance(services.getAgentInstanceContext());
            if (instance == null) {
                log.warn("Named window processor by name '" + this.namedWindow.getName() + "' has not been found");
            } else {
                instance.destroy();
            }
            if (this.optionalEnvStopCallback != null) {
                this.optionalEnvStopCallback.stop(services);
            }
        }

        @Override
        public void transfer(AgentInstanceTransferServices services) {
        }
    }
}

