/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.ontrigger.onsplit;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.annotation.AuditEnum;
import com.espertech.esper.common.internal.collection.UniformPair;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.onsplit.OnSplitItemEval;
import com.espertech.esper.common.internal.context.aifactory.ontrigger.onsplit.RouteResultViewHandler;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandle;
import com.espertech.esper.common.internal.context.util.InternalEventRouter;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.epl.resultset.core.ResultSetProcessor;
import com.espertech.esper.common.internal.epl.table.core.TableInstance;

public abstract class RouteResultViewHandlerBase
implements RouteResultViewHandler {
    protected final InternalEventRouter internalEventRouter;
    private final TableInstance[] tableStateInstances;
    protected final OnSplitItemEval[] items;
    protected final EPStatementHandle epStatementHandle;
    protected final ResultSetProcessor[] processors;
    protected final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceContext agentInstanceContext;
    protected final boolean audit;

    public RouteResultViewHandlerBase(EPStatementHandle epStatementHandle, InternalEventRouter internalEventRouter, TableInstance[] tableStateInstances, OnSplitItemEval[] items, ResultSetProcessor[] processors, AgentInstanceContext agentInstanceContext) {
        this.internalEventRouter = internalEventRouter;
        this.tableStateInstances = tableStateInstances;
        this.items = items;
        this.epStatementHandle = epStatementHandle;
        this.processors = processors;
        this.agentInstanceContext = agentInstanceContext;
        this.audit = AuditEnum.INSERT.getAudit(agentInstanceContext.getAnnotations()) != null;
    }

    boolean checkWhereClauseCurrentEvent(int index, ExprEvaluatorContext exprEvaluatorContext) {
        boolean pass = true;
        ExprEvaluator itemWhereClause = this.items[index].getWhereClause();
        if (itemWhereClause != null) {
            this.agentInstanceContext.getInstrumentationProvider().qSplitStreamWhere(index);
            Boolean passEvent = (Boolean)itemWhereClause.evaluate(this.eventsPerStream, true, exprEvaluatorContext);
            if (passEvent == null || !passEvent.booleanValue()) {
                pass = false;
            }
            this.agentInstanceContext.getInstrumentationProvider().aSplitStreamWhere(pass);
        }
        return pass;
    }

    boolean mayRouteCurrentEvent(int index, ExprEvaluatorContext exprEvaluatorContext) {
        this.agentInstanceContext.getInstrumentationProvider().qSplitStreamRoute(index);
        OnSplitItemEval eval = this.items[index];
        UniformPair<EventBean[]> result = this.processors[index].processViewResult(this.eventsPerStream, null, false);
        boolean routed = false;
        if (result != null && result.getFirst() != null && result.getFirst().length > 0) {
            EventBean routedEvent = result.getFirst()[0];
            int precedence = ExprNodeUtilityEvaluate.evaluateIntOptional(eval.getEventPrecedence(), routedEvent, 0, exprEvaluatorContext);
            this.route(routedEvent, index, exprEvaluatorContext, precedence);
            routed = true;
        }
        this.agentInstanceContext.getInstrumentationProvider().aSplitStreamRoute();
        return routed;
    }

    private void route(EventBean routed, int index, ExprEvaluatorContext exprEvaluatorContext, int priority) {
        TableInstance tableStateInstance;
        if (this.audit) {
            exprEvaluatorContext.getAuditProvider().insert(routed, exprEvaluatorContext);
        }
        if ((tableStateInstance = this.tableStateInstances[index]) != null) {
            tableStateInstance.addEventUnadorned(routed);
        } else {
            boolean isNamedWindowInsert = this.items[index].isNamedWindowInsert();
            this.agentInstanceContext.getInternalEventRouter().route(routed, this.agentInstanceContext, isNamedWindowInsert, priority);
        }
    }
}

