/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.aifactory.update;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenPackageScope;
import com.espertech.esper.common.internal.bytecodemodel.core.CodeGenerationIDGenerator;
import com.espertech.esper.common.internal.compile.stage1.spec.NamedWindowConsumerStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.OnTriggerSetAssignment;
import com.espertech.esper.common.internal.compile.stage1.spec.StreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage1.spec.TableQueryStreamSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.UpdateDesc;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecTracked;
import com.espertech.esper.common.internal.compile.stage2.FilterStreamSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementBaseInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.compile.stage3.StatementInformationalsUtil;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeable;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtFields;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableStmtProvider;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethod;
import com.espertech.esper.common.internal.compile.stage3.StmtForgeMethodResult;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterDescFactory;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterDescForge;
import com.espertech.esper.common.internal.context.aifactory.update.StatementAgentInstanceFactoryUpdateForge;
import com.espertech.esper.common.internal.context.aifactory.update.StmtClassForgeableAIFactoryProviderUpdate;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryProvider;
import com.espertech.esper.common.internal.context.module.StatementFields;
import com.espertech.esper.common.internal.context.module.StatementInformationalsCompileTime;
import com.espertech.esper.common.internal.context.module.StatementProvider;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.subquery.ExprSubselectNode;
import com.espertech.esper.common.internal.epl.resultset.select.core.SelectSubscriberDescriptor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationDesc;
import com.espertech.esper.common.internal.epl.subselect.SubSelectActivationPlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectFactoryForge;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperActivations;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlan;
import com.espertech.esper.common.internal.epl.subselect.SubSelectHelperForgePlanner;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.statement.helper.EPStatementStartMethodHelperValidate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class StmtForgeMethodUpdate
implements StmtForgeMethod {
    private final StatementBaseInfo base;

    public StmtForgeMethodUpdate(StatementBaseInfo base) {
        this.base = base;
    }

    @Override
    public StmtForgeMethodResult make(String packageName, String classPostfix, StatementCompileTimeServices services) throws ExprValidationException {
        EventType streamEventType;
        String triggereventTypeName;
        StatementSpecCompiled statementSpec = this.base.getStatementSpec();
        String contextName = this.base.getStatementSpec().getRaw().getOptionalContextName();
        if (contextName != null) {
            throw new ExprValidationException("Update IStream is not supported in conjunction with a context");
        }
        StreamSpecCompiled streamSpec = statementSpec.getStreamSpecs()[0];
        UpdateDesc updateSpec = statementSpec.getRaw().getUpdateDesc();
        ArrayList<StmtClassForgeableFactory> additionalForgeables = new ArrayList<StmtClassForgeableFactory>(2);
        FabricCharge fabricCharge = services.getStateMgmtSettingsProvider().newCharge();
        if (streamSpec instanceof FilterStreamSpecCompiled) {
            FilterStreamSpecCompiled filterStreamSpec = (FilterStreamSpecCompiled)streamSpec;
            triggereventTypeName = filterStreamSpec.getFilterSpecCompiled().getFilterForEventTypeName();
            streamEventType = filterStreamSpec.getFilterSpecCompiled().getFilterForEventType();
        } else if (streamSpec instanceof NamedWindowConsumerStreamSpec) {
            NamedWindowConsumerStreamSpec namedSpec = (NamedWindowConsumerStreamSpec)streamSpec;
            streamEventType = namedSpec.getNamedWindow().getEventType();
            triggereventTypeName = streamEventType.getName();
        } else {
            if (streamSpec instanceof TableQueryStreamSpec) {
                throw new ExprValidationException("Tables cannot be used in an update-istream statement");
            }
            throw new ExprValidationException("Unknown stream specification streamEventType: " + streamSpec);
        }
        String streamName = triggereventTypeName;
        if (updateSpec.getOptionalStreamName() != null) {
            streamName = updateSpec.getOptionalStreamName();
        }
        StreamTypeServiceImpl typeService = new StreamTypeServiceImpl(new EventType[]{streamEventType}, new String[]{streamName}, new boolean[]{true}, false, false);
        ArrayList<FilterSpecTracked> filterSpecCompileds = new ArrayList<FilterSpecTracked>();
        ArrayList<NamedWindowConsumerStreamSpec> namedWindowConsumers = new ArrayList<NamedWindowConsumerStreamSpec>();
        SubSelectActivationDesc subSelectActivationDesc = SubSelectHelperActivations.createSubSelectActivation(false, filterSpecCompileds, namedWindowConsumers, this.base, services);
        additionalForgeables.addAll(subSelectActivationDesc.getAdditionalForgeables());
        fabricCharge.add(subSelectActivationDesc.getFabricCharge());
        Map<ExprSubselectNode, SubSelectActivationPlan> subselectActivation = subSelectActivationDesc.getSubselects();
        SubSelectHelperForgePlan subSelectForgePlan = SubSelectHelperForgePlanner.planSubSelect(this.base, subselectActivation, typeService.getStreamNames(), typeService.getEventTypes(), new String[]{triggereventTypeName}, services);
        Map<ExprSubselectNode, SubSelectFactoryForge> subselectForges = subSelectForgePlan.getSubselects();
        additionalForgeables.addAll(subSelectForgePlan.getAdditionalForgeables());
        fabricCharge.add(subSelectForgePlan.getFabricCharge());
        ExprValidationContext validationContext = new ExprValidationContextBuilder(typeService, this.base.getStatementRawInfo(), services).build();
        for (OnTriggerSetAssignment assignment : updateSpec.getAssignments()) {
            ExprNodeUtilityValidate.validateAssignment(false, ExprNodeOrigin.UPDATEASSIGN, assignment, validationContext);
        }
        if (updateSpec.getOptionalWhereClause() != null) {
            ExprNode validated = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.WHERE, updateSpec.getOptionalWhereClause(), validationContext);
            updateSpec.setOptionalWhereClause(validated);
            EPStatementStartMethodHelperValidate.validateNoAggregations(validated, "Aggregation functions may not be used within an update-clause");
        }
        InternalEventRouterDescForge routerDesc = InternalEventRouterDescFactory.getValidatePreprocessing(streamEventType, updateSpec, this.base.getStatementRawInfo().getAnnotations());
        String statementFieldsClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementFields.class, classPostfix);
        CodegenPackageScope packageScope = new CodegenPackageScope(packageName, statementFieldsClassName, services.isInstrumented(), services.getConfiguration().getCompiler().getByteCode());
        String aiFactoryProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementAIFactoryProvider.class, classPostfix);
        StatementAgentInstanceFactoryUpdateForge forge = new StatementAgentInstanceFactoryUpdateForge(routerDesc, subselectForges);
        StmtClassForgeableAIFactoryProviderUpdate aiFactoryForgeable = new StmtClassForgeableAIFactoryProviderUpdate(aiFactoryProviderClassName, packageScope, forge);
        SelectSubscriberDescriptor selectSubscriberDescriptor = new SelectSubscriberDescriptor(new Class[]{streamEventType.getUnderlyingType()}, new String[]{"*"}, false, null, null);
        StatementInformationalsCompileTime informationals = StatementInformationalsUtil.getInformationals(this.base, filterSpecCompileds, Collections.emptyList(), Collections.emptyList(), false, selectSubscriberDescriptor, packageScope, services);
        String statementProviderClassName = CodeGenerationIDGenerator.generateClassNameSimple(StatementProvider.class, classPostfix);
        StmtClassForgeableStmtProvider stmtProvider = new StmtClassForgeableStmtProvider(aiFactoryProviderClassName, statementProviderClassName, informationals, packageScope);
        ArrayList<StmtClassForgeable> forgeables = new ArrayList<StmtClassForgeable>();
        for (StmtClassForgeableFactory additional : additionalForgeables) {
            forgeables.add(additional.make(packageScope, classPostfix));
        }
        forgeables.add(aiFactoryForgeable);
        forgeables.add(stmtProvider);
        forgeables.add(new StmtClassForgeableStmtFields(statementFieldsClassName, packageScope));
        return new StmtForgeMethodResult(forgeables, filterSpecCompileds, Collections.emptyList(), namedWindowConsumers, Collections.emptyList(), packageScope, fabricCharge);
    }
}

