/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.category;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierCategory;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.context.ContextPartitionSelectorById;
import com.espertech.esper.common.client.context.ContextPartitionSelectorCategory;
import com.espertech.esper.common.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.category.ContextControllerCategoryFactory;
import com.espertech.esper.common.internal.context.controller.category.ContextControllerCategorySvc;
import com.espertech.esper.common.internal.context.controller.category.ContextControllerDetailCategoryItem;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerBase;
import com.espertech.esper.common.internal.context.mgr.ContextControllerSelectorUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionInstantiationResult;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import java.util.Map;

public abstract class ContextControllerCategory
extends ContextControllerBase {
    protected final ContextControllerCategoryFactory factory;
    protected ContextControllerCategorySvc categorySvc;

    public ContextControllerCategory(ContextManagerRealization realization, ContextControllerCategoryFactory factory) {
        super(realization);
        this.factory = factory;
    }

    @Override
    public void activate(IntSeqKey path, Object[] parentPartitionKeys, EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern) {
        int count = 0;
        ContextControllerDetailCategoryItem[] categories = this.factory.getCategorySpec().getItems();
        int[] subpathOrCPIds = new int[categories.length];
        for (int i = 0; i < categories.length; ++i) {
            ContextPartitionInstantiationResult result = this.realization.contextPartitionInstantiate(path, count, this, null, null, parentPartitionKeys, count);
            subpathOrCPIds[i] = result.getSubpathOrCPId();
            ++count;
        }
        this.categorySvc.mgmtCreate(path, parentPartitionKeys, subpathOrCPIds);
    }

    @Override
    public void deactivate(IntSeqKey path, boolean terminateChildContexts) {
        int[] subpathIdorCPs = this.categorySvc.mgmtDelete(path);
        if (subpathIdorCPs != null && terminateChildContexts) {
            for (int i = 0; i < this.factory.getCategorySpec().getItems().length; ++i) {
                this.realization.contextPartitionTerminate(path, subpathIdorCPs[i], this, null, false, null);
            }
        }
    }

    @Override
    public ContextControllerCategoryFactory getFactory() {
        return this.factory;
    }

    @Override
    public void visitSelectedPartitions(IntSeqKey path, ContextPartitionSelector contextPartitionSelector, ContextPartitionVisitor visitor, ContextPartitionSelector[] selectorPerLevel) {
        if (contextPartitionSelector instanceof ContextPartitionSelectorCategory) {
            ContextPartitionSelectorCategory category = (ContextPartitionSelectorCategory)contextPartitionSelector;
            if (category.getLabels() == null || category.getLabels().isEmpty()) {
                return;
            }
            int[] ids = this.categorySvc.mgmtGetSubpathOrCPIds(path);
            if (ids != null) {
                int count = -1;
                for (ContextControllerDetailCategoryItem categoryItem : this.factory.getCategorySpec().getItems()) {
                    int subpathOrCPID = ids[++count];
                    if (!category.getLabels().contains(categoryItem.getName())) continue;
                    this.realization.contextPartitionRecursiveVisit(path, subpathOrCPID, this, visitor, selectorPerLevel);
                }
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filter = (ContextPartitionSelectorFiltered)contextPartitionSelector;
            int[] ids = this.categorySvc.mgmtGetSubpathOrCPIds(path);
            if (ids != null) {
                int count = -1;
                for (ContextControllerDetailCategoryItem categoryItem : this.factory.getCategorySpec().getItems()) {
                    ContextPartitionIdentifierCategory identifierCategory = new ContextPartitionIdentifierCategory(categoryItem.getName());
                    ++count;
                    if (this.factory.getFactoryEnv().isLeaf()) {
                        identifierCategory.setContextPartitionId(ids[count]);
                    }
                    if (!filter.filter(identifierCategory)) continue;
                    this.realization.contextPartitionRecursiveVisit(path, ids[count], this, visitor, selectorPerLevel);
                }
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorAll) {
            int[] ids = this.categorySvc.mgmtGetSubpathOrCPIds(path);
            if (ids != null) {
                for (int id : ids) {
                    this.realization.contextPartitionRecursiveVisit(path, id, this, visitor, selectorPerLevel);
                }
            }
            return;
        }
        if (contextPartitionSelector instanceof ContextPartitionSelectorById) {
            int[] ids;
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)contextPartitionSelector;
            for (int id : ids = this.categorySvc.mgmtGetSubpathOrCPIds(path)) {
                if (!byId.getContextPartitionIds().contains(id)) continue;
                this.realization.contextPartitionRecursiveVisit(path, id, this, visitor, selectorPerLevel);
            }
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorCategory.class}, contextPartitionSelector);
    }

    @Override
    public void destroy() {
        this.categorySvc.destroy();
    }

    @Override
    public final void transfer(IntSeqKey path, boolean transferChildContexts, AgentInstanceTransferServices xfer) {
        if (!transferChildContexts) {
            return;
        }
        int[] ids = this.categorySvc.mgmtGetSubpathOrCPIds(path);
        if (ids != null) {
            for (int id : ids) {
                this.realization.transferRecursive(path, id, this, xfer);
            }
        }
    }
}

