/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.condition;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorCrontab;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorImmediate;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorNever;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorPattern;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorTimePeriod;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCrontabImpl;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionFilter;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionImmediate;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNever;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionPattern;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionTimePeriod;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.schedule.ScheduleExpressionUtil;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;

public class ContextControllerConditionFactory {
    public static ContextControllerConditionNonHA getEndpoint(IntSeqKey conditionPath, Object[] partitionKeys, ContextConditionDescriptor endpoint, ContextControllerConditionCallback callback, ContextController controller) {
        if (endpoint instanceof ContextConditionDescriptorFilter) {
            ContextConditionDescriptorFilter filter = (ContextConditionDescriptorFilter)endpoint;
            return new ContextControllerConditionFilter(conditionPath, partitionKeys, filter, callback, controller);
        }
        if (endpoint instanceof ContextConditionDescriptorTimePeriod) {
            ContextConditionDescriptorTimePeriod timePeriod = (ContextConditionDescriptorTimePeriod)endpoint;
            long scheduleSlot = controller.getRealization().getAgentInstanceContextCreate().getScheduleBucket().allocateSlot();
            return new ContextControllerConditionTimePeriod(scheduleSlot, timePeriod, conditionPath, callback, controller);
        }
        if (endpoint instanceof ContextConditionDescriptorCrontab) {
            ContextConditionDescriptorCrontab crontab = (ContextConditionDescriptorCrontab)endpoint;
            ScheduleSpec[] schedules = new ScheduleSpec[crontab.getEvaluatorsPerCrontab().length];
            for (int i = 0; i < schedules.length; ++i) {
                schedules[i] = ScheduleExpressionUtil.crontabScheduleBuild(crontab.getEvaluatorsPerCrontab()[i], controller.getRealization().getAgentInstanceContextCreate());
            }
            long scheduleSlot = controller.getRealization().getAgentInstanceContextCreate().getScheduleBucket().allocateSlot();
            return new ContextControllerConditionCrontabImpl(conditionPath, scheduleSlot, schedules, crontab, callback, controller);
        }
        if (endpoint instanceof ContextConditionDescriptorPattern) {
            ContextConditionDescriptorPattern pattern = (ContextConditionDescriptorPattern)endpoint;
            return new ContextControllerConditionPattern(conditionPath, partitionKeys, pattern, callback, controller);
        }
        if (endpoint instanceof ContextConditionDescriptorNever) {
            return ContextControllerConditionNever.INSTANCE;
        }
        if (endpoint instanceof ContextConditionDescriptorImmediate) {
            return ContextControllerConditionImmediate.INSTANCE;
        }
        throw new IllegalStateException("Unrecognized context range endpoint " + endpoint.getClass());
    }
}

