/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.condition;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.compile.stage2.EvalNodeUtil;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorPattern;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCallback;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerEndConditionMatchEventProvider;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.mgr.ContextManagerUtil;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceTransferServices;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootNode;
import com.espertech.esper.common.internal.epl.pattern.core.EvalRootState;
import com.espertech.esper.common.internal.epl.pattern.core.EvalStateNodeVisitorStageTransfer;
import com.espertech.esper.common.internal.epl.pattern.core.PatternAgentInstanceContext;
import com.espertech.esper.common.internal.epl.pattern.core.PatternMatchCallback;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.MatchedEventMapImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class ContextControllerConditionPattern
implements ContextControllerConditionNonHA,
PatternMatchCallback {
    private final IntSeqKey conditionPath;
    private final Object[] partitionKeys;
    private final ContextConditionDescriptorPattern pattern;
    private final ContextControllerConditionCallback callback;
    private final ContextController controller;
    protected EvalRootState patternStopCallback;

    public ContextControllerConditionPattern(IntSeqKey conditionPath, Object[] partitionKeys, ContextConditionDescriptorPattern pattern, ContextControllerConditionCallback callback, ContextController controller) {
        this.conditionPath = conditionPath;
        this.partitionKeys = partitionKeys;
        this.pattern = pattern;
        this.callback = callback;
        this.controller = controller;
    }

    @Override
    public boolean activate(EventBean optionalTriggeringEvent, ContextControllerEndConditionMatchEventProvider endConditionMatchEventProvider, Map<String, Object> optionalTriggeringPattern) {
        if (this.patternStopCallback != null) {
            this.patternStopCallback.stop();
        }
        AgentInstanceContext agentInstanceContext = this.controller.getRealization().getAgentInstanceContextCreate();
        Function<FilterSpecActivatable, FilterValueSetParam[][]> contextAddendumFunction = filter -> ContextManagerUtil.computeAddendumNonStmt(this.partitionKeys, filter, this.controller.getRealization());
        PatternAgentInstanceContext patternAgentInstanceContext = new PatternAgentInstanceContext(this.pattern.getPatternContext(), agentInstanceContext, false, contextAddendumFunction);
        EvalRootNode rootNode = EvalNodeUtil.makeRootNodeFromFactory(this.pattern.getPattern(), patternAgentInstanceContext);
        MatchedEventMapImpl matchedEventMap = new MatchedEventMapImpl(this.pattern.getPatternContext().getMatchedEventMapMeta());
        if (optionalTriggeringEvent != null && endConditionMatchEventProvider != null) {
            endConditionMatchEventProvider.populateEndConditionFromTrigger(matchedEventMap, optionalTriggeringEvent);
        }
        if (optionalTriggeringPattern != null && endConditionMatchEventProvider != null) {
            endConditionMatchEventProvider.populateEndConditionFromTrigger(matchedEventMap, optionalTriggeringPattern, agentInstanceContext.getEventBeanTypedEventFactory());
        }
        ConditionPatternMatchCallback callback = new ConditionPatternMatchCallback(this);
        this.patternStopCallback = rootNode.start(callback, this.pattern.getPatternContext(), matchedEventMap, false);
        callback.forwardCalls = true;
        if (callback.isInvoked) {
            this.matchFound(Collections.emptyMap(), optionalTriggeringEvent);
        }
        return false;
    }

    @Override
    public void deactivate() {
        if (this.patternStopCallback == null) {
            return;
        }
        this.patternStopCallback.stop();
        this.patternStopCallback = null;
    }

    @Override
    public void matchFound(Map<String, Object> matchEvent, EventBean optionalTriggeringEvent) {
        Map<String, Object> matchEventInclusive = null;
        if (this.pattern.isInclusive()) {
            if (matchEvent.size() < 2) {
                matchEventInclusive = matchEvent;
            } else {
                LinkedHashMap<String, Object> ordered = new LinkedHashMap<String, Object>();
                for (String key : this.pattern.getTaggedEvents()) {
                    ordered.put(key, matchEvent.get(key));
                }
                for (String key : this.pattern.getArrayEvents()) {
                    ordered.put(key, matchEvent.get(key));
                }
                matchEventInclusive = ordered;
            }
        }
        if (this.pattern.getAsName() != null) {
            LinkedHashMap<String, Object> termEvent = new LinkedHashMap<String, Object>();
            for (String tag : this.pattern.getPatternTags()) {
                Object value = matchEvent.get(tag);
                if (value == null) continue;
                termEvent.put(tag, value);
            }
            MappedEventBean compositeEvent = this.controller.getRealization().getAgentInstanceContextCreate().getEventBeanTypedEventFactory().adapterForTypedMap(termEvent, this.pattern.getAsNameEventType());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(this.pattern.getAsName(), compositeEvent);
            matchEvent = data;
        }
        this.callback.rangeNotification(this.conditionPath, this, null, matchEvent, optionalTriggeringEvent, matchEventInclusive, matchEvent);
    }

    @Override
    public boolean isImmediate() {
        return this.pattern.isImmediate();
    }

    @Override
    public boolean isRunning() {
        return this.patternStopCallback != null;
    }

    @Override
    public Long getExpectedEndTime() {
        return null;
    }

    @Override
    public ContextConditionDescriptor getDescriptor() {
        return this.pattern;
    }

    @Override
    public void transfer(AgentInstanceTransferServices xfer) {
        this.patternStopCallback.accept(new EvalStateNodeVisitorStageTransfer(xfer));
    }

    public static class ConditionPatternMatchCallback
    implements PatternMatchCallback {
        private final ContextControllerConditionPattern condition;
        private boolean isInvoked;
        private boolean forwardCalls;

        public ConditionPatternMatchCallback(ContextControllerConditionPattern condition) {
            this.condition = condition;
        }

        @Override
        public void matchFound(Map<String, Object> matchEvent, EventBean optionalTriggeringEvent) {
            this.isInvoked = true;
            if (this.forwardCalls) {
                this.condition.matchFound(matchEvent, optionalTriggeringEvent);
            }
        }

        public boolean isInvoked() {
            return this.isInvoked;
        }
    }
}

