/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.core;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.compile.stage2.FilterSpecCompiled;
import com.espertech.esper.common.internal.compile.stage2.StatementSpecCompiled;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.namedwindow.path.NamedWindowMetaData;
import com.espertech.esper.common.internal.epl.util.StatementSpecCompiledAnalyzer;
import com.espertech.esper.common.internal.epl.util.StatementSpecCompiledAnalyzerResult;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import java.util.List;
import java.util.function.Supplier;

public class ContextControllerForgeUtil {
    public static void validateStatementKeyAndHash(Supplier<EventType>[] typeProvider, String contextName, StatementSpecCompiled spec, StatementCompileTimeServices compileTimeServices) throws ExprValidationException {
        boolean isCreateWindow;
        StatementSpecCompiledAnalyzerResult streamAnalysis = StatementSpecCompiledAnalyzer.analyzeFilters(spec);
        List<FilterSpecCompiled> filters = streamAnalysis.getFilters();
        boolean bl = isCreateWindow = spec.getRaw().getCreateWindowDesc() != null;
        if (!isCreateWindow) {
            for (FilterSpecCompiled filter : filters) {
                for (Supplier<EventType> item : typeProvider) {
                    String namedWindowContextName;
                    EventType itemEventType = item.get();
                    EventType stmtFilterType = filter.getFilterForEventType();
                    if (stmtFilterType == itemEventType) {
                        return;
                    }
                    if (EventTypeUtility.isTypeOrSubTypeOf(stmtFilterType, itemEventType)) {
                        return;
                    }
                    NamedWindowMetaData namedWindow = compileTimeServices.getNamedWindowCompileTimeResolver().resolve(stmtFilterType.getName());
                    if (namedWindow == null || (namedWindowContextName = namedWindow.getContextName()) == null || !namedWindowContextName.equals(contextName)) continue;
                    return;
                }
            }
            if (!filters.isEmpty()) {
                throw new ExprValidationException(ContextControllerForgeUtil.getTypeValidationMessage(contextName, filters.get(0).getFilterForEventType().getName()));
            }
            return;
        }
        if (spec.getRaw().getCreateWindowDesc().getColumns() != null && spec.getRaw().getCreateWindowDesc().getColumns().size() > 0) {
            throw new ExprValidationException("Segmented context '" + contextName + "' requires that named windows are associated to an existing event type and that the event type is listed among the partitions defined by the create-context statement");
        }
        String declaredAsName = spec.getRaw().getCreateWindowDesc().getAsEventTypeName();
        if (declaredAsName != null) {
            for (Supplier<EventType> item : typeProvider) {
                EventType itemEventType = item.get();
                if (!itemEventType.getName().equals(declaredAsName)) continue;
                return;
            }
            throw new ExprValidationException(ContextControllerForgeUtil.getTypeValidationMessage(contextName, declaredAsName));
        }
    }

    private static String getTypeValidationMessage(String contextName, String typeNameEx) {
        return "Segmented context '" + contextName + "' requires that any of the event types that are listed in the segmented context also appear in any of the filter expressions of the statement, type '" + typeNameEx + "' is not one of the types listed";
    }
}

