/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierHash;
import com.espertech.esper.common.client.context.ContextPartitionSelector;
import com.espertech.esper.common.client.context.ContextPartitionSelectorAll;
import com.espertech.esper.common.client.context.ContextPartitionSelectorById;
import com.espertech.esper.common.client.context.ContextPartitionSelectorFiltered;
import com.espertech.esper.common.client.context.ContextPartitionSelectorHash;
import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerBase;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashFactory;
import com.espertech.esper.common.internal.context.mgr.ContextControllerSelectorUtil;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionInstantiationResult;
import com.espertech.esper.common.internal.context.mgr.ContextPartitionVisitor;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import java.util.function.BiConsumer;

public abstract class ContextControllerHash
extends ContextControllerBase {
    protected final ContextControllerHashFactory factory;

    public ContextControllerHash(ContextManagerRealization realization, ContextControllerHashFactory factory) {
        super(realization);
        this.factory = factory;
    }

    protected abstract void visitPartitions(IntSeqKey var1, BiConsumer<Integer, Integer> var2);

    protected abstract int getSubpathOrCPId(IntSeqKey var1, int var2);

    @Override
    public void visitSelectedPartitions(IntSeqKey path, ContextPartitionSelector selector, ContextPartitionVisitor visitor, ContextPartitionSelector[] selectorPerLevel) {
        if (selector instanceof ContextPartitionSelectorHash) {
            ContextPartitionSelectorHash selectorHash = (ContextPartitionSelectorHash)selector;
            if (selectorHash.getHashes() == null || selectorHash.getHashes().isEmpty()) {
                return;
            }
            for (int hash2 : selectorHash.getHashes()) {
                int subpathOrCPId2 = this.getSubpathOrCPId(path, hash2);
                if (subpathOrCPId2 == -1) continue;
                this.realization.contextPartitionRecursiveVisit(path, subpathOrCPId2, this, visitor, selectorPerLevel);
            }
            return;
        }
        if (selector instanceof ContextPartitionSelectorFiltered) {
            ContextPartitionSelectorFiltered filter = (ContextPartitionSelectorFiltered)selector;
            ContextPartitionIdentifierHash identifierHash = new ContextPartitionIdentifierHash();
            this.visitPartitions(path, (hash, subpathOrCPId) -> {
                identifierHash.setHash((int)hash);
                if (this.factory.getFactoryEnv().isLeaf()) {
                    identifierHash.setContextPartitionId((Integer)subpathOrCPId);
                }
                if (filter.filter(identifierHash)) {
                    this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel);
                }
            });
            return;
        }
        if (selector instanceof ContextPartitionSelectorAll) {
            this.visitPartitions(path, (hash, subpathOrCPId) -> this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel));
            return;
        }
        if (selector instanceof ContextPartitionSelectorById) {
            ContextPartitionSelectorById byId = (ContextPartitionSelectorById)selector;
            this.visitPartitions(path, (hash, subpathOrCPId) -> {
                if (byId.getContextPartitionIds().contains(subpathOrCPId)) {
                    this.realization.contextPartitionRecursiveVisit(path, (int)subpathOrCPId, this, visitor, selectorPerLevel);
                }
            });
            return;
        }
        throw ContextControllerSelectorUtil.getInvalidSelector(new Class[]{ContextPartitionSelectorHash.class}, selector);
    }

    public AgentInstanceContext getAgentInstanceContextCreate() {
        return this.realization.getAgentInstanceContextCreate();
    }

    @Override
    public ContextControllerHashFactory getFactory() {
        return this.factory;
    }

    @Override
    public ContextManagerRealization getRealization() {
        return this.realization;
    }

    protected int[] activateByPreallocate(IntSeqKey path, Object[] parentPartitionKeys, EventBean optionalTriggeringEvent) {
        int granularity = this.factory.getHashSpec().getGranularity();
        int[] cpOrSubpathIds = new int[granularity];
        for (int i = 0; i < this.factory.getHashSpec().getGranularity(); ++i) {
            ContextPartitionInstantiationResult result = this.realization.contextPartitionInstantiate(path, i, this, optionalTriggeringEvent, null, parentPartitionKeys, i);
            cpOrSubpathIds[i] = result.getSubpathOrCPId();
        }
        return cpOrSubpathIds;
    }
}

