/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.hash;

import com.espertech.esper.common.client.context.ContextPartitionIdentifier;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierHash;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.context.aifactory.createwindow.StatementAgentInstanceFactoryCreateNW;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryFactoryMap;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryFactoryMultiPerm;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryRequirements;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.context.airegistry.StatementAIResourceRegistry;
import com.espertech.esper.common.internal.context.controller.core.ContextController;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactoryBase;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerDetailHash;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerDetailHashItem;
import com.espertech.esper.common.internal.context.controller.hash.ContextControllerHashImpl;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextManagerRealization;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;
import com.espertech.esper.common.internal.filterspec.FilterAddendumUtil;
import com.espertech.esper.common.internal.filterspec.FilterOperator;
import com.espertech.esper.common.internal.filterspec.FilterSpecActivatable;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParam;
import com.espertech.esper.common.internal.filterspec.FilterValueSetParamImpl;
import java.util.Map;

public class ContextControllerHashFactory
extends ContextControllerFactoryBase {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ContextControllerHashFactory.class);
    protected ContextControllerDetailHash hashSpec;

    public ContextControllerDetailHash getHashSpec() {
        return this.hashSpec;
    }

    public void setHashSpec(ContextControllerDetailHash hashSpec) {
        this.hashSpec = hashSpec;
    }

    @Override
    public ContextController create(ContextManagerRealization contextManagerRealization) {
        return new ContextControllerHashImpl(this, contextManagerRealization);
    }

    @Override
    public FilterValueSetParam[][] populateFilterAddendum(FilterSpecActivatable filterSpec, boolean forStatement, int nestingLevel, Object partitionKey, ContextControllerStatementDesc optionalStatementDesc, Map<Integer, ContextControllerStatementDesc> statements, AgentInstanceContext agentInstanceContextStatement) {
        boolean isCreateWindow = optionalStatementDesc != null && optionalStatementDesc.getLightweight().getStatementContext().getStatementInformationals().getStatementType() == StatementType.CREATE_WINDOW;
        ContextControllerDetailHashItem foundPartition = null;
        int hashCode = (Integer)partitionKey;
        if (!isCreateWindow) {
            foundPartition = ContextControllerHashFactory.findHashItemSpec(this.hashSpec, filterSpec);
        } else {
            StatementAgentInstanceFactoryCreateNW factory = (StatementAgentInstanceFactoryCreateNW)optionalStatementDesc.getLightweight().getStatementContext().getStatementAIFactoryProvider().getFactory();
            String declaredAsName = factory.getAsEventTypeName();
            for (ContextControllerDetailHashItem partitionItem : this.hashSpec.getItems()) {
                if (!partitionItem.getFilterSpecActivatable().getFilterForEventType().getName().equals(declaredAsName)) continue;
                foundPartition = partitionItem;
                break;
            }
        }
        if (foundPartition == null) {
            return null;
        }
        FilterValueSetParamImpl filter = new FilterValueSetParamImpl(foundPartition.getLookupable(), FilterOperator.EQUAL, hashCode);
        FilterValueSetParam[][] addendum = new FilterValueSetParam[][]{{filter}};
        FilterValueSetParam[][] partitionFilters = foundPartition.getFilterSpecActivatable().getValueSet(null, null, agentInstanceContextStatement, agentInstanceContextStatement.getStatementContextFilterEvalEnv());
        if (partitionFilters != null) {
            addendum = FilterAddendumUtil.addAddendum(partitionFilters, filter);
        }
        return addendum;
    }

    @Override
    public void populateContextProperties(Map<String, Object> props, Object allPartitionKey) {
    }

    @Override
    public StatementAIResourceRegistry allocateAgentInstanceResourceRegistry(AIRegistryRequirements registryRequirements) {
        if (this.hashSpec.getGranularity() <= 65536) {
            return AIRegistryUtil.allocateRegistries(registryRequirements, AIRegistryFactoryMultiPerm.INSTANCE);
        }
        return AIRegistryUtil.allocateRegistries(registryRequirements, AIRegistryFactoryMap.INSTANCE);
    }

    @Override
    public ContextPartitionIdentifier getContextPartitionIdentifier(Object partitionKey) {
        return new ContextPartitionIdentifierHash((Integer)partitionKey);
    }

    private static ContextControllerDetailHashItem findHashItemSpec(ContextControllerDetailHash hashSpec, FilterSpecActivatable filterSpec) {
        ContextControllerDetailHashItem foundPartition = null;
        for (ContextControllerDetailHashItem partitionItem : hashSpec.getItems()) {
            boolean typeOrSubtype = EventTypeUtility.isTypeOrSubTypeOf(filterSpec.getFilterForEventType(), partitionItem.getFilterSpecActivatable().getFilterForEventType());
            if (!typeOrSubtype) continue;
            foundPartition = partitionItem;
        }
        return foundPartition;
    }
}

