/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.initterm;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.context.ContextPartitionIdentifierInitiatedTerminated;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptor;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorCrontab;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorFilter;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorImmediate;
import com.espertech.esper.common.internal.context.controller.condition.ContextConditionDescriptorTimePeriod;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerCondition;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionCrontab;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerDetailInitiatedTerminated;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTerm;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermFactory;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermPartitionKey;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvc;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvcLevelAny;
import com.espertech.esper.common.internal.context.controller.initterm.ContextControllerInitTermSvcLevelOne;
import com.espertech.esper.common.internal.schedule.ScheduleComputeHelper;
import com.espertech.esper.common.internal.schedule.ScheduleExpressionUtil;
import com.espertech.esper.common.internal.schedule.ScheduleSpec;
import com.espertech.esper.common.internal.settings.ClasspathImportServiceRuntime;
import java.util.Collections;
import java.util.Map;

public class ContextControllerInitTermUtil {
    public static ContextControllerInitTermSvc getService(ContextControllerInitTermFactory factory) {
        if (factory.getFactoryEnv().isRoot()) {
            return new ContextControllerInitTermSvcLevelOne();
        }
        return new ContextControllerInitTermSvcLevelAny();
    }

    public static boolean determineCurrentlyRunning(ContextControllerCondition startCondition, ContextControllerInitTerm controller) {
        ContextConditionDescriptorTimePeriod descriptor;
        Long endTime;
        if (startCondition.isImmediate()) {
            return true;
        }
        ContextControllerDetailInitiatedTerminated spec = controller.getFactory().getInitTermSpec();
        if (spec.isOverlapping()) {
            return false;
        }
        if (spec.getStartCondition() instanceof ContextConditionDescriptorCrontab && spec.getEndCondition() instanceof ContextConditionDescriptorCrontab) {
            long nextScheduledEndTime;
            ScheduleSpec[] schedulesStart = ((ContextControllerConditionCrontab)((Object)startCondition)).getSchedules();
            ContextConditionDescriptorCrontab endCron = (ContextConditionDescriptorCrontab)spec.getEndCondition();
            ScheduleSpec[] schedulesEnd = new ScheduleSpec[endCron.getEvaluatorsPerCrontab().length];
            for (int i = 0; i < schedulesEnd.length; ++i) {
                schedulesEnd[i] = ScheduleExpressionUtil.crontabScheduleBuild(endCron.getEvaluatorsPerCrontab()[i], controller.getRealization().getAgentInstanceContextCreate());
            }
            ClasspathImportServiceRuntime classpathImportService = controller.getRealization().getAgentInstanceContextCreate().getClasspathImportServiceRuntime();
            long time = controller.getRealization().getAgentInstanceContextCreate().getSchedulingService().getTime();
            long nextScheduledStartTime = ContextControllerInitTermUtil.computeScheduleMinimumNextOccurance(schedulesStart, time, classpathImportService);
            return nextScheduledStartTime >= (nextScheduledEndTime = ContextControllerInitTermUtil.computeScheduleMinimumNextOccurance(schedulesEnd, time, classpathImportService));
        }
        if (startCondition.getDescriptor() instanceof ContextConditionDescriptorTimePeriod && (endTime = (descriptor = (ContextConditionDescriptorTimePeriod)startCondition.getDescriptor()).getExpectedEndTime(controller.getRealization())) != null && endTime <= 0L) {
            return true;
        }
        return startCondition instanceof ContextConditionDescriptorImmediate;
    }

    public static ContextControllerInitTermPartitionKey buildPartitionKey(EventBean optionalTriggeringEvent, Map<String, Object> optionalTriggeringPattern, ContextControllerCondition endCondition, ContextControllerInitTerm controller) {
        long startTime = controller.realization.getAgentInstanceContextCreate().getSchedulingService().getTime();
        Long expectedEndTime = endCondition.getExpectedEndTime();
        return new ContextControllerInitTermPartitionKey(optionalTriggeringEvent, optionalTriggeringPattern, startTime, expectedEndTime);
    }

    public static ContextPartitionIdentifierInitiatedTerminated keyToIdentifier(int subpathIdOrCPId, ContextControllerInitTermPartitionKey key, ContextControllerInitTerm controller) {
        ContextConditionDescriptorFilter filter;
        ContextPartitionIdentifierInitiatedTerminated identifier = new ContextPartitionIdentifierInitiatedTerminated();
        identifier.setStartTime(key.getStartTime());
        identifier.setEndTime(key.getExpectedEndTime());
        ContextConditionDescriptor start = controller.getFactory().getInitTermSpec().getStartCondition();
        if (start instanceof ContextConditionDescriptorFilter && (filter = (ContextConditionDescriptorFilter)start).getOptionalFilterAsName() != null) {
            identifier.setProperties(Collections.singletonMap(filter.getOptionalFilterAsName(), key.getTriggeringEvent()));
        }
        if (controller.getFactory().getFactoryEnv().isLeaf()) {
            identifier.setContextPartitionId(subpathIdOrCPId);
        }
        return identifier;
    }

    public static long computeScheduleMinimumNextOccurance(ScheduleSpec[] schedules, long time, ClasspathImportServiceRuntime classpathImportService) {
        long value = Long.MAX_VALUE;
        for (ScheduleSpec spec : schedules) {
            long computed = ScheduleComputeHelper.computeNextOccurance(spec, time, classpathImportService.getTimeZone(), classpathImportService.getTimeAbacus());
            if (computed >= value) continue;
            value = computed;
        }
        return value;
    }

    public static long computeScheduleMinimumDelta(ScheduleSpec[] schedules, long time, ClasspathImportServiceRuntime classpathImportService) {
        long value = Long.MAX_VALUE;
        for (ScheduleSpec spec : schedules) {
            long computed = ScheduleComputeHelper.computeDeltaNextOccurance(spec, time, classpathImportService.getTimeZone(), classpathImportService.getTimeAbacus());
            if (computed >= value) continue;
            value = computed;
        }
        return value;
    }
}

