/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.util.StateMgmtSetting;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecConditionFilter;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyed;
import com.espertech.esper.common.internal.compile.stage1.spec.ContextSpecKeyedItem;
import com.espertech.esper.common.internal.compile.stage2.StatementRawInfo;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.context.compile.ContextMetaData;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactoryEnv;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFactoryForgeVisitor;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerForgeBase;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerPortableInfo;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedFactory;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedUtil;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedValidation;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedValidationItem;
import com.espertech.esper.common.internal.context.util.ContextPropertyEventType;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.fabric.FabricCharge;
import com.espertech.esper.common.internal.statemgmtsettings.StateMgmtSettingDefault;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

public class ContextControllerKeyedFactoryForge
extends ContextControllerForgeBase {
    private final ContextSpecKeyed detail;
    private StateMgmtSetting terminationStateMgmtSettings = StateMgmtSettingDefault.INSTANCE;
    private StateMgmtSetting ctxStateMgmtSettings;

    public ContextControllerKeyedFactoryForge(ContextControllerFactoryEnv ctx, ContextSpecKeyed detail) throws ExprValidationException {
        super(ctx);
        this.detail = detail;
    }

    @Override
    public void validateGetContextProps(LinkedHashMap<String, Object> props, String contextName, int controllerLevel, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) throws ExprValidationException {
        EPType[] propertyTypes = ContextControllerKeyedUtil.validateContextDesc(contextName, this.detail);
        for (int i = 0; i < this.detail.getItems().get(0).getPropertyNames().size(); ++i) {
            String propertyName = "key" + (i + 1);
            props.put(propertyName, propertyTypes[i]);
        }
        LinkedHashSet<String> allTags = new LinkedHashSet<String>();
        for (ContextSpecKeyedItem item : this.detail.getItems()) {
            if (item.getAliasName() == null) continue;
            allTags.add(item.getAliasName());
        }
        if (this.detail.getOptionalInit() != null) {
            for (ContextSpecConditionFilter filter : this.detail.getOptionalInit()) {
                ContextPropertyEventType.addEndpointTypes(filter, props, allTags);
            }
        }
        if (this.detail.getOptionalTermination() != null) {
            ContextPropertyEventType.addEndpointTypes(this.detail.getOptionalTermination(), props, allTags);
        }
    }

    @Override
    public void planStateSettings(ContextMetaData detail, FabricCharge fabricCharge, int controllerLevel, String nestedContextName, StatementRawInfo statementRawInfo, StatementCompileTimeServices services) {
        if (this.detail.getOptionalTermination() != null) {
            this.terminationStateMgmtSettings = services.getStateMgmtSettingsProvider().context().contextKeyedTerm(fabricCharge, detail, this, statementRawInfo, controllerLevel);
        }
        this.ctxStateMgmtSettings = services.getStateMgmtSettingsProvider().context().contextKeyed(fabricCharge, detail, this, statementRawInfo, controllerLevel);
    }

    @Override
    public CodegenMethod makeCodegen(CodegenClassScope classScope, CodegenMethodScope parent, SAIFFInitializeSymbol symbols) {
        CodegenMethod method = parent.makeChild(ContextControllerKeyedFactory.EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVar(ContextControllerKeyedFactory.EPTYPE, "factory", (CodegenExpression)CodegenExpressionBuilder.exprDotMethodChain(symbols.getAddInitSvc(method)).add("getContextServiceFactory", new CodegenExpression[0]).add("keyedFactory", this.terminationStateMgmtSettings.toExpression(), this.ctxStateMgmtSettings.toExpression())).exprDotMethod(CodegenExpressionBuilder.ref("factory"), "setKeyedSpec", this.detail.makeCodegen(method, symbols, classScope)).methodReturn(CodegenExpressionBuilder.ref("factory"));
        return method;
    }

    @Override
    public ContextControllerPortableInfo getValidationInfo() {
        ContextControllerKeyedValidationItem[] items = new ContextControllerKeyedValidationItem[this.detail.getItems().size()];
        for (int i = 0; i < this.detail.getItems().size(); ++i) {
            ContextSpecKeyedItem props = this.detail.getItems().get(i);
            items[i] = new ContextControllerKeyedValidationItem(props.getFilterSpecCompiled().getFilterForEventType(), props.getPropertyNames().toArray(new String[props.getPropertyNames().size()]));
        }
        return new ContextControllerKeyedValidation(items);
    }

    public ContextSpecKeyed getDetail() {
        return this.detail;
    }

    @Override
    public <T> T accept(ContextControllerFactoryForgeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

