/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.controller.keyed;

import com.espertech.esper.common.internal.collection.IntSeqKey;
import com.espertech.esper.common.internal.context.controller.condition.ContextControllerConditionNonHA;
import com.espertech.esper.common.internal.context.controller.core.ContextControllerFilterEntry;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvc;
import com.espertech.esper.common.internal.context.controller.keyed.ContextControllerKeyedSvcEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class ContextControllerKeyedSvcLevelOne
implements ContextControllerKeyedSvc {
    private static final Object[] EMPTY_PARTITION_KEYS = new Object[0];
    private int currentSubpathId = 0;
    private ContextControllerFilterEntry[] filterEntries;
    private final Map<Object, ContextControllerKeyedSvcEntry> keys = new HashMap<Object, ContextControllerKeyedSvcEntry>();

    @Override
    public Object[] mgmtGetPartitionKeys(IntSeqKey controllerPath) {
        return EMPTY_PARTITION_KEYS;
    }

    @Override
    public int mgmtGetIncSubpath(IntSeqKey controllerPath) {
        int subpathId = this.currentSubpathId++;
        return subpathId;
    }

    @Override
    public void mgmtCreate(IntSeqKey controllerPath, Object[] parentPartitionKeys) {
    }

    @Override
    public void mgmtSetFilters(IntSeqKey controllerPath, ContextControllerFilterEntry[] filterEntries) {
        this.filterEntries = filterEntries;
    }

    @Override
    public ContextControllerFilterEntry[] mgmtGetFilters(IntSeqKey controllerPath) {
        return this.filterEntries;
    }

    @Override
    public boolean keyHasSeen(IntSeqKey controllerPath, Object key) {
        return this.keys.containsKey(key);
    }

    @Override
    public void keyAdd(IntSeqKey controllerPath, Object key, int subpathIdOrCPId, ContextControllerConditionNonHA terminationCondition) {
        this.keys.put(key, new ContextControllerKeyedSvcEntry(subpathIdOrCPId, terminationCondition));
    }

    @Override
    public ContextControllerKeyedSvcEntry keyRemove(IntSeqKey controllerPath, Object key) {
        return this.keys.remove(key);
    }

    @Override
    public List<ContextControllerConditionNonHA> keyGetTermConditions(IntSeqKey controllerPath) {
        ArrayList<ContextControllerConditionNonHA> conditions = new ArrayList<ContextControllerConditionNonHA>();
        for (Map.Entry<Object, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            conditions.add(entry.getValue().getTerminationCondition());
        }
        return conditions;
    }

    @Override
    public void keyVisit(IntSeqKey controllerPath, BiConsumer<Object, Integer> keyAndSubpathOrCPId) {
        for (Map.Entry<Object, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            keyAndSubpathOrCPId.accept(entry.getKey(), entry.getValue().getSubpathOrCPId());
        }
    }

    @Override
    public void keyVisitEntry(IntSeqKey controllerPath, Consumer<ContextControllerKeyedSvcEntry> consumer) {
        for (Map.Entry<Object, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            consumer.accept(entry.getValue());
        }
    }

    @Override
    public int keyGetSubpathOrCPId(IntSeqKey controllerPath, Object key) {
        ContextControllerKeyedSvcEntry entry = this.keys.get(key);
        return entry == null ? -1 : entry.getSubpathOrCPId();
    }

    @Override
    public Collection<Integer> deactivate(IntSeqKey controllerPath) {
        ArrayList<Integer> result = new ArrayList<Integer>(this.keys.size());
        for (Map.Entry<Object, ContextControllerKeyedSvcEntry> entry : this.keys.entrySet()) {
            result.add(entry.getValue().getSubpathOrCPId());
        }
        this.destroy();
        return result;
    }

    @Override
    public void destroy() {
        this.keys.clear();
        this.filterEntries = null;
    }
}

