/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.mgr;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.context.controller.core.ContextDefinition;
import com.espertech.esper.common.internal.context.mgr.ContextManager;
import com.espertech.esper.common.internal.context.mgr.ContextManagerResident;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextDeployment {
    private static final Logger log = LoggerFactory.getLogger(ContextDeployment.class);
    private final Map<String, ContextManager> contexts = new HashMap<String, ContextManager>(4);

    public void add(ContextDefinition contextDefinition, EPStatementInitServices services) {
        String contextName = contextDefinition.getContextName();
        ContextManager mgr = this.contexts.get(contextName);
        if (mgr != null) {
            throw new EPException("Context by name '" + contextDefinition.getContextName() + "' already exists");
        }
        ContextManagerResident contextManager = new ContextManagerResident(services.getDeploymentId(), contextDefinition);
        this.contexts.put(contextName, contextManager);
    }

    public ContextManager getContextManager(String contextName) {
        return this.contexts.get(contextName);
    }

    public int getContextCount() {
        return this.contexts.size();
    }

    public void destroyContext(String deploymentIdCreateContext, String contextName) {
        ContextManager entry = this.contexts.get(contextName);
        if (entry == null) {
            log.warn("Destroy for context '" + contextName + "' deployment-id '" + deploymentIdCreateContext + "' failed to locate");
            return;
        }
        entry.destroyContext();
        this.contexts.remove(contextName);
    }

    public Map<String, ContextManager> getContexts() {
        return this.contexts;
    }
}

