/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.mgr;

import com.espertech.esper.common.client.context.ContextStateEventContextDestroyed;
import com.espertech.esper.common.client.context.ContextStateListener;
import com.espertech.esper.common.internal.context.controller.core.ContextDefinition;
import com.espertech.esper.common.internal.context.mgr.ContextControllerStatementDesc;
import com.espertech.esper.common.internal.context.mgr.ContextDeployment;
import com.espertech.esper.common.internal.context.mgr.ContextManagementService;
import com.espertech.esper.common.internal.context.mgr.ContextManager;
import com.espertech.esper.common.internal.context.mgr.ContextStateEventUtil;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextManagementServiceImpl
implements ContextManagementService {
    private static final Logger log = LoggerFactory.getLogger(ContextManagementServiceImpl.class);
    private final CopyOnWriteArrayList<ContextStateListener> listeners = new CopyOnWriteArrayList();
    private final Map<String, ContextDeployment> deployments = new HashMap<String, ContextDeployment>();

    @Override
    public void addContext(ContextDefinition contextDefinition, EPStatementInitServices services) {
        ContextDeployment deployment = this.deployments.get(services.getDeploymentId());
        if (deployment == null) {
            deployment = new ContextDeployment();
            this.deployments.put(services.getDeploymentId(), deployment);
        }
        deployment.add(contextDefinition, services);
    }

    @Override
    public void addStatement(String deploymentIdCreateContext, String contextName, ContextControllerStatementDesc statement, boolean recovery) {
        ContextManager contextManager = this.getAssertContextManager(deploymentIdCreateContext, contextName);
        contextManager.addStatement(statement, recovery);
    }

    @Override
    public void stoppedStatement(String deploymentIdCreateContext, String contextName, int statementId, String statementName, String statementDeploymentId) {
        ContextManager contextManager = this.getAssertContextManager(deploymentIdCreateContext, contextName);
        contextManager.stopStatement(statementId, statementName, statementDeploymentId);
    }

    @Override
    public ContextManager getContextManager(String deploymentIdCreateContext, String contextName) {
        ContextDeployment deployment = this.deployments.get(deploymentIdCreateContext);
        if (deployment == null) {
            return null;
        }
        return deployment.getContextManager(contextName);
    }

    @Override
    public int getContextCount() {
        int count = 0;
        for (Map.Entry<String, ContextDeployment> entry : this.deployments.entrySet()) {
            count += entry.getValue().getContextCount();
        }
        return count;
    }

    @Override
    public void destroyedContext(String runtimeURI, String deploymentIdCreateContext, String contextName) {
        ContextDeployment deployment = this.deployments.get(deploymentIdCreateContext);
        if (deployment == null) {
            log.warn("Destroy for context '" + contextName + "' deployment-id '" + deploymentIdCreateContext + "' failed to locate");
            return;
        }
        deployment.destroyContext(deploymentIdCreateContext, contextName);
        if (deployment.getContextCount() == 0) {
            this.deployments.remove(deploymentIdCreateContext);
        }
        ContextStateEventUtil.dispatchContext(this.listeners, () -> new ContextStateEventContextDestroyed(runtimeURI, deploymentIdCreateContext, contextName), ContextStateListener::onContextDestroyed);
    }

    @Override
    public CopyOnWriteArrayList<ContextStateListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Map<String, ContextDeployment> getDeployments() {
        return this.deployments;
    }

    private ContextManager getAssertContextManager(String deploymentIdCreateContext, String contextName) {
        ContextManager contextManager = this.getContextManager(deploymentIdCreateContext, contextName);
        if (contextManager == null) {
            throw new IllegalArgumentException("Cannot find context for name '" + contextName + "' deployment-id '" + deploymentIdCreateContext + "'");
        }
        return contextManager;
    }
}

