/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.internal.context.util.EPStatementDispatch;
import com.espertech.esper.common.internal.context.util.EPStatementHandle;
import com.espertech.esper.common.internal.context.util.FilterFaultHandler;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceFilterVersion;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.statement.multimatch.MultiMatchHandler;

public class EPStatementAgentInstanceHandle {
    private final EPStatementHandle statementHandle;
    private final StatementAgentInstanceLock statementAgentInstanceLock;
    private final int agentInstanceId;
    private final int hashCode;
    private final StatementAgentInstanceFilterVersion statementFilterVersion = new StatementAgentInstanceFilterVersion();
    private EPStatementDispatch optionalDispatchable;
    private boolean destroyed;
    private FilterFaultHandler filterFaultHandler;

    public EPStatementAgentInstanceHandle(EPStatementHandle statementHandle, int agentInstanceId, StatementAgentInstanceLock statementAgentInstanceLock) {
        this.statementHandle = statementHandle;
        this.agentInstanceId = agentInstanceId;
        this.statementAgentInstanceLock = statementAgentInstanceLock;
        this.hashCode = 31 * statementHandle.hashCode() + agentInstanceId;
    }

    public StatementAgentInstanceLock getStatementAgentInstanceLock() {
        return this.statementAgentInstanceLock;
    }

    public int getAgentInstanceId() {
        return this.agentInstanceId;
    }

    public boolean isCanSelfJoin() {
        return this.statementHandle.isCanSelfJoin();
    }

    public int getPriority() {
        return this.statementHandle.getPriority();
    }

    public boolean isPreemptive() {
        return this.statementHandle.isPreemptive();
    }

    public boolean isHasVariables() {
        return this.statementHandle.isHasVariables();
    }

    public boolean isHasTableAccess() {
        return this.statementHandle.isHasTableAccess();
    }

    public StatementAgentInstanceFilterVersion getStatementFilterVersion() {
        return this.statementFilterVersion;
    }

    public boolean isCurrentFilter(long filterVersion) {
        return this.statementFilterVersion.isCurrentFilter(filterVersion);
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof EPStatementAgentInstanceHandle)) {
            return false;
        }
        EPStatementAgentInstanceHandle other = (EPStatementAgentInstanceHandle)otherObj;
        return other.getStatementHandle().getStatementId() == this.statementHandle.getStatementId() && other.agentInstanceId == this.agentInstanceId;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setOptionalDispatchable(EPStatementDispatch optionalDispatchable) {
        this.optionalDispatchable = optionalDispatchable;
    }

    public EPStatementDispatch getOptionalDispatchable() {
        return this.optionalDispatchable;
    }

    public void internalDispatch() {
        if (this.optionalDispatchable != null) {
            this.optionalDispatchable.execute();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public String toString() {
        return "EPStatementAgentInstanceHandle{name=" + this.statementHandle.getStatementName() + " id=" + this.agentInstanceId + "}";
    }

    public FilterFaultHandler getFilterFaultHandler() {
        return this.filterFaultHandler;
    }

    public void setFilterFaultHandler(FilterFaultHandler filterFaultHandler) {
        this.filterFaultHandler = filterFaultHandler;
    }

    public int getStatementId() {
        return this.statementHandle.getStatementId();
    }

    public MultiMatchHandler getMultiMatchHandler() {
        return this.statementHandle.getMultiMatchHandler();
    }

    public EPStatementHandle getStatementHandle() {
        return this.statementHandle;
    }
}

