/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.Drop;
import com.espertech.esper.common.client.annotation.Priority;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterDesc;
import com.espertech.esper.common.internal.context.aifactory.update.InternalEventRouterWriter;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.EPStatementHandle;
import com.espertech.esper.common.internal.context.util.InsertIntoListener;
import com.espertech.esper.common.internal.context.util.InternalEventRouteDest;
import com.espertech.esper.common.internal.context.util.InternalEventRouter;
import com.espertech.esper.common.internal.context.util.InternalEventRouterEntry;
import com.espertech.esper.common.internal.context.util.InternalEventRouterPreprocessor;
import com.espertech.esper.common.internal.context.util.InternalRoutePreprocessView;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.event.core.EventBeanCopyMethodForge;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.event.core.EventBeanWriter;
import com.espertech.esper.common.internal.event.core.EventTypeSPI;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.util.NullableObject;
import com.espertech.esper.common.internal.util.TypeWidener;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalEventRouterImpl
implements InternalEventRouter {
    private static final Logger log = LoggerFactory.getLogger(InternalEventRouterImpl.class);
    private final EventBeanTypedEventFactory eventBeanTypedEventFactory;
    private final ConcurrentHashMap<EventType, NullableObject<InternalEventRouterPreprocessor>> preprocessors;
    private final Map<InternalEventRouterDesc, IRDescEntry> descriptors;
    private boolean hasPreprocessing = false;
    private InsertIntoListener insertIntoListener;

    public InternalEventRouterImpl(EventBeanTypedEventFactory eventBeanTypedEventFactory) {
        this.eventBeanTypedEventFactory = eventBeanTypedEventFactory;
        this.preprocessors = new ConcurrentHashMap();
        this.descriptors = new LinkedHashMap<InternalEventRouterDesc, IRDescEntry>();
    }

    @Override
    public boolean isHasPreprocessing() {
        return this.hasPreprocessing;
    }

    @Override
    public EventBean preprocess(EventBean theEvent, ExprEvaluatorContext runtimeFilterAndDispatchTimeContext, InstrumentationCommon instrumentation) {
        return this.getPreprocessedEvent(theEvent, runtimeFilterAndDispatchTimeContext, instrumentation);
    }

    @Override
    public void setInsertIntoListener(InsertIntoListener insertIntoListener) {
        this.insertIntoListener = insertIntoListener;
    }

    @Override
    public void route(EventBean theEvent, AgentInstanceContext agentInstanceContext, boolean addToFront, int precedence) {
        this.route(theEvent, agentInstanceContext.getStatementContext().getEpStatementHandle(), agentInstanceContext.getInternalEventRouteDest(), agentInstanceContext, addToFront, precedence);
    }

    public void route(EventBean theEvent, EPStatementHandle statementHandle, InternalEventRouteDest routeDest, ExprEvaluatorContext exprEvaluatorContext, boolean addToFront, int precedence) {
        if (!this.hasPreprocessing) {
            if (this.insertIntoListener != null) {
                boolean route = this.insertIntoListener.inserted(theEvent, statementHandle);
                if (route) {
                    routeDest.route(theEvent, statementHandle, addToFront, precedence);
                }
            } else {
                routeDest.route(theEvent, statementHandle, addToFront, precedence);
            }
            return;
        }
        EventBean preprocessed = this.getPreprocessedEvent(theEvent, exprEvaluatorContext, exprEvaluatorContext.getInstrumentationProvider());
        if (preprocessed != null) {
            if (this.insertIntoListener != null) {
                boolean route = this.insertIntoListener.inserted(theEvent, statementHandle);
                if (route) {
                    routeDest.route(preprocessed, statementHandle, addToFront, precedence);
                }
            } else {
                routeDest.route(preprocessed, statementHandle, addToFront, precedence);
            }
        }
    }

    @Override
    public synchronized void addPreprocessing(InternalEventRouterDesc internalEventRouterDesc, InternalRoutePreprocessView outputView, StatementContext statementContext, boolean hasSubselect) {
        this.descriptors.put(internalEventRouterDesc, new IRDescEntry(internalEventRouterDesc, outputView, statementContext, hasSubselect, internalEventRouterDesc.getOptionalWhereClauseEval()));
        this.removePreprocessors(internalEventRouterDesc.getEventType());
        this.hasPreprocessing = true;
    }

    @Override
    public synchronized void removePreprocessing(EventType eventType, InternalEventRouterDesc desc) {
        if (log.isInfoEnabled()) {
            log.debug("Removing route preprocessing for type '" + eventType.getName());
        }
        this.removePreprocessors(eventType);
        this.descriptors.remove(desc);
        if (this.descriptors.isEmpty()) {
            this.hasPreprocessing = false;
            this.preprocessors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBean getPreprocessedEvent(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext, InstrumentationCommon instrumentation) {
        NullableObject<InternalEventRouterPreprocessor> processor = this.preprocessors.get(theEvent.getEventType());
        if (processor == null) {
            InternalEventRouterImpl internalEventRouterImpl = this;
            synchronized (internalEventRouterImpl) {
                processor = this.initialize(theEvent.getEventType());
                this.preprocessors.put(theEvent.getEventType(), processor);
            }
        }
        if (processor.getObject() == null) {
            return theEvent;
        }
        return processor.getObject().process(theEvent, exprEvaluatorContext, instrumentation);
    }

    private void removePreprocessors(EventType eventType) {
        this.preprocessors.remove(eventType);
        for (EventType type : this.preprocessors.keySet()) {
            if (type.getDeepSuperTypes() == null) continue;
            Iterator<EventType> it = type.getDeepSuperTypes();
            while (it.hasNext()) {
                if (it.next() != eventType) continue;
                this.preprocessors.remove(type);
            }
        }
    }

    private NullableObject<InternalEventRouterPreprocessor> initialize(EventType eventType) {
        EventTypeSPI eventTypeSPI = (EventTypeSPI)eventType;
        ArrayList<InternalEventRouterEntry> desc = new ArrayList<InternalEventRouterEntry>();
        HashSet<String> eventPropertiesWritten = new HashSet<String>();
        for (Map.Entry<InternalEventRouterDesc, IRDescEntry> entry : this.descriptors.entrySet()) {
            boolean applicable;
            boolean bl = applicable = entry.getValue().getEventType() == eventType;
            if (!applicable && eventType.getDeepSuperTypes() != null) {
                Iterator<EventType> it = eventType.getDeepSuperTypes();
                while (it.hasNext()) {
                    if (it.next() != entry.getValue().getEventType()) continue;
                    applicable = true;
                    break;
                }
            }
            if (!applicable) continue;
            int priority = 0;
            boolean isDrop = false;
            Annotation[] annotations = entry.getValue().getAnnotations();
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i] instanceof Priority) {
                    priority = ((Priority)annotations[i]).value();
                }
                if (!(annotations[i] instanceof Drop)) continue;
                isDrop = true;
            }
            eventPropertiesWritten.addAll(Arrays.asList(entry.getKey().getProperties()));
            EventBeanWriter writer = eventTypeSPI.getWriter(entry.getKey().getProperties());
            desc.add(new InternalEventRouterEntry(priority, isDrop, entry.getValue().getOptionalWhereClauseEvaluator(), entry.getKey().getAssignments(), writer, entry.getValue().getWideners(), entry.getValue().getWriters(), entry.getValue().getOutputView(), entry.getValue().getStatementContext(), entry.getValue().hasSubselect));
        }
        EventBeanCopyMethodForge copyMethodForge = eventTypeSPI.getCopyMethodForge(eventPropertiesWritten.toArray(new String[eventPropertiesWritten.size()]));
        if (copyMethodForge == null) {
            return new NullableObject<Object>(null);
        }
        return new NullableObject<InternalEventRouterPreprocessor>(new InternalEventRouterPreprocessor(copyMethodForge.getCopyMethod(this.eventBeanTypedEventFactory), desc));
    }

    public void movePreprocessing(StatementContext statementContext, InternalEventRouter internalEventRouter) {
        ArrayList<Map.Entry<InternalEventRouterDesc, IRDescEntry>> moved = new ArrayList<Map.Entry<InternalEventRouterDesc, IRDescEntry>>();
        for (Map.Entry<InternalEventRouterDesc, IRDescEntry> entry : this.descriptors.entrySet()) {
            if (entry.getValue().statementContext != statementContext) continue;
            moved.add(entry);
        }
        for (Map.Entry<InternalEventRouterDesc, IRDescEntry> entry : moved) {
            this.removePreprocessing(entry.getKey().getEventType(), entry.getValue().internalEventRouterDesc);
            internalEventRouter.addPreprocessing(entry.getValue().internalEventRouterDesc, entry.getValue().outputView, statementContext, entry.getValue().hasSubselect);
        }
    }

    private static class IRDescEntry {
        private final InternalEventRouterDesc internalEventRouterDesc;
        private final InternalRoutePreprocessView outputView;
        private final StatementContext statementContext;
        private final boolean hasSubselect;
        private final ExprEvaluator optionalWhereClauseEvaluator;

        private IRDescEntry(InternalEventRouterDesc internalEventRouterDesc, InternalRoutePreprocessView outputView, StatementContext statementContext, boolean hasSubselect, ExprEvaluator optionalWhereClauseEvaluator) {
            this.internalEventRouterDesc = internalEventRouterDesc;
            this.outputView = outputView;
            this.statementContext = statementContext;
            this.hasSubselect = hasSubselect;
            this.optionalWhereClauseEvaluator = optionalWhereClauseEvaluator;
        }

        public ExprEvaluator getOptionalWhereClauseEvaluator() {
            return this.optionalWhereClauseEvaluator;
        }

        public EventType getEventType() {
            return this.internalEventRouterDesc.getEventType();
        }

        public Annotation[] getAnnotations() {
            return this.internalEventRouterDesc.getAnnotations();
        }

        public TypeWidener[] getWideners() {
            return this.internalEventRouterDesc.getWideners();
        }

        public InternalRoutePreprocessView getOutputView() {
            return this.outputView;
        }

        public StatementContext getStatementContext() {
            return this.statementContext;
        }

        public boolean isHasSubselect() {
            return this.hasSubselect;
        }

        public InternalEventRouterWriter[] getWriters() {
            return this.internalEventRouterDesc.getWriters();
        }
    }
}

