/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.client.annotation.NoLock;
import com.espertech.esper.common.client.util.StatementType;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockFactory;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockNoLockImpl;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockRW;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLockRWLogging;
import com.espertech.esper.common.internal.epl.annotation.AnnotationUtil;
import java.lang.annotation.Annotation;

public class StatementAgentInstanceLockFactoryImpl
implements StatementAgentInstanceLockFactory {
    private final boolean fairlocks;
    private final boolean disableLocking;
    private final boolean lockLogging;

    public StatementAgentInstanceLockFactoryImpl(boolean fairlocks, boolean disableLocking, boolean lockLogging) {
        this.fairlocks = fairlocks;
        this.disableLocking = disableLocking;
        this.lockLogging = lockLogging;
    }

    @Override
    public StatementAgentInstanceLock getStatementLock(String statementName, int cpid, Annotation[] annotations, boolean stateless, StatementType statementType) {
        if (statementType.isOnTriggerInfra()) {
            throw new UnsupportedOperationException("Operation not available for statement type " + statementType);
        }
        boolean foundNoLock = AnnotationUtil.hasAnnotation(annotations, NoLock.class);
        if (this.disableLocking || foundNoLock || stateless) {
            return new StatementAgentInstanceLockNoLockImpl(statementName);
        }
        if (!this.lockLogging) {
            return new StatementAgentInstanceLockRW(this.fairlocks);
        }
        return new StatementAgentInstanceLockRWLogging(this.fairlocks, statementName, cpid);
    }
}

