/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class StatementAgentInstanceLockRW
implements StatementAgentInstanceLock {
    private final ReentrantReadWriteLock lock;

    public StatementAgentInstanceLockRW(boolean isFair) {
        this.lock = new ReentrantReadWriteLock(isFair);
    }

    @Override
    public void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    @Override
    public boolean acquireWriteLock(long msecTimeout) {
        boolean result = false;
        try {
            result = this.lock.writeLock().tryLock(msecTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    @Override
    public void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public void acquireReadLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public boolean addAcquiredLock(Lock lock) {
        throw new UnsupportedOperationException("Lock-acquisition not supported, please check the use of tables");
    }
}

