/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementAgentInstanceLockRWLogging
implements StatementAgentInstanceLock {
    private static final Logger LOCK_LOG = LoggerFactory.getLogger((String)"com.espertech.esper.lock");
    private static final String WRITE = "write";
    private static final String READ = "read ";
    private final ReentrantReadWriteLock lock;
    private final String lockId;
    private final String statementName;
    private final int cpid;

    public StatementAgentInstanceLockRWLogging(boolean isFair, String statementName, int cpid) {
        this.lock = new ReentrantReadWriteLock(isFair);
        this.lockId = "RWLock@" + Integer.toHexString(System.identityHashCode(this.lock));
        this.statementName = statementName;
        this.cpid = cpid;
    }

    @Override
    public void acquireWriteLock() {
        this.output("Acquire ", WRITE, -1L);
        this.lock.writeLock().lock();
        this.output("Got     ", WRITE, -1L);
    }

    @Override
    public boolean acquireWriteLock(long msecTimeout) {
        this.output("Acquire ", WRITE, msecTimeout);
        boolean result = false;
        try {
            result = this.lock.writeLock().tryLock(msecTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.output("Got     ", WRITE, -1L);
        return result;
    }

    @Override
    public void releaseWriteLock() {
        this.output("Release ", WRITE, -1L);
        this.lock.writeLock().unlock();
        this.output("Freed   ", WRITE, -1L);
    }

    @Override
    public void acquireReadLock() {
        this.output("Acquire ", READ, -1L);
        this.lock.readLock().lock();
        this.output("Got     ", READ, -1L);
    }

    @Override
    public void releaseReadLock() {
        this.output("Release ", READ, -1L);
        this.lock.readLock().unlock();
        this.output("Freed   ", READ, -1L);
    }

    private void output(String action, String lockType, long timeoutMSec) {
        LOCK_LOG.info("{}{} {} stmt '{}' cpid {} timeoutMSec {} readLockCount {} isWriteLocked {}", new Object[]{action, lockType, this.lockId, this.statementName, this.cpid, timeoutMSec, this.lock.getReadLockCount(), this.lock.isWriteLocked()});
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

