/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.context.util;

import com.espertech.esper.common.internal.context.aifactory.core.StatementAgentInstanceFactoryResult;
import com.espertech.esper.common.internal.context.airegistry.AIRegistryUtil;
import com.espertech.esper.common.internal.context.airegistry.StatementAIResourceRegistry;
import com.espertech.esper.common.internal.context.mgr.ContextManager;
import com.espertech.esper.common.internal.context.module.StatementAIFactoryAssignmentsImpl;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceFilterProxy;
import com.espertech.esper.common.internal.context.util.ContextAgentInstanceInfo;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.context.util.StatementAgentInstanceLock;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.event.core.MappedEventBean;
import com.espertech.esper.common.internal.metrics.audit.AuditProvider;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCommon;
import com.espertech.esper.common.internal.statement.dispatch.UpdateDispatchView;
import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import com.espertech.esper.common.internal.statement.resource.StatementResourceService;
import java.util.concurrent.locks.ReentrantLock;

public class StatementCPCacheService {
    public static final int DEFAULT_AGENT_INSTANCE_ID = -1;
    private final boolean contextPartitioned;
    private final StatementResourceService statementResourceService;
    private final StatementAIResourceRegistry statementAgentInstanceRegistry;
    private final ReentrantLock lock = new ReentrantLock();

    public StatementCPCacheService(boolean contextPartitioned, StatementResourceService statementResourceService, StatementAIResourceRegistry statementAgentInstanceRegistry) {
        this.contextPartitioned = contextPartitioned;
        this.statementResourceService = statementResourceService;
        this.statementAgentInstanceRegistry = statementAgentInstanceRegistry;
    }

    public StatementResourceService getStatementResourceService() {
        return this.statementResourceService;
    }

    public StatementResourceHolder makeOrGetEntryCanNull(int agentInstanceId, StatementContext statementContext) {
        if (!this.contextPartitioned) {
            return this.makeOrGetEntryUnpartitioned(statementContext);
        }
        return this.makeOrGetEntryPartitioned(agentInstanceId, statementContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementResourceHolder makeOrGetEntryUnpartitioned(StatementContext statementContext) {
        StatementResourceHolder resources = this.statementResourceService.getResourcesUnpartitioned();
        if (resources == null) {
            this.lock.lock();
            try {
                resources = this.statementResourceService.getResourcesUnpartitioned();
                if (resources != null) {
                    StatementResourceHolder statementResourceHolder = resources;
                    return statementResourceHolder;
                }
                AgentInstanceContext agentInstanceContext = StatementCPCacheService.makeNewAgentInstanceContextCanNull(-1, statementContext, false);
                StatementAgentInstanceFactoryResult result = statementContext.getStatementAIFactoryProvider().getFactory().newContext(agentInstanceContext, true);
                this.hookUpNewRealization(result, statementContext);
                resources = statementContext.getStatementContextRuntimeServices().getStatementResourceHolderBuilder().build(agentInstanceContext, result);
                this.statementResourceService.setUnpartitioned(resources);
            }
            finally {
                this.lock.unlock();
            }
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatementResourceHolder makeOrGetEntryPartitioned(int agentInstanceId, StatementContext statementContext) {
        StatementResourceService statementResourceService = statementContext.getStatementCPCacheService().getStatementResourceService();
        StatementResourceHolder resources = statementResourceService.getResourcesPartitioned().get(agentInstanceId);
        if (resources != null) {
            return resources;
        }
        this.lock.lock();
        try {
            resources = statementResourceService.getResourcesPartitioned().get(agentInstanceId);
            if (resources != null) {
                StatementResourceHolder statementResourceHolder = resources;
                return statementResourceHolder;
            }
            AgentInstanceContext agentInstanceContext = StatementCPCacheService.makeNewAgentInstanceContextCanNull(agentInstanceId, statementContext, true);
            if (agentInstanceContext == null) {
                StatementResourceHolder statementResourceHolder = null;
                return statementResourceHolder;
            }
            StatementAgentInstanceFactoryResult result = statementContext.getStatementAIFactoryProvider().getFactory().newContext(agentInstanceContext, true);
            this.hookUpNewRealization(result, statementContext);
            resources = statementContext.getStatementContextRuntimeServices().getStatementResourceHolderBuilder().build(agentInstanceContext, result);
            statementResourceService.setPartitioned(agentInstanceId, resources);
            this.assignAIResourcesForExpressionContextPartitions(agentInstanceId, resources);
        }
        finally {
            this.lock.unlock();
        }
        return resources;
    }

    private static AgentInstanceContext makeNewAgentInstanceContextCanNull(int agentInstanceId, StatementContext statementContext, boolean partitioned) {
        StatementAgentInstanceLock lock = statementContext.getStatementAIFactoryProvider().getFactory().obtainAgentInstanceLock(statementContext, agentInstanceId);
        if (lock == null) {
            return null;
        }
        EPStatementAgentInstanceHandle epStatementAgentInstanceHandle = new EPStatementAgentInstanceHandle(statementContext.getEpStatementHandle(), agentInstanceId, lock);
        String contextName = statementContext.getContextName();
        MappedEventBean contextProperties = null;
        AgentInstanceFilterProxy agentInstanceFilterProxy = null;
        if (contextName != null) {
            String contextDeploymentId = statementContext.getContextRuntimeDescriptor().getContextDeploymentId();
            ContextManager contextManager = statementContext.getContextManagementService().getContextManager(contextDeploymentId, contextName);
            epStatementAgentInstanceHandle.setFilterFaultHandler(contextManager);
            ContextAgentInstanceInfo info = contextManager.getContextAgentInstanceInfo(statementContext, agentInstanceId);
            if (info == null) {
                return null;
            }
            agentInstanceFilterProxy = info.getFilterProxy();
            contextProperties = info.getContextProperties();
        }
        AuditProvider auditProvider = statementContext.getStatementInformationals().getAuditProvider();
        InstrumentationCommon instrumentationProvider = statementContext.getStatementInformationals().getInstrumentationProvider();
        return new AgentInstanceContext(statementContext, epStatementAgentInstanceHandle, agentInstanceFilterProxy, contextProperties, auditProvider, instrumentationProvider);
    }

    private void hookUpNewRealization(StatementAgentInstanceFactoryResult result, StatementContext statementContext) {
        UpdateDispatchView dispatchChildView = statementContext.getUpdateDispatchView();
        if (dispatchChildView != null) {
            result.getFinalView().setChild(dispatchChildView);
        }
        if (statementContext.getContextName() == null) {
            StatementAIFactoryAssignmentsImpl assignments = new StatementAIFactoryAssignmentsImpl(result.getOptionalAggegationService(), result.getPriorStrategies(), result.getPreviousGetterStrategies(), result.getSubselectStrategies(), result.getTableAccessStrategies(), result.getRowRecogPreviousStrategy());
            statementContext.getStatementAIFactoryProvider().assign(assignments);
        }
    }

    private void assignAIResourcesForExpressionContextPartitions(int agentInstanceId, StatementResourceHolder holder) {
        AIRegistryUtil.assignFutures(this.statementAgentInstanceRegistry, agentInstanceId, holder.getAggregationService(), holder.getPriorEvalStrategies(), holder.getPreviousGetterStrategies(), holder.getSubselectStrategies(), holder.getTableAccessStrategies(), holder.getRowRecogPreviousStrategy());
    }

    public boolean isContextPartitioned() {
        return this.contextPartitioned;
    }

    public int clear(StatementContext statementContext) {
        Integer[] agentInstanceIds;
        int numCleared = 0;
        if (statementContext.getContextName() == null) {
            statementContext.getStatementAIFactoryProvider().unassign();
        }
        StatementResourceService statementResourceService = statementContext.getStatementCPCacheService().getStatementResourceService();
        if (!this.contextPartitioned) {
            if (statementResourceService.getResourcesUnpartitioned() != null) {
                statementResourceService.deallocateUnpartitioned();
                ++numCleared;
            }
            return numCleared;
        }
        for (Integer agentInstanceId : agentInstanceIds = statementResourceService.getResourcesPartitioned().keySet().toArray(new Integer[0])) {
            this.statementAgentInstanceRegistry.deassign(agentInstanceId);
        }
        Integer[] integerArray = agentInstanceIds;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int agentInstanceId = integerArray[i];
            statementResourceService.deallocatePartitioned(agentInstanceId);
            ++numCleared;
        }
        return numCleared;
    }
}

