/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.access.plugin;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.configuration.compiler.ConfigurationCompilerPlugInAggregationMultiFunction;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionAggregationMethodContext;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionAggregationMethodModeManaged;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionForge;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionHandler;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionMethodDesc;
import com.espertech.esper.common.client.hook.aggmultifunc.AggregationMultiFunctionValidationContext;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.collection.Pair;
import com.espertech.esper.common.internal.context.aifactory.core.ModuleTableInitializeSymbol;
import com.espertech.esper.common.internal.epl.agg.access.plugin.AggregationMethodForgePlugIn;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.core.AggregationValidationUtil;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.rettype.EPChainableType;
import com.espertech.esper.common.internal.rettype.EPChainableTypeHelper;
import com.espertech.esper.common.internal.util.JavaClassHelper;

public class AggregationPortableValidationPluginMultiFunc
implements AggregationPortableValidation {
    public static final EPTypeClass EPTYPE = new EPTypeClass(AggregationPortableValidationPluginMultiFunc.class);
    private String aggregationFunctionName;
    private ConfigurationCompilerPlugInAggregationMultiFunction config;
    private AggregationMultiFunctionHandler handler;
    private boolean parametersValidated;

    @Override
    public void validateIntoTableCompatible(String tableExpression, AggregationPortableValidation intoTableAgg, String intoExpression, AggregationForgeFactory factory) throws ExprValidationException {
        AggregationValidationUtil.validateAggregationType(this, tableExpression, intoTableAgg, intoExpression);
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, ModuleTableInitializeSymbol symbols, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(EPTYPE, this.getClass(), (CodegenScope)classScope);
        method.getBlock().declareVarNewInstance(EPTYPE, "portable").exprDotMethod(CodegenExpressionBuilder.ref("portable"), "setAggregationFunctionName", CodegenExpressionBuilder.constant(this.aggregationFunctionName)).exprDotMethod(CodegenExpressionBuilder.ref("portable"), "setConfig", this.config == null ? CodegenExpressionBuilder.constantNull() : this.config.toExpression()).methodReturn(CodegenExpressionBuilder.ref("portable"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    @Override
    public boolean isAggregationMethod(String name, ExprNode[] parameters, ExprValidationContext validationContext) throws ExprValidationException {
        Pair<ConfigurationCompilerPlugInAggregationMultiFunction, Class> configPair = validationContext.getClasspathImportService().resolveAggregationMultiFunction(this.aggregationFunctionName, validationContext.getClassProvidedClasspathExtension());
        if (configPair == null) {
            return false;
        }
        AggregationMultiFunctionForge forge = configPair.getSecond() != null ? (AggregationMultiFunctionForge)JavaClassHelper.instantiate(AggregationMultiFunctionForge.class, configPair.getSecond()) : JavaClassHelper.instantiate(AggregationMultiFunctionForge.class, configPair.getFirst().getMultiFunctionForgeClassName(), validationContext.getClasspathImportService().getClassForNameProvider());
        this.validateParamsUnless(validationContext, parameters);
        AggregationMultiFunctionValidationContext ctx = new AggregationMultiFunctionValidationContext(name, validationContext.getStreamTypeService().getEventTypes(), parameters, validationContext.getStatementName(), validationContext, this.config, parameters, null);
        this.handler = forge.validateGetHandler(ctx);
        return this.handler.getAggregationMethodMode(new AggregationMultiFunctionAggregationMethodContext(name, parameters, validationContext)) != null;
    }

    @Override
    public AggregationMultiFunctionMethodDesc validateAggregationMethod(ExprValidationContext validationContext, String aggMethodName, ExprNode[] params) throws ExprValidationException {
        this.validateParamsUnless(validationContext, params);
        EPChainableType epType = this.handler.getReturnType();
        EPType returnType = EPChainableTypeHelper.getNormalizedEPType(epType);
        if (returnType == EPTypeNull.INSTANCE) {
            throw new ExprValidationException("Null-type value returned by aggregation function '" + aggMethodName + "' is not allowed");
        }
        AggregationMethodForgePlugIn forge = new AggregationMethodForgePlugIn((EPTypeClass)returnType, (AggregationMultiFunctionAggregationMethodModeManaged)this.handler.getAggregationMethodMode(new AggregationMultiFunctionAggregationMethodContext(aggMethodName, params, validationContext)));
        EventType eventTypeCollection = EPChainableTypeHelper.optionalIsEventTypeColl(epType);
        EventType eventTypeSingle = EPChainableTypeHelper.optionalIsEventTypeSingle(epType);
        EPTypeClass componentTypeCollection = EPChainableTypeHelper.getCollectionOrArrayComponentTypeOrNull(epType);
        return new AggregationMultiFunctionMethodDesc(forge, eventTypeCollection, componentTypeCollection, eventTypeSingle);
    }

    public String getAggregationFunctionName() {
        return this.aggregationFunctionName;
    }

    public void setAggregationFunctionName(String aggregationFunctionName) {
        this.aggregationFunctionName = aggregationFunctionName;
    }

    public AggregationMultiFunctionHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AggregationMultiFunctionHandler handler) {
        this.handler = handler;
    }

    public ConfigurationCompilerPlugInAggregationMultiFunction getConfig() {
        return this.config;
    }

    public void setConfig(ConfigurationCompilerPlugInAggregationMultiFunction config) {
        this.config = config;
    }

    private void validateParamsUnless(ExprValidationContext validationContext, ExprNode[] parameters) throws ExprValidationException {
        if (this.parametersValidated) {
            return;
        }
        ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.AGGPARAM, parameters, validationContext);
        this.parametersValidated = true;
    }
}

