/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevelForge;

public class AggregationGroupByRollupDescForge {
    private final AggregationGroupByRollupLevelForge[] levels;
    private final int numLevelsAggregation;

    public AggregationGroupByRollupDescForge(AggregationGroupByRollupLevelForge[] levels) {
        this.levels = levels;
        int count = 0;
        for (AggregationGroupByRollupLevelForge level : levels) {
            if (level.isAggregationTop()) continue;
            ++count;
        }
        this.numLevelsAggregation = count;
    }

    public AggregationGroupByRollupLevelForge[] getLevels() {
        return this.levels;
    }

    public int getNumLevelsAggregation() {
        return this.numLevelsAggregation;
    }

    public int getNumLevels() {
        return this.levels.length;
    }

    public CodegenExpression codegen(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenExpression[] level = new CodegenExpression[this.levels.length];
        for (int i = 0; i < this.levels.length; ++i) {
            level[i] = this.levels[i].codegen(parent, classScope);
        }
        return CodegenExpressionBuilder.newInstance(AggregationGroupByRollupDesc.EPTYPE, CodegenExpressionBuilder.newArrayWithInit(AggregationGroupByRollupLevel.EPTYPE, level));
    }
}

