/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.util.MultiKey;
import java.util.Arrays;

public abstract class AggregationGroupByRollupLevel {
    public static final EPTypeClass EPTYPE = new EPTypeClass(AggregationGroupByRollupLevel.class);
    public static final EPTypeClass EPTYPEARRAY = new EPTypeClass(AggregationGroupByRollupLevel[].class);
    private final int levelNumber;
    private final int levelOffset;
    private final int[] rollupKeys;
    private final DataInputOutputSerde subkeySerde;

    public abstract Object computeSubkey(Object var1);

    public AggregationGroupByRollupLevel(int levelNumber, int levelOffset, int[] rollupKeys, DataInputOutputSerde subkeySerde) {
        this.levelNumber = levelNumber;
        this.levelOffset = levelOffset;
        this.rollupKeys = rollupKeys;
        this.subkeySerde = subkeySerde;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public boolean isAggregationTop() {
        return this.levelOffset == -1;
    }

    public int getAggregationOffset() {
        if (this.isAggregationTop()) {
            throw new IllegalArgumentException();
        }
        return this.levelOffset;
    }

    public int getLevelOffset() {
        return this.levelOffset;
    }

    public int[] getRollupKeys() {
        return this.rollupKeys;
    }

    public DataInputOutputSerde getSubkeySerde() {
        return this.subkeySerde;
    }

    public String toString() {
        return "GroupByRollupLevel{levelOffset=" + this.levelOffset + ", rollupKeys=" + Arrays.toString(this.rollupKeys) + "}";
    }

    public Object[] computeMultiKey(Object subkey, int numExpected) {
        if (subkey instanceof MultiKey) {
            MultiKey mk = (MultiKey)subkey;
            if (mk.getNumKeys() == numExpected) {
                return MultiKey.toObjectArray(mk);
            }
            Object[] keys = new Object[]{numExpected};
            for (int i = 0; i < this.rollupKeys.length; ++i) {
                keys[this.rollupKeys[i]] = mk.getKey(i);
            }
            return keys;
        }
        Object[] keys = new Object[numExpected];
        if (subkey == null) {
            return keys;
        }
        keys[this.rollupKeys[0]] = subkey;
        return keys;
    }
}

