/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.compile.multikey.MultiKeyClassRef;
import com.espertech.esper.common.internal.epl.agg.core.AggregationGroupByRollupLevel;
import java.util.Arrays;

public class AggregationGroupByRollupLevelForge {
    private final int levelNumber;
    private final int levelOffset;
    private final int[] rollupKeys;
    private final EPType[] allGroupKeyTypes;
    private final MultiKeyClassRef allKeysMultikey;
    private final MultiKeyClassRef subKeyMultikey;

    public AggregationGroupByRollupLevelForge(int levelNumber, int levelOffset, int[] rollupKeys, EPType[] allGroupKeyTypes, MultiKeyClassRef allKeysMultikey, MultiKeyClassRef subKeyMultikey) {
        this.levelNumber = levelNumber;
        this.levelOffset = levelOffset;
        this.rollupKeys = rollupKeys;
        this.allGroupKeyTypes = allGroupKeyTypes;
        this.allKeysMultikey = allKeysMultikey;
        this.subKeyMultikey = subKeyMultikey;
    }

    public int getAggregationOffset() {
        if (this.isAggregationTop()) {
            throw new IllegalArgumentException();
        }
        return this.levelOffset;
    }

    public CodegenExpression codegen(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(AggregationGroupByRollupLevel.EPTYPE, this.getClass(), (CodegenScope)classScope);
        CodegenExpression serde = CodegenExpressionBuilder.constantNull();
        if (this.rollupKeys != null) {
            serde = this.allGroupKeyTypes.length == this.rollupKeys.length ? this.allKeysMultikey.getExprMKSerde(method, classScope) : this.subKeyMultikey.getExprMKSerde(method, classScope);
        }
        CodegenExpressionNewAnonymousClass clazz = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), AggregationGroupByRollupLevel.EPTYPE, Arrays.asList(CodegenExpressionBuilder.constant(this.levelNumber), CodegenExpressionBuilder.constant(this.levelOffset), CodegenExpressionBuilder.constant(this.rollupKeys), serde));
        CodegenMethod computeSubkey = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), this.getClass(), classScope).addParam(EPTypePremade.OBJECT.getEPType(), "groupKey");
        clazz.addMethod("computeSubkey", computeSubkey);
        if (this.isAggregationTop()) {
            computeSubkey.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
        } else if (this.allKeysMultikey == null || this.allGroupKeyTypes.length == this.rollupKeys.length) {
            computeSubkey.getBlock().methodReturn(CodegenExpressionBuilder.ref("groupKey"));
        } else {
            computeSubkey.getBlock().declareVar(this.allKeysMultikey.getClassNameMK(), "mk", CodegenExpressionBuilder.cast(this.allKeysMultikey.getClassNameMK(), (CodegenExpression)CodegenExpressionBuilder.ref("groupKey")));
            if (this.rollupKeys.length == 1 && (this.subKeyMultikey == null || this.subKeyMultikey.getClassNameMK() == null)) {
                computeSubkey.getBlock().methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("mk"), "getKey", CodegenExpressionBuilder.constant(this.rollupKeys[0])));
            } else {
                CodegenExpression[] expressions = new CodegenExpression[this.rollupKeys.length];
                for (int i = 0; i < this.rollupKeys.length; ++i) {
                    int index = this.rollupKeys[i];
                    CodegenExpression keyExpr = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("mk"), "getKey", CodegenExpressionBuilder.constant(index));
                    EPType type = this.allGroupKeyTypes[index];
                    expressions[i] = type == null || type == EPTypeNull.INSTANCE ? CodegenExpressionBuilder.constantNull() : CodegenExpressionBuilder.cast((EPTypeClass)type, keyExpr);
                }
                computeSubkey.getBlock().methodReturn(CodegenExpressionBuilder.newInstance(this.subKeyMultikey.getClassNameMK(), expressions));
            }
        }
        method.getBlock().methodReturn(clazz);
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public boolean isAggregationTop() {
        return this.levelOffset == -1;
    }

    public int[] getRollupKeys() {
        return this.rollupKeys;
    }

    public int getLevelNumber() {
        return this.levelNumber;
    }

    public MultiKeyClassRef getAllKeysMultikey() {
        return this.allKeysMultikey;
    }

    public MultiKeyClassRef getSubKeyMultikey() {
        return this.subKeyMultikey;
    }
}

