/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.core;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProvider;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenSymbolProviderEmpty;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenClassMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenInnerClass;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedMethods;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenNamedParam;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenTypedParam;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMemberWCol;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRelational;
import com.espertech.esper.common.internal.bytecodemodel.util.CodegenStackGenerator;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorForgeGetCodegenContext;
import com.espertech.esper.common.internal.epl.agg.core.AggregationAccessorSlotPairForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassAssignment;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassAssignmentPerLevel;
import com.espertech.esper.common.internal.epl.agg.core.AggregationClassNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationCodegenRowDetailDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationCodegenRowLevelDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationForgeFactory;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRow;
import com.espertech.esper.common.internal.epl.agg.core.AggregationRowCtorDesc;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceCodegenNames;
import com.espertech.esper.common.internal.epl.agg.core.AggregationServiceFactoryCompiler;
import com.espertech.esper.common.internal.epl.agg.core.AggregationStateFactoryForge;
import com.espertech.esper.common.internal.epl.agg.core.AggregationVColAccess;
import com.espertech.esper.common.internal.epl.agg.core.AggregationVColMethod;
import com.espertech.esper.common.internal.epl.agg.core.AggregatorAccess;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenNames;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityQuery;
import com.espertech.esper.common.internal.metrics.instrumentation.InstrumentationCode;
import com.espertech.esper.common.internal.util.IntArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class AggregationServiceFactoryCompilerRow {
    private static final String NAME_ASSIGNMENT = "ASSIGNMENTS";

    protected static AggregationClassAssignmentPerLevel makeRow(boolean isGenerateTableEnter, AggregationCodegenRowLevelDesc rowLevelDesc, Class forgeClass, Consumer<AggregationRowCtorDesc> rowCtorConsumer, CodegenClassScope classScope, List<CodegenInnerClass> innerClasses, AggregationClassNames classNames) {
        AggregationClassAssignment[] topAssignments = null;
        if (rowLevelDesc.getOptionalTopRow() != null) {
            topAssignments = AggregationServiceFactoryCompilerRow.makeRowForLevel(isGenerateTableEnter, classNames.getRowTop(), rowLevelDesc.getOptionalTopRow(), forgeClass, rowCtorConsumer, classScope, innerClasses);
        }
        AggregationClassAssignment[][] leafAssignments = null;
        if (rowLevelDesc.getOptionalAdditionalRows() != null) {
            leafAssignments = new AggregationClassAssignment[rowLevelDesc.getOptionalAdditionalRows().length][];
            for (int i = 0; i < rowLevelDesc.getOptionalAdditionalRows().length; ++i) {
                String className = classNames.getRowPerLevel(i);
                leafAssignments[i] = AggregationServiceFactoryCompilerRow.makeRowForLevel(isGenerateTableEnter, className, rowLevelDesc.getOptionalAdditionalRows()[i], forgeClass, rowCtorConsumer, classScope, innerClasses);
            }
        }
        return new AggregationClassAssignmentPerLevel(topAssignments, leafAssignments);
    }

    private static AggregationClassAssignment[] makeRowForLevel(boolean table, String className, AggregationCodegenRowDetailDesc detail, Class forgeClass, Consumer<AggregationRowCtorDesc> rowCtorConsumer, CodegenClassScope classScope, List<CodegenInnerClass> innerClasses) {
        Object factory;
        AggregationClassAssignment currentAssignment = new AggregationClassAssignment(0, forgeClass, classScope);
        int countStates = 0;
        int countVcols = 0;
        int indexAssignment = 0;
        LinkedHashMap<Integer, AggregationClassAssignment> assignments = new LinkedHashMap<Integer, AggregationClassAssignment>();
        HashMap<Integer, AggregationClassAssignment> slotToAssignment = new HashMap<Integer, AggregationClassAssignment>();
        int maxMembersPerClass = classScope.getPackageScope().getConfig().getInternalUseOnlyMaxMembersPerClass();
        int methodFactoryCount = 0;
        if (detail.getStateDesc().getMethodFactories() != null) {
            methodFactoryCount = detail.getStateDesc().getMethodFactories().length;
            for (int methodIndex = 0; methodIndex < detail.getStateDesc().getMethodFactories().length; ++methodIndex) {
                if (currentAssignment.getMemberSize() != 0 && currentAssignment.getMemberSize() >= maxMembersPerClass) {
                    assignments.put(indexAssignment++, currentAssignment);
                    currentAssignment = new AggregationClassAssignment(countStates, forgeClass, classScope);
                }
                factory = detail.getStateDesc().getMethodFactories()[methodIndex];
                currentAssignment.add((AggregationForgeFactory)factory, detail.getStateDesc().getOptionalMethodForges() == null ? new ExprForge[]{} : detail.getStateDesc().getOptionalMethodForges()[methodIndex]);
                currentAssignment.addMethod(new AggregationVColMethod(countVcols, (AggregationForgeFactory)factory));
                factory.getAggregator().initForge(countStates, currentAssignment.getCtor(), currentAssignment.getMembers(), classScope);
                ++countStates;
                ++countVcols;
            }
        }
        if (detail.getStateDesc().getAccessStateForges() != null) {
            for (int accessIndex = 0; accessIndex < detail.getStateDesc().getAccessStateForges().length; ++accessIndex) {
                if (currentAssignment.getMemberSize() != 0 && currentAssignment.getMemberSize() >= maxMembersPerClass) {
                    assignments.put(indexAssignment++, currentAssignment);
                    currentAssignment = new AggregationClassAssignment(countStates, forgeClass, classScope);
                }
                factory = detail.getStateDesc().getAccessStateForges()[accessIndex];
                currentAssignment.add((AggregationStateFactoryForge)factory);
                factory.getAggregator().initAccessForge(countStates, currentAssignment.getCtor(), currentAssignment.getMembers(), classScope);
                ++countStates;
                slotToAssignment.put(accessIndex, currentAssignment);
            }
            for (int i = 0; i < detail.getAccessAccessors().length; ++i) {
                AggregationAccessorSlotPairForge slotPair = detail.getAccessAccessors()[i];
                int slot = slotPair.getSlot();
                AggregationClassAssignment assignment = (AggregationClassAssignment)slotToAssignment.get(slot);
                int stateNumber = methodFactoryCount + slot;
                assignment.addAccess(new AggregationVColAccess(countVcols, slotPair.getAccessorForge(), stateNumber, detail.getStateDesc().getAccessStateForges()[slot]));
                ++countVcols;
            }
        }
        if (assignments.isEmpty()) {
            currentAssignment.setClassName(className);
            CodegenInnerClass innerClass = AggregationServiceFactoryCompilerRow.makeRowForLevelFlat(table, false, currentAssignment, rowCtorConsumer, classScope);
            innerClass.addInterfaceImplemented(AggregationRow.EPTYPE);
            innerClasses.add(innerClass);
            return new AggregationClassAssignment[]{currentAssignment};
        }
        assignments.put(indexAssignment, currentAssignment);
        AggregationClassAssignment[] assignmentArray = new AggregationClassAssignment[assignments.size()];
        int index = 0;
        for (Map.Entry entry : assignments.entrySet()) {
            AggregationClassAssignment assignment = (AggregationClassAssignment)entry.getValue();
            assignment.setClassName(className + "_" + entry.getKey());
            assignment.setMemberName("l" + entry.getKey());
            CodegenInnerClass innerClass = AggregationServiceFactoryCompilerRow.makeRowForLevelFlat(table, true, assignment, ctor -> {}, classScope);
            innerClasses.add(innerClass);
            assignmentArray[index++] = (AggregationClassAssignment)entry.getValue();
        }
        CodegenInnerClass composite = AggregationServiceFactoryCompilerRow.produceComposite(detail, assignmentArray, table, forgeClass, className, rowCtorConsumer, classScope);
        innerClasses.add(composite);
        return assignmentArray;
    }

    private static CodegenInnerClass produceComposite(AggregationCodegenRowDetailDesc detail, AggregationClassAssignment[] leafs, boolean table, Class forgeClass, String className, Consumer<AggregationRowCtorDesc> rowCtorConsumer, CodegenClassScope classScope) {
        CodegenMethod applyEnterMethod = AggregationServiceFactoryCompilerRow.makeMethodReturnVoid(AggregationCodegenUpdateType.APPLYENTER.params, classScope);
        CodegenMethod applyLeaveMethod = AggregationServiceFactoryCompilerRow.makeMethodReturnVoid(AggregationCodegenUpdateType.APPLYLEAVE.params, classScope);
        if (!table) {
            for (AggregationClassAssignment leaf : leafs) {
                applyEnterMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(leaf.getMemberName()), "applyEnter", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
                applyLeaveMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(leaf.getMemberName()), "applyLeave", ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
            }
        }
        CodegenMethod clearMethod = AggregationServiceFactoryCompilerRow.makeMethodReturnVoid(AggregationCodegenUpdateType.CLEAR.params, classScope);
        for (AggregationClassAssignment leaf : leafs) {
            clearMethod.getBlock().exprDotMethod(CodegenExpressionBuilder.ref(leaf.getMemberName()), "clear", new CodegenExpression[0]);
        }
        CodegenMethod getAccessStateMethod = AggregationServiceFactoryCompilerRow.makeMethodGetAccess(classScope);
        AggregationServiceFactoryCompilerRow.populateSwitchByRange(leafs, getAccessStateMethod, true, (index, block) -> block.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "getAccessState", AggregationServiceCodegenNames.REF_SCOL)));
        CodegenMethod enterAggMethod = AggregationServiceFactoryCompilerRow.makeMethodTableEnterLeave(classScope);
        CodegenMethod leaveAggMethod = AggregationServiceFactoryCompilerRow.makeMethodTableEnterLeave(classScope);
        CodegenMethod resetAggMethod = AggregationServiceFactoryCompilerRow.makeMethodTableReset(classScope);
        CodegenMethod enterAccessMethod = AggregationServiceFactoryCompilerRow.makeMethodTableAccess(classScope);
        CodegenMethod leaveAccessMethod = AggregationServiceFactoryCompilerRow.makeMethodTableAccess(classScope);
        if (table) {
            AggregationServiceFactoryCompilerRow.populateSwitchByRange(leafs, enterAggMethod, false, (index, block) -> block.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "enterAgg", AggregationServiceCodegenNames.REF_SCOL, AggregationServiceCodegenNames.REF_VALUE));
            AggregationServiceFactoryCompilerRow.populateSwitchByRange(leafs, leaveAggMethod, false, (index, block) -> block.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "leaveAgg", AggregationServiceCodegenNames.REF_SCOL, AggregationServiceCodegenNames.REF_VALUE));
            AggregationServiceFactoryCompilerRow.populateSwitchByRange(leafs, resetAggMethod, false, (index, block) -> block.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "reset", AggregationServiceCodegenNames.REF_SCOL));
            AggregationServiceFactoryCompilerRow.populateSwitchByRange(leafs, enterAccessMethod, false, (index, block) -> block.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "enterAccess", AggregationServiceCodegenNames.REF_SCOL, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
            AggregationServiceFactoryCompilerRow.populateSwitchByRange(leafs, leaveAccessMethod, false, (index, block) -> block.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "leaveAccess", AggregationServiceCodegenNames.REF_SCOL, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        }
        int[] vcolIndexes = AggregationServiceFactoryCompilerRow.getVcolIndexes(detail, leafs);
        CodegenMethod getValueMethod = AggregationServiceFactoryCompilerRow.makeMethodGet(AggregationCodegenGetType.GETVALUE, classScope);
        AggregationServiceFactoryCompilerRow.populateSwitchByIndex(leafs, getValueMethod, true, (index, block) -> block.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "getValue", AggregationServiceCodegenNames.REF_VCOL, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)));
        CodegenMethod getEventBeanMethod = AggregationServiceFactoryCompilerRow.makeMethodGet(AggregationCodegenGetType.GETEVENTBEAN, classScope);
        AggregationServiceFactoryCompilerRow.populateSwitchByIndex(leafs, getEventBeanMethod, true, (index, block) -> block.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "getEventBean", AggregationServiceCodegenNames.REF_VCOL, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)));
        CodegenMethod getCollectionScalarMethod = AggregationServiceFactoryCompilerRow.makeMethodGet(AggregationCodegenGetType.GETCOLLECTIONSCALAR, classScope);
        AggregationServiceFactoryCompilerRow.populateSwitchByIndex(leafs, getCollectionScalarMethod, true, (index, block) -> block.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "getCollectionScalar", AggregationServiceCodegenNames.REF_VCOL, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)));
        CodegenMethod getCollectionOfEventsMethod = AggregationServiceFactoryCompilerRow.makeMethodGet(AggregationCodegenGetType.GETCOLLECTIONOFEVENTS, classScope);
        AggregationServiceFactoryCompilerRow.populateSwitchByIndex(leafs, getCollectionOfEventsMethod, true, (index, block) -> block.blockReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref(leafs[index].getMemberName()), "getCollectionOfEvents", AggregationServiceCodegenNames.REF_VCOL, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT)));
        CodegenClassMethods methods = new CodegenClassMethods();
        CodegenStackGenerator.recursiveBuildStack(applyEnterMethod, "applyEnter", methods);
        CodegenStackGenerator.recursiveBuildStack(applyLeaveMethod, "applyLeave", methods);
        CodegenStackGenerator.recursiveBuildStack(clearMethod, "clear", methods);
        CodegenStackGenerator.recursiveBuildStack(enterAggMethod, "enterAgg", methods);
        CodegenStackGenerator.recursiveBuildStack(leaveAggMethod, "leaveAgg", methods);
        CodegenStackGenerator.recursiveBuildStack(resetAggMethod, "reset", methods);
        CodegenStackGenerator.recursiveBuildStack(enterAccessMethod, "enterAccess", methods);
        CodegenStackGenerator.recursiveBuildStack(leaveAccessMethod, "leaveAccess", methods);
        CodegenStackGenerator.recursiveBuildStack(getAccessStateMethod, "getAccessState", methods);
        CodegenStackGenerator.recursiveBuildStack(getValueMethod, "getValue", methods);
        CodegenStackGenerator.recursiveBuildStack(getEventBeanMethod, "getEventBean", methods);
        CodegenStackGenerator.recursiveBuildStack(getCollectionScalarMethod, "getCollectionScalar", methods);
        CodegenStackGenerator.recursiveBuildStack(getCollectionOfEventsMethod, "getCollectionOfEvents", methods);
        CodegenCtor ctor = new CodegenCtor(forgeClass, classScope, Collections.emptyList());
        for (AggregationClassAssignment leaf : leafs) {
            ctor.getBlock().assignRef(leaf.getMemberName(), CodegenExpressionBuilder.newInstance(leaf.getClassName(), new CodegenExpression[0]));
        }
        ArrayList<CodegenTypedParam> members = new ArrayList<CodegenTypedParam>();
        CodegenTypedParam assignment = new CodegenTypedParam(EPTypePremade.INTEGERPRIMITIVEARRAY.getEPType(), NAME_ASSIGNMENT).setFinal(true).setStatic(true).setInitializer(CodegenExpressionBuilder.constant(vcolIndexes));
        members.add(assignment);
        CodegenNamedMethods namedMethods = new CodegenNamedMethods();
        rowCtorConsumer.accept(new AggregationRowCtorDesc(classScope, ctor, members, namedMethods));
        for (Map.Entry<String, CodegenMethod> methodEntry : namedMethods.getMethods().entrySet()) {
            CodegenStackGenerator.recursiveBuildStack(methodEntry.getValue(), methodEntry.getKey(), methods);
        }
        for (AggregationClassAssignment leaf : leafs) {
            members.add(new CodegenTypedParam(leaf.getClassName(), leaf.getMemberName()));
        }
        return new CodegenInnerClass(className, AggregationRow.EPTYPE, ctor, members, methods);
    }

    private static int[] getVcolIndexes(AggregationCodegenRowDetailDesc detail, AggregationClassAssignment[] leafs) {
        int size = detail.getStateDesc().getMethodFactories() == null ? 0 : detail.getStateDesc().getMethodFactories().length;
        int[] vcols = new int[size += detail.getAccessAccessors() == null ? 0 : detail.getAccessAccessors().length];
        for (int i = 0; i < leafs.length; ++i) {
            for (AggregationVColMethod method : leafs[i].getVcolMethods()) {
                vcols[method.getVcol()] = i;
            }
            for (AggregationVColAccess access : leafs[i].getVcolAccess()) {
                vcols[access.getVcol()] = i;
            }
        }
        return vcols;
    }

    private static void populateSwitchByRange(AggregationClassAssignment[] leafs, CodegenMethod method, boolean blocksReturnValue, BiConsumer<Integer, CodegenBlock> blockConsumer) {
        method.getBlock().declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "i", CodegenExpressionBuilder.constant(0));
        CodegenBlock ifBlock = null;
        for (int i = leafs.length - 1; i > 0; --i) {
            CodegenExpression rangeCheck = CodegenExpressionBuilder.relational(AggregationServiceCodegenNames.REF_SCOL, CodegenExpressionRelational.CodegenRelational.GE, CodegenExpressionBuilder.constant(leafs[i].getOffset()));
            if (ifBlock == null) {
                ifBlock = method.getBlock().ifCondition(rangeCheck).assignRef(CodegenExpressionBuilder.ref("i"), CodegenExpressionBuilder.constant(i));
                continue;
            }
            ifBlock.ifElseIf(rangeCheck).assignRef(CodegenExpressionBuilder.ref("i"), CodegenExpressionBuilder.constant(i));
        }
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("i"), leafs.length, blocksReturnValue);
        for (int i = 0; i < leafs.length; ++i) {
            blockConsumer.accept(i, blocks[i]);
        }
    }

    private static void populateSwitchByIndex(AggregationClassAssignment[] leafs, CodegenMethod method, boolean blocksReturnValue, BiConsumer<Integer, CodegenBlock> blockConsumer) {
        method.getBlock().declareVar(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "i", CodegenExpressionBuilder.arrayAtIndex(CodegenExpressionBuilder.ref(NAME_ASSIGNMENT), CodegenExpressionBuilder.ref("vcol")));
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(CodegenExpressionBuilder.ref("i"), leafs.length, blocksReturnValue);
        for (int i = 0; i < leafs.length; ++i) {
            blockConsumer.accept(i, blocks[i]);
        }
    }

    private static CodegenMethod makeMethodReturnVoid(List<CodegenNamedParam> params, CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), AggregationServiceFactoryCompilerRow.class, classScope).addParam(params);
    }

    private static CodegenInnerClass makeRowForLevelFlat(boolean table, boolean standalone, AggregationClassAssignment assignment, Consumer<AggregationRowCtorDesc> rowCtorConsumer, CodegenClassScope classScope) {
        int numMethodFactories = assignment.getMethodFactories() == null ? 0 : assignment.getMethodFactories().length;
        int offset = assignment.getOffset();
        CodegenNamedMethods namedMethods = new CodegenNamedMethods();
        ArrayList<CodegenTypedParam> rowMembers = new ArrayList<CodegenTypedParam>();
        for (Map.Entry<CodegenExpressionMemberWCol, EPTypeClass> entry : assignment.getMembers().getMembers().entrySet()) {
            rowMembers.add(new CodegenTypedParam(entry.getValue(), entry.getKey().getRef(), false, true));
        }
        rowCtorConsumer.accept(new AggregationRowCtorDesc(classScope, assignment.getCtor(), rowMembers, namedMethods));
        CodegenMethod applyEnterMethod = AggregationServiceFactoryCompilerRow.produceStateUpdate(!table, AggregationCodegenUpdateType.APPLYENTER, assignment, classScope, namedMethods);
        CodegenMethod applyLeaveMethod = AggregationServiceFactoryCompilerRow.produceStateUpdate(!table, AggregationCodegenUpdateType.APPLYLEAVE, assignment, classScope, namedMethods);
        CodegenMethod clearMethod = AggregationServiceFactoryCompilerRow.produceStateUpdate(true, AggregationCodegenUpdateType.CLEAR, assignment, classScope, namedMethods);
        CodegenMethod getAccessStateMethod = AggregationServiceFactoryCompilerRow.produceGetAccessState(assignment.getOffset() + numMethodFactories, assignment.getAccessStateFactories(), classScope);
        CodegenMethod enterAggMethod = AggregationServiceFactoryCompilerRow.produceTableMethod(offset, table, AggregationCodegenTableUpdateType.ENTER, assignment.getMethodFactories(), classScope);
        CodegenMethod leaveAggMethod = AggregationServiceFactoryCompilerRow.produceTableMethod(offset, table, AggregationCodegenTableUpdateType.LEAVE, assignment.getMethodFactories(), classScope);
        CodegenMethod resetAggMethod = AggregationServiceFactoryCompilerRow.produceTableResetMethod(offset, table, assignment.getMethodFactories(), assignment.getAccessStateFactories(), classScope);
        CodegenMethod enterAccessMethod = AggregationServiceFactoryCompilerRow.produceTableAccess(offset + numMethodFactories, table, AggregationCodegenTableUpdateType.ENTER, assignment.getAccessStateFactories(), classScope, namedMethods);
        CodegenMethod leaveAccessMethod = AggregationServiceFactoryCompilerRow.produceTableAccess(offset + numMethodFactories, table, AggregationCodegenTableUpdateType.LEAVE, assignment.getAccessStateFactories(), classScope, namedMethods);
        CodegenMethod getValueMethod = AggregationServiceFactoryCompilerRow.produceGet(AggregationCodegenGetType.GETVALUE, assignment, classScope, namedMethods);
        CodegenMethod getEventBeanMethod = AggregationServiceFactoryCompilerRow.produceGet(AggregationCodegenGetType.GETEVENTBEAN, assignment, classScope, namedMethods);
        CodegenMethod getCollectionScalarMethod = AggregationServiceFactoryCompilerRow.produceGet(AggregationCodegenGetType.GETCOLLECTIONSCALAR, assignment, classScope, namedMethods);
        CodegenMethod getCollectionOfEventsMethod = AggregationServiceFactoryCompilerRow.produceGet(AggregationCodegenGetType.GETCOLLECTIONOFEVENTS, assignment, classScope, namedMethods);
        CodegenClassMethods innerMethods = new CodegenClassMethods();
        if (!standalone || !table) {
            CodegenStackGenerator.recursiveBuildStack(applyEnterMethod, "applyEnter", innerMethods);
            CodegenStackGenerator.recursiveBuildStack(applyLeaveMethod, "applyLeave", innerMethods);
        }
        CodegenStackGenerator.recursiveBuildStack(clearMethod, "clear", innerMethods);
        if (table || !standalone) {
            CodegenStackGenerator.recursiveBuildStack(enterAggMethod, "enterAgg", innerMethods);
            CodegenStackGenerator.recursiveBuildStack(leaveAggMethod, "leaveAgg", innerMethods);
            CodegenStackGenerator.recursiveBuildStack(resetAggMethod, "reset", innerMethods);
            CodegenStackGenerator.recursiveBuildStack(enterAccessMethod, "enterAccess", innerMethods);
            CodegenStackGenerator.recursiveBuildStack(leaveAccessMethod, "leaveAccess", innerMethods);
        }
        CodegenStackGenerator.recursiveBuildStack(getAccessStateMethod, "getAccessState", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(getValueMethod, "getValue", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(getEventBeanMethod, "getEventBean", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(getCollectionScalarMethod, "getCollectionScalar", innerMethods);
        CodegenStackGenerator.recursiveBuildStack(getCollectionOfEventsMethod, "getCollectionOfEvents", innerMethods);
        for (Map.Entry<String, CodegenMethod> methodEntry : namedMethods.getMethods().entrySet()) {
            CodegenStackGenerator.recursiveBuildStack(methodEntry.getValue(), methodEntry.getKey(), innerMethods);
        }
        return new CodegenInnerClass(assignment.getClassName(), null, assignment.getCtor(), rowMembers, innerMethods);
    }

    private static CodegenMethod produceTableMethod(int offset, boolean isGenerateTableEnter, AggregationCodegenTableUpdateType type, AggregationForgeFactory[] methodFactories, CodegenClassScope classScope) {
        CodegenMethod method = AggregationServiceFactoryCompilerRow.makeMethodTableEnterLeave(classScope);
        if (!isGenerateTableEnter) {
            method.getBlock().methodThrowUnsupported();
            return method;
        }
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(AggregationServiceCodegenNames.REF_SCOL, methodFactories.length, true, offset);
        for (int i = 0; i < methodFactories.length; ++i) {
            AggregationForgeFactory factory = methodFactories[i];
            EPType[] evaluationTypes = ExprNodeUtilityQuery.getExprResultTypes(factory.getAggregationExpression().getPositionalParams());
            CodegenMethod updateMethod = method.makeChild(EPTypePremade.VOID.getEPType(), factory.getAggregator().getClass(), (CodegenScope)classScope).addParam(EPTypePremade.OBJECT.getEPType(), "value");
            if (type == AggregationCodegenTableUpdateType.ENTER) {
                factory.getAggregator().applyTableEnterCodegen(AggregationServiceCodegenNames.REF_VALUE, evaluationTypes, updateMethod, classScope);
            } else {
                factory.getAggregator().applyTableLeaveCodegen(AggregationServiceCodegenNames.REF_VALUE, evaluationTypes, updateMethod, classScope);
            }
            blocks[i].localMethod(updateMethod, AggregationServiceCodegenNames.REF_VALUE).blockReturnNoValue();
        }
        return method;
    }

    private static CodegenMethod makeMethodTableEnterLeave(CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), AggregationServiceFactoryCompilerRow.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "scol").addParam(EPTypePremade.OBJECT.getEPType(), "value");
    }

    private static CodegenMethod produceTableResetMethod(int offset, boolean isGenerateTableEnter, AggregationForgeFactory[] methodFactories, AggregationStateFactoryForge[] accessFactories, CodegenClassScope classScope) {
        CodegenMethod resetMethod;
        CodegenMethod method = AggregationServiceFactoryCompilerRow.makeMethodTableReset(classScope);
        if (!isGenerateTableEnter) {
            method.getBlock().methodThrowUnsupported();
            return method;
        }
        ArrayList<CodegenMethod> methods = new ArrayList<CodegenMethod>();
        if (methodFactories != null) {
            for (AggregationForgeFactory factory : methodFactories) {
                resetMethod = method.makeChild(EPTypePremade.VOID.getEPType(), factory.getAggregator().getClass(), (CodegenScope)classScope);
                factory.getAggregator().clearCodegen(resetMethod, classScope);
                methods.add(resetMethod);
            }
        }
        if (accessFactories != null) {
            for (AggregationStateFactoryForge accessFactory : accessFactories) {
                resetMethod = method.makeChild(EPTypePremade.VOID.getEPType(), accessFactory.getAggregator().getClass(), (CodegenScope)classScope);
                accessFactory.getAggregator().clearCodegen(resetMethod, classScope);
                methods.add(resetMethod);
            }
        }
        CodegenBlock[] blocks = method.getBlock().switchBlockOfLength(AggregationServiceCodegenNames.REF_SCOL, methods.size(), false, offset);
        int count = 0;
        for (CodegenMethod getValue : methods) {
            blocks[count++].expression(CodegenExpressionBuilder.localMethod(getValue, new CodegenExpression[0]));
        }
        return method;
    }

    private static CodegenMethod makeMethodTableReset(CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), AggregationServiceFactoryCompilerRow.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "scol");
    }

    private static CodegenMethod produceTableAccess(int offset, boolean isGenerateTableEnter, AggregationCodegenTableUpdateType type, AggregationStateFactoryForge[] accessStateFactories, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethod method = AggregationServiceFactoryCompilerRow.makeMethodTableAccess(classScope);
        if (!isGenerateTableEnter) {
            method.getBlock().methodThrowUnsupported();
            return method;
        }
        int[] colums = new int[accessStateFactories.length];
        for (int i = 0; i < accessStateFactories.length; ++i) {
            colums[i] = offset + i;
        }
        CodegenBlock[] blocks = method.getBlock().switchBlockOptions(AggregationServiceCodegenNames.REF_SCOL, colums, true);
        for (int i = 0; i < accessStateFactories.length; ++i) {
            AggregationStateFactoryForge stateFactoryForge = accessStateFactories[i];
            AggregatorAccess aggregator = stateFactoryForge.getAggregator();
            ExprForgeCodegenSymbol symbols = new ExprForgeCodegenSymbol(false, null);
            CodegenMethod updateMethod = method.makeChildWithScope(EPTypePremade.VOID.getEPType(), stateFactoryForge.getClass(), (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(ExprForgeCodegenNames.PARAMS);
            if (type == AggregationCodegenTableUpdateType.ENTER) {
                aggregator.applyEnterCodegen(updateMethod, symbols, classScope, namedMethods);
                blocks[i].localMethod(updateMethod, ExprForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constantTrue(), ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
            } else {
                aggregator.applyLeaveCodegen(updateMethod, symbols, classScope, namedMethods);
                blocks[i].localMethod(updateMethod, ExprForgeCodegenNames.REF_EPS, CodegenExpressionBuilder.constantFalse(), ExprForgeCodegenNames.REF_EXPREVALCONTEXT);
            }
            blocks[i].blockReturnNoValue();
        }
        return method;
    }

    private static CodegenMethod makeMethodTableAccess(CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), AggregationServiceFactoryCompilerRow.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "scol").addParam(EventBean.EPTYPEARRAY, "eventsPerStream").addParam(ExprEvaluatorContext.EPTYPE, "exprEvalCtx");
    }

    private static CodegenMethod produceGetAccessState(int offset, AggregationStateFactoryForge[] accessStateFactories, CodegenClassScope classScope) {
        CodegenMethod method = AggregationServiceFactoryCompilerRow.makeMethodGetAccess(classScope);
        int[] colums = new int[accessStateFactories == null ? 0 : accessStateFactories.length];
        for (int i = 0; i < colums.length; ++i) {
            colums[i] = offset + i;
        }
        CodegenBlock[] blocks = method.getBlock().switchBlockOptions(AggregationServiceCodegenNames.REF_SCOL, colums, true);
        for (int i = 0; i < colums.length; ++i) {
            AggregationStateFactoryForge stateFactoryForge = accessStateFactories[i];
            CodegenExpression expr = stateFactoryForge.codegenGetAccessTableState(i + offset, method, classScope);
            blocks[i].blockReturn(expr);
        }
        return method;
    }

    private static CodegenMethod makeMethodGetAccess(CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), AggregationServiceFactoryCompilerRow.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "scol");
    }

    private static CodegenMethod produceGet(AggregationCodegenGetType getType, AggregationClassAssignment assignment, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        CodegenMethod method;
        CodegenMethod parent = AggregationServiceFactoryCompilerRow.makeMethodGet(getType, classScope);
        if (getType != AggregationCodegenGetType.GETVALUE && (assignment.getAccessStateFactories() == null || assignment.getAccessStateFactories().length == 0)) {
            parent.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
            return parent;
        }
        ArrayList<CodegenMethod> methods = new ArrayList<CodegenMethod>();
        ArrayList<Integer> vcols = new ArrayList<Integer>(8);
        for (AggregationVColMethod vcolMethod : assignment.getVcolMethods()) {
            method = parent.makeChild(getType.getReturnType(), vcolMethod.getForge().getClass(), (CodegenScope)classScope).addParam(CodegenNamedParam.from(EventBean.EPTYPEARRAY, "eventsPerStream", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"));
            methods.add(method);
            if (getType == AggregationCodegenGetType.GETVALUE) {
                vcolMethod.getForge().getAggregator().getValueCodegen(method, classScope);
            } else {
                method.getBlock().methodReturn(CodegenExpressionBuilder.constantNull());
            }
            vcols.add(vcolMethod.getVcol());
        }
        for (AggregationVColAccess vcolAccess : assignment.getVcolAccess()) {
            method = parent.makeChild(getType.getReturnType(), vcolAccess.getAccessorForge().getClass(), (CodegenScope)classScope).addParam(CodegenNamedParam.from(EventBean.EPTYPEARRAY, "eventsPerStream", EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isNewData", ExprEvaluatorContext.EPTYPE, "exprEvalCtx"));
            AggregationAccessorForgeGetCodegenContext ctx = new AggregationAccessorForgeGetCodegenContext(vcolAccess.getStateNumber(), classScope, vcolAccess.getStateForge(), method, namedMethods);
            switch (getType) {
                case GETVALUE: {
                    vcolAccess.getAccessorForge().getValueCodegen(ctx);
                    break;
                }
                case GETEVENTBEAN: {
                    vcolAccess.getAccessorForge().getEnumerableEventCodegen(ctx);
                    break;
                }
                case GETCOLLECTIONSCALAR: {
                    vcolAccess.getAccessorForge().getEnumerableScalarCodegen(ctx);
                    break;
                }
                case GETCOLLECTIONOFEVENTS: {
                    vcolAccess.getAccessorForge().getEnumerableEventsCodegen(ctx);
                }
            }
            methods.add(method);
            vcols.add(vcolAccess.getVcol());
        }
        int[] options = IntArrayUtil.toArray(vcols);
        CodegenBlock[] blocks = parent.getBlock().switchBlockOptions(AggregationServiceCodegenNames.REF_VCOL, options, true);
        int count = 0;
        for (CodegenMethod getValue : methods) {
            blocks[count++].blockReturn(CodegenExpressionBuilder.localMethod(getValue, ExprForgeCodegenNames.REF_EPS, ExprForgeCodegenNames.REF_ISNEWDATA, ExprForgeCodegenNames.REF_EXPREVALCONTEXT));
        }
        return parent;
    }

    private static CodegenMethod makeMethodGet(AggregationCodegenGetType getType, CodegenClassScope classScope) {
        return CodegenMethod.makeParentNode(getType.getReturnType(), AggregationServiceFactoryCompilerRow.class, (CodegenSymbolProvider)CodegenSymbolProviderEmpty.INSTANCE, (CodegenScope)classScope).addParam(AggregationServiceFactoryCompiler.GETPARAMS);
    }

    private static CodegenMethod produceStateUpdate(boolean isGenerate, AggregationCodegenUpdateType updateType, AggregationClassAssignment assignment, CodegenClassScope classScope, CodegenNamedMethods namedMethods) {
        String exprText;
        ExprForgeCodegenSymbol symbols = new ExprForgeCodegenSymbol(true, updateType == AggregationCodegenUpdateType.APPLYENTER);
        CodegenMethod parent = CodegenMethod.makeParentNode(EPTypePremade.VOID.getEPType(), AggregationServiceFactoryCompilerRow.class, (CodegenSymbolProvider)symbols, (CodegenScope)classScope).addParam(updateType.getParams());
        int count = 0;
        ArrayList<CodegenMethod> methods = new ArrayList<CodegenMethod>();
        if (assignment.getMethodFactories() != null && isGenerate) {
            for (AggregationForgeFactory aggregationForgeFactory : assignment.getMethodFactories()) {
                exprText = null;
                CodegenExpression getValue = null;
                if (classScope.isInstrumented()) {
                    exprText = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(aggregationForgeFactory.getAggregationExpression());
                    getValue = CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("this"), "getValue", CodegenExpressionBuilder.constant(count), CodegenExpressionBuilder.constantNull(), CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constantNull());
                }
                CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), aggregationForgeFactory.getClass(), (CodegenScope)classScope);
                methods.add(method);
                switch (updateType) {
                    case APPLYENTER: {
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "qAggNoAccessEnterLeave", CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constant(count), getValue, CodegenExpressionBuilder.constant(exprText)));
                        aggregationForgeFactory.getAggregator().applyEvalEnterCodegen(method, symbols, assignment.getMethodForges()[count], classScope);
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "aAggNoAccessEnterLeave", CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constant(count), getValue));
                        break;
                    }
                    case APPLYLEAVE: {
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "qAggNoAccessEnterLeave", CodegenExpressionBuilder.constantFalse(), CodegenExpressionBuilder.constant(count), getValue, CodegenExpressionBuilder.constant(exprText)));
                        aggregationForgeFactory.getAggregator().applyEvalLeaveCodegen(method, symbols, assignment.getMethodForges()[count], classScope);
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "aAggNoAccessEnterLeave", CodegenExpressionBuilder.constantFalse(), CodegenExpressionBuilder.constant(count), getValue));
                        break;
                    }
                    case CLEAR: {
                        aggregationForgeFactory.getAggregator().clearCodegen(method, classScope);
                    }
                }
                ++count;
            }
        }
        if (assignment.getAccessStateFactories() != null && isGenerate) {
            for (AggregationStateFactoryForge aggregationStateFactoryForge : assignment.getAccessStateFactories()) {
                exprText = null;
                if (classScope.isInstrumented()) {
                    exprText = ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(aggregationStateFactoryForge.getExpression());
                }
                CodegenMethod method = parent.makeChild(EPTypePremade.VOID.getEPType(), aggregationStateFactoryForge.getClass(), (CodegenScope)classScope);
                methods.add(method);
                switch (updateType) {
                    case APPLYENTER: {
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "qAggAccessEnterLeave", CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constant(count), CodegenExpressionBuilder.constant(exprText)));
                        aggregationStateFactoryForge.getAggregator().applyEnterCodegen(method, symbols, classScope, namedMethods);
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "aAggAccessEnterLeave", CodegenExpressionBuilder.constantTrue(), CodegenExpressionBuilder.constant(count)));
                        break;
                    }
                    case APPLYLEAVE: {
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "qAggAccessEnterLeave", CodegenExpressionBuilder.constantFalse(), CodegenExpressionBuilder.constant(count), CodegenExpressionBuilder.constant(exprText)));
                        aggregationStateFactoryForge.getAggregator().applyLeaveCodegen(method, symbols, classScope, namedMethods);
                        method.getBlock().apply(InstrumentationCode.instblock(classScope, "aAggAccessEnterLeave", CodegenExpressionBuilder.constantFalse(), CodegenExpressionBuilder.constant(count)));
                        break;
                    }
                    case CLEAR: {
                        aggregationStateFactoryForge.getAggregator().clearCodegen(method, classScope);
                    }
                }
                ++count;
            }
        }
        symbols.derivedSymbolsCodegen(parent, parent.getBlock(), classScope);
        for (CodegenMethod method : methods) {
            parent.getBlock().localMethod(method, new CodegenExpression[0]);
        }
        return parent;
    }

    private static enum AggregationCodegenUpdateType {
        APPLYENTER(AggregationServiceFactoryCompiler.UPDPARAMS),
        APPLYLEAVE(AggregationServiceFactoryCompiler.UPDPARAMS),
        CLEAR(Collections.emptyList());

        private final List<CodegenNamedParam> params;

        private AggregationCodegenUpdateType(List<CodegenNamedParam> params) {
            this.params = params;
        }

        public List<CodegenNamedParam> getParams() {
            return this.params;
        }
    }

    private static enum AggregationCodegenGetType {
        GETVALUE("getValue", EPTypePremade.OBJECT.getEPType()),
        GETEVENTBEAN("getEnumerableEvent", EventBean.EPTYPE),
        GETCOLLECTIONSCALAR("getEnumerableScalar", EPTypePremade.COLLECTION.getEPType()),
        GETCOLLECTIONOFEVENTS("getEnumerableEvents", EPTypePremade.COLLECTION.getEPType());

        private final String accessorMethodName;
        private final EPTypeClass returnType;

        private AggregationCodegenGetType(String accessorMethodName, EPTypeClass returnType) {
            this.accessorMethodName = accessorMethodName;
            this.returnType = returnType;
        }

        public EPTypeClass getReturnType() {
            return this.returnType;
        }

        public String getAccessorMethodName() {
            return this.accessorMethodName;
        }
    }

    private static enum AggregationCodegenTableUpdateType {
        ENTER,
        LEAVE;

    }
}

