/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.plugin;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionForge;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionMode;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionModeCodeGenerated;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionModeManaged;
import com.espertech.esper.common.client.hook.aggfunc.AggregationFunctionModeMultiParam;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregationForgeFactoryBase;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethod;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodFactoryContext;
import com.espertech.esper.common.internal.epl.agg.method.plugin.AggregationPortableValidationPlugin;
import com.espertech.esper.common.internal.epl.agg.method.plugin.AggregatorPlugInManaged;
import com.espertech.esper.common.internal.epl.agg.method.plugin.AggregatorPlugInMultiParam;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprMethodAggUtil;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprPlugInAggNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;

public class AggregationForgeFactoryPlugin
extends AggregationForgeFactoryBase {
    protected final ExprPlugInAggNode parent;
    protected final AggregationFunctionForge aggregationFunctionForge;
    private final AggregationFunctionMode mode;
    private final EPType aggregatedValueType;
    private final DataInputOutputSerdeForge distinctSerde;
    private final AggregatorMethod aggregator;

    public AggregationForgeFactoryPlugin(ExprPlugInAggNode parent, AggregationFunctionForge aggregationFunctionForge, AggregationFunctionMode mode, EPType aggregatedValueType, DataInputOutputSerdeForge distinctSerde) {
        this.parent = parent;
        this.aggregationFunctionForge = aggregationFunctionForge;
        this.mode = mode;
        this.aggregatedValueType = aggregatedValueType;
        this.distinctSerde = distinctSerde;
        if (mode instanceof AggregationFunctionModeManaged) {
            AggregationFunctionModeManaged singleValue = (AggregationFunctionModeManaged)mode;
            if (parent.getPositionalParams().length == 0) {
                throw new IllegalArgumentException(AggregationFunctionModeManaged.class.getSimpleName() + " requires at least one positional parameter");
            }
            EPType distinctType = !parent.isDistinct() ? null : aggregatedValueType;
            this.aggregator = new AggregatorPlugInManaged(distinctType, distinctSerde, parent.getChildNodes().length > 1, parent.getOptionalFilter(), singleValue);
        } else if (mode instanceof AggregationFunctionModeMultiParam) {
            AggregationFunctionModeMultiParam multiParam = (AggregationFunctionModeMultiParam)mode;
            this.aggregator = new AggregatorPlugInMultiParam(multiParam);
        } else if (mode instanceof AggregationFunctionModeCodeGenerated) {
            AggregationFunctionModeCodeGenerated codeGenerated = (AggregationFunctionModeCodeGenerated)mode;
            this.aggregator = codeGenerated.getAggregatorMethodFactory().getAggregatorMethod(new AggregatorMethodFactoryContext(this));
        } else {
            throw new IllegalStateException("Received an unrecognized value for mode, the value is " + mode);
        }
    }

    @Override
    public EPType getResultType() {
        return this.aggregationFunctionForge.getValueType();
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    @Override
    public AggregatorMethod getAggregator() {
        return this.aggregator;
    }

    @Override
    public AggregationPortableValidation getAggregationPortableValidation() {
        return new AggregationPortableValidationPlugin(this.parent.isDistinct(), this.parent.getAggregationFunctionName());
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    public AggregationFunctionForge getAggregationFunctionForge() {
        return this.aggregationFunctionForge;
    }

    public ExprPlugInAggNode getParent() {
        return this.parent;
    }

    public AggregationFunctionMode getMode() {
        return this.mode;
    }

    public EPType getAggregatedValueType() {
        return this.aggregatedValueType;
    }

    public DataInputOutputSerdeForge getDistinctSerde() {
        return this.distinctSerde;
    }
}

