/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.rate;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMemberCol;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.core.CodegenCtor;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionMember;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethodWDistinctWFilterBase;
import com.espertech.esper.common.internal.epl.agg.method.rate.AggregationForgeFactoryRate;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.fabric.FabricTypeCollector;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;

public class AggregatorRate
extends AggregatorMethodWDistinctWFilterBase {
    protected AggregationForgeFactoryRate factory;
    protected CodegenExpressionMember accumulator;
    protected CodegenExpressionMember latest;
    protected CodegenExpressionMember oldest;
    protected CodegenExpressionMember isSet;

    public AggregatorRate(AggregationForgeFactoryRate factory, EPTypeClass optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter) {
        super(optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter);
        this.factory = factory;
    }

    @Override
    public void initForgeFiltered(int col, CodegenCtor rowCtor, CodegenMemberCol membersColumnized, CodegenClassScope classScope) {
        this.accumulator = membersColumnized.addMember(col, EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "accumulator");
        this.latest = membersColumnized.addMember(col, EPTypePremade.LONGPRIMITIVE.getEPType(), "latest");
        this.oldest = membersColumnized.addMember(col, EPTypePremade.LONGPRIMITIVE.getEPType(), "oldest");
        this.isSet = membersColumnized.addMember(col, EPTypePremade.BOOLEANPRIMITIVE.getEPType(), "isSet");
    }

    @Override
    protected void applyEvalEnterFiltered(CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        int numFilters;
        EPTypeClass firstType = (EPTypeClass)forges[0].getEvaluationType();
        CodegenExpression firstExpr = forges[0].evaluateCodegen(EPTypePremade.LONGPRIMITIVE.getEPType(), method, symbols, classScope);
        method.getBlock().assignRef(this.latest, SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(firstExpr, firstType));
        int n = numFilters = this.factory.getParent().getOptionalFilter() != null ? 1 : 0;
        if (forges.length == numFilters + 1) {
            method.getBlock().increment(this.accumulator);
        } else {
            EPTypeClass secondType = (EPTypeClass)forges[1].getEvaluationType();
            CodegenExpression secondExpr = forges[1].evaluateCodegen(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), method, symbols, classScope);
            method.getBlock().assignCompound(this.accumulator, "+", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(secondExpr, secondType));
        }
    }

    @Override
    protected void applyEvalLeaveFiltered(CodegenMethod method, ExprForgeCodegenSymbol symbols, ExprForge[] forges, CodegenClassScope classScope) {
        int numFilters = this.factory.getParent().getOptionalFilter() != null ? 1 : 0;
        EPTypeClass firstType = (EPTypeClass)forges[0].getEvaluationType();
        CodegenExpression firstExpr = forges[0].evaluateCodegen(EPTypePremade.LONGPRIMITIVE.getEPType(), method, symbols, classScope);
        method.getBlock().assignRef(this.oldest, SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(firstExpr, firstType)).ifCondition(CodegenExpressionBuilder.not(this.isSet)).assignRef(this.isSet, CodegenExpressionBuilder.constantTrue());
        if (forges.length == numFilters + 1) {
            method.getBlock().decrement(this.accumulator);
        } else {
            EPTypeClass secondType = (EPTypeClass)forges[1].getEvaluationType();
            CodegenExpression secondExpr = forges[1].evaluateCodegen(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), method, symbols, classScope);
            method.getBlock().assignCompound(this.accumulator, "-", SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(secondExpr, secondType));
        }
    }

    @Override
    protected void applyTableEnterFiltered(CodegenExpressionRef value, EPType[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        throw new UnsupportedOperationException("Not available with tables");
    }

    @Override
    protected void applyTableLeaveFiltered(CodegenExpressionRef value, EPType[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        throw new UnsupportedOperationException("Not available with tables");
    }

    @Override
    protected void clearWODistinct(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().assignRef(this.accumulator, CodegenExpressionBuilder.constant(0)).assignRef(this.latest, CodegenExpressionBuilder.constant(0)).assignRef(this.oldest, CodegenExpressionBuilder.constant(0));
    }

    @Override
    public void getValueCodegen(CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().ifCondition(CodegenExpressionBuilder.not(this.isSet)).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.op(CodegenExpressionBuilder.op(this.accumulator, "*", CodegenExpressionBuilder.constant(this.factory.getTimeAbacus().getOneSecond())), "/", CodegenExpressionBuilder.op(this.latest, "-", this.oldest)));
    }

    @Override
    protected void writeWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef output, CodegenExpressionRef unitKey, CodegenExpressionRef writer, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.writeDouble(output, row, this.accumulator)).apply(AggregatorCodegenUtil.writeLong(output, row, this.latest)).apply(AggregatorCodegenUtil.writeLong(output, row, this.oldest)).apply(AggregatorCodegenUtil.writeBoolean(output, row, this.isSet));
    }

    @Override
    protected void readWODistinct(CodegenExpressionRef row, int col, CodegenExpressionRef input, CodegenExpressionRef unitKey, CodegenMethod method, CodegenClassScope classScope) {
        method.getBlock().apply(AggregatorCodegenUtil.readDouble(row, this.accumulator, input)).apply(AggregatorCodegenUtil.readLong(row, this.latest, input)).apply(AggregatorCodegenUtil.readLong(row, this.oldest, input)).apply(AggregatorCodegenUtil.readBoolean(row, this.isSet, input));
    }

    @Override
    protected void appendFormatWODistinct(FabricTypeCollector collector) {
        collector.builtin(Double.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
    }
}

