/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.sum;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.epl.agg.core.AggregationPortableValidation;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregationForgeFactoryBase;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorMethod;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregationPortableValidationSum;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumBig;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumNonBig;
import com.espertech.esper.common.internal.epl.expression.agg.base.ExprAggregateNodeBase;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprMethodAggUtil;
import com.espertech.esper.common.internal.epl.expression.agg.method.ExprSumNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AggregationForgeFactorySum
extends AggregationForgeFactoryBase {
    protected final ExprSumNode parent;
    protected final EPTypeClass resultType;
    protected final EPTypeClass inputValueType;
    protected final DataInputOutputSerdeForge distinctSerde;
    protected AggregatorMethod aggregator;

    public AggregationForgeFactorySum(ExprSumNode parent, EPTypeClass inputValueType, DataInputOutputSerdeForge distinctSerde) {
        this.parent = parent;
        this.inputValueType = inputValueType;
        this.distinctSerde = distinctSerde;
        this.resultType = this.getSumAggregatorType(inputValueType);
        EPTypeClass distinctValueType = !parent.isDistinct() ? null : inputValueType;
        this.aggregator = this.resultType.getType() == BigInteger.class || this.resultType.getType() == BigDecimal.class ? new AggregatorSumBig(distinctValueType, distinctSerde, parent.isHasFilter(), parent.getOptionalFilter(), this.resultType) : new AggregatorSumNonBig(distinctValueType, distinctSerde, parent.isHasFilter(), parent.getOptionalFilter(), this.resultType);
    }

    @Override
    public EPType getResultType() {
        return this.resultType;
    }

    @Override
    public ExprAggregateNodeBase getAggregationExpression() {
        return this.parent;
    }

    @Override
    public AggregatorMethod getAggregator() {
        return this.aggregator;
    }

    @Override
    public ExprForge[] getMethodAggregationForge(boolean join, EventType[] typesPerStream) throws ExprValidationException {
        return ExprMethodAggUtil.getDefaultForges(this.parent.getPositionalParams(), join, typesPerStream);
    }

    @Override
    public AggregationPortableValidation getAggregationPortableValidation() {
        return new AggregationPortableValidationSum(this.parent.isDistinct(), this.parent.isHasFilter(), this.inputValueType);
    }

    private EPTypeClass getSumAggregatorType(EPTypeClass type) {
        if (type.getType() == BigInteger.class) {
            return EPTypePremade.BIGINTEGER.getEPType();
        }
        if (type.getType() == BigDecimal.class) {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }
        return JavaClassHelper.getBoxedType(AggregationForgeFactorySum.getMemberType(type));
    }

    protected static SimpleNumberCoercer getCoercerNonBigIntDec(Class inputValueType) {
        SimpleNumberCoercer coercer = inputValueType == Long.class || inputValueType == Long.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerLong.INSTANCE : (JavaClassHelper.isTypeInteger(inputValueType) ? SimpleNumberCoercerFactory.SimpleNumberCoercerInt.INSTANCE : (inputValueType == Double.class || inputValueType == Double.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.INSTANCE : (inputValueType == Float.class || inputValueType == Float.TYPE ? SimpleNumberCoercerFactory.SimpleNumberCoercerFloat.INSTANCE : SimpleNumberCoercerFactory.SimpleNumberCoercerInt.INSTANCE)));
        return coercer;
    }

    protected static EPTypeClass getMemberType(EPTypeClass type) {
        Class<?> inputValueType = type.getType();
        if (inputValueType == Long.class || inputValueType == Long.TYPE) {
            return EPTypePremade.LONGPRIMITIVE.getEPType();
        }
        if (JavaClassHelper.isTypeInteger(inputValueType)) {
            return EPTypePremade.INTEGERPRIMITIVE.getEPType();
        }
        if (inputValueType == Double.class || inputValueType == Double.TYPE) {
            return EPTypePremade.DOUBLEPRIMITIVE.getEPType();
        }
        if (inputValueType == Float.class || inputValueType == Float.TYPE) {
            return EPTypePremade.FLOATPRIMITIVE.getEPType();
        }
        return EPTypePremade.INTEGERPRIMITIVE.getEPType();
    }
}

