/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.method.sum;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.epl.agg.method.core.AggregatorCodegenUtil;
import com.espertech.esper.common.internal.epl.agg.method.sum.AggregatorSumBase;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.fabric.FabricTypeCollector;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeForge;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalBigIntegerUtil;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AggregatorSumBig
extends AggregatorSumBase {
    public AggregatorSumBig(EPTypeClass optionalDistinctValueType, DataInputOutputSerdeForge optionalDistinctSerde, boolean hasFilter, ExprNode optionalFilter, EPTypeClass sumType) {
        super(optionalDistinctValueType, optionalDistinctSerde, hasFilter, optionalFilter, sumType);
        if (sumType.getType() != BigInteger.class && sumType.getType() != BigDecimal.class) {
            throw new IllegalArgumentException("Invalid type " + sumType);
        }
    }

    @Override
    protected CodegenExpression initOfSum() {
        return this.sumType.getType() == BigInteger.class ? CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.constant(0)) : CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.constant(0.0));
    }

    @Override
    protected void applyAggEnterSum(CodegenExpressionRef value, EPType valueType, CodegenMethod method) {
        EPTypeClass valueClass = (EPTypeClass)valueType;
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", valueClass.getType().equals(this.sumType.getType()) ? value : CodegenExpressionBuilder.cast(this.sumType, (CodegenExpression)value)));
    }

    @Override
    protected void applyAggLeaveSum(CodegenExpressionRef value, EPType valueType, CodegenMethod method) {
        EPTypeClass valueClass = (EPTypeClass)valueType;
        method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", valueClass.getType().equals(this.sumType.getType()) ? value : CodegenExpressionBuilder.cast(this.sumType, (CodegenExpression)value)));
    }

    @Override
    protected void applyTableEnterSum(CodegenExpressionRef value, EPType[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        if (evaluationTypes[0] != EPTypeNull.INSTANCE) {
            method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "add", CodegenExpressionBuilder.cast((EPTypeClass)evaluationTypes[0], (CodegenExpression)value)));
        }
    }

    @Override
    protected void applyTableLeaveSum(CodegenExpressionRef value, EPType[] evaluationTypes, CodegenMethod method, CodegenClassScope classScope) {
        if (evaluationTypes[0] != EPTypeNull.INSTANCE) {
            method.getBlock().assignRef(this.sum, CodegenExpressionBuilder.exprDotMethod(this.sum, "subtract", CodegenExpressionBuilder.cast((EPTypeClass)evaluationTypes[0], (CodegenExpression)value)));
        }
    }

    @Override
    protected void writeSum(CodegenExpressionRef row, CodegenExpressionRef output, CodegenMethod method, CodegenClassScope classScope) {
        if (this.sumType.getType() == BigInteger.class) {
            method.getBlock().staticMethod(DIOBigDecimalBigIntegerUtil.class, "writeBigInt", AggregatorCodegenUtil.rowDotMember(row, this.sum), output);
        } else {
            method.getBlock().staticMethod(DIOBigDecimalBigIntegerUtil.class, "writeBigDec", AggregatorCodegenUtil.rowDotMember(row, this.sum), output);
        }
    }

    @Override
    protected void readSum(CodegenExpressionRef row, CodegenExpressionRef input, CodegenMethod method, CodegenClassScope classScope) {
        if (this.sumType.getType() == BigInteger.class) {
            method.getBlock().assignRef(AggregatorCodegenUtil.rowDotMember(row, this.sum), CodegenExpressionBuilder.staticMethod(DIOBigDecimalBigIntegerUtil.class, "readBigInt", input));
        } else {
            method.getBlock().assignRef(AggregatorCodegenUtil.rowDotMember(row, this.sum), CodegenExpressionBuilder.staticMethod(DIOBigDecimalBigIntegerUtil.class, "readBigDec", input));
        }
    }

    @Override
    protected void appendSumFormat(FabricTypeCollector collector) {
        if (this.sumType.getType() == BigInteger.class) {
            collector.bigInteger();
        } else {
            collector.bigDecimal();
        }
    }
}

