/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.agg.rollup;

import com.espertech.esper.common.internal.collection.CombinationEnumeration;
import com.espertech.esper.common.internal.collection.MultiKeyArrayInt;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElement;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementCombinedExpr;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementExpr;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementGroupingSet;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseElementRollupOrCube;
import com.espertech.esper.common.internal.compile.stage1.spec.GroupByClauseExpressions;
import com.espertech.esper.common.internal.compile.stage1.spec.OrderByItem;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseElementRaw;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseExprRawSpec;
import com.espertech.esper.common.internal.compile.stage1.spec.SelectClauseSpecRaw;
import com.espertech.esper.common.internal.compile.stage1.specmapper.ExpressionCopier;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupDuplicateException;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupEvalContext;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupNodeBase;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupNodeCombinedExpr;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupNodeGroupingSet;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupNodeRollupOrCube;
import com.espertech.esper.common.internal.epl.agg.rollup.GroupByRollupNodeSingleExpr;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCompare;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityPrint;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;

public class GroupByExpressionHelper {
    public static GroupByClauseExpressions getGroupByRollupExpressions(List<GroupByClauseElement> groupByElements, SelectClauseSpecRaw selectClauseSpec, ExprNode optionalHavingNode, List<OrderByItem> orderByList, ExpressionCopier expressionCopier) throws ExprValidationException {
        if (groupByElements == null || groupByElements.size() == 0) {
            return null;
        }
        GroupByExpressionInfo groupByExpressionInfo = GroupByExpressionHelper.groupByToRollupNodes(groupByElements);
        ArrayList<ExprNode> distinctGroupByExpressions = new ArrayList<ExprNode>();
        HashMap<ExprNode, Integer> expressionToIndex = new HashMap<ExprNode, Integer>();
        for (ExprNode exprNode : groupByExpressionInfo.getExpressions()) {
            boolean found = false;
            for (int i = 0; i < distinctGroupByExpressions.size(); ++i) {
                ExprNode other = (ExprNode)distinctGroupByExpressions.get(i);
                if (!ExprNodeUtilityCompare.deepEquals(exprNode, other, false)) continue;
                expressionToIndex.put(exprNode, i);
                found = true;
                break;
            }
            if (found) continue;
            expressionToIndex.put(exprNode, distinctGroupByExpressions.size());
            distinctGroupByExpressions.add(exprNode);
        }
        boolean hasGroupingSet = false;
        boolean hasRollup = false;
        for (GroupByClauseElement element : groupByElements) {
            if (element instanceof GroupByClauseElementGroupingSet) {
                hasGroupingSet = true;
            }
            if (!(element instanceof GroupByClauseElementRollupOrCube)) continue;
            hasRollup = true;
        }
        ExprNode[] groupByExpressions = distinctGroupByExpressions.toArray(new ExprNode[distinctGroupByExpressions.size()]);
        if (!hasRollup && !hasGroupingSet) {
            return new GroupByClauseExpressions(groupByExpressions);
        }
        List<GroupByRollupNodeBase> nodes = groupByExpressionInfo.getNodes();
        Object[][] perNodeCombinations = new Object[nodes.size()][];
        GroupByRollupEvalContext context = new GroupByRollupEvalContext(expressionToIndex);
        try {
            for (int i = 0; i < nodes.size(); ++i) {
                GroupByRollupNodeBase node = nodes.get(i);
                List<int[]> combinations = node.evaluate(context);
                perNodeCombinations[i] = new Object[combinations.size()];
                for (int j = 0; j < combinations.size(); ++j) {
                    perNodeCombinations[i][j] = combinations.get(j);
                }
            }
        }
        catch (GroupByRollupDuplicateException ex) {
            if (ex.getIndexes().length == 0) {
                throw new ExprValidationException("Failed to validate the group-by clause, found duplicate specification of the overall grouping '()'");
            }
            StringWriter writer = new StringWriter();
            String delimiter = "";
            for (int i = 0; i < ex.getIndexes().length; ++i) {
                writer.append(delimiter);
                writer.append(ExprNodeUtilityPrint.toExpressionStringMinPrecedenceSafe(groupByExpressions[ex.getIndexes()[i]]));
                delimiter = ", ";
            }
            throw new ExprValidationException("Failed to validate the group-by clause, found duplicate specification of expressions (" + writer.toString() + ")");
        }
        CombinationEnumeration combinationEnumeration = new CombinationEnumeration(perNodeCombinations);
        TreeSet<Integer> combination = new TreeSet<Integer>();
        LinkedHashSet<MultiKeyArrayInt> indexList = new LinkedHashSet<MultiKeyArrayInt>();
        while (combinationEnumeration.hasMoreElements()) {
            Object[] combinationOA;
            combination.clear();
            for (Object indexes : combinationOA = combinationEnumeration.nextElement()) {
                int[] indexarr;
                for (int anIndex : indexarr = (int[])indexes) {
                    combination.add(anIndex);
                }
            }
            int[] indexArr = CollectionUtil.intArray(combination);
            indexList.add(new MultiKeyArrayInt(indexArr));
        }
        int[][] rollupLevels = new int[indexList.size()][];
        int count = 0;
        for (MultiKeyArrayInt mk : indexList) {
            rollupLevels[count++] = mk.getKeys();
        }
        int numberOfLevels = rollupLevels.length;
        if (numberOfLevels == 1 && rollupLevels[0].length == 0) {
            throw new ExprValidationException("Failed to validate the group-by clause, the overall grouping '()' cannot be the only grouping");
        }
        List<SelectClauseElementRaw> expressions = selectClauseSpec.getSelectExprList();
        ExprNode[][] selects = new ExprNode[numberOfLevels][];
        for (int i = 0; i < numberOfLevels; ++i) {
            selects[i] = new ExprNode[expressions.size()];
            for (int j = 0; j < expressions.size(); ++j) {
                SelectClauseElementRaw selectRaw = expressions.get(j);
                if (!(selectRaw instanceof SelectClauseExprRawSpec)) {
                    throw new ExprValidationException("Group-by with rollup requires that the select-clause does not use wildcard");
                }
                SelectClauseExprRawSpec compiled = (SelectClauseExprRawSpec)selectRaw;
                selects[i][j] = GroupByExpressionHelper.copyVisitExpression(compiled.getSelectExpression(), expressionCopier);
            }
        }
        ExprNode[] optHavingNodeCopy = null;
        if (optionalHavingNode != null) {
            optHavingNodeCopy = new ExprNode[numberOfLevels];
            for (int i = 0; i < numberOfLevels; ++i) {
                optHavingNodeCopy[i] = GroupByExpressionHelper.copyVisitExpression(optionalHavingNode, expressionCopier);
            }
        }
        ExprNode[][] optOrderByCopy = null;
        if (orderByList != null && orderByList.size() > 0) {
            optOrderByCopy = new ExprNode[numberOfLevels][];
            for (int i = 0; i < numberOfLevels; ++i) {
                optOrderByCopy[i] = new ExprNode[orderByList.size()];
                for (int j = 0; j < orderByList.size(); ++j) {
                    OrderByItem element = orderByList.get(j);
                    optOrderByCopy[i][j] = GroupByExpressionHelper.copyVisitExpression(element.getExprNode(), expressionCopier);
                }
            }
        }
        return new GroupByClauseExpressions(groupByExpressions, rollupLevels, selects, optHavingNodeCopy, optOrderByCopy);
    }

    private static GroupByExpressionInfo groupByToRollupNodes(List<GroupByClauseElement> groupByExpressions) {
        ArrayList<GroupByRollupNodeBase> parents = new ArrayList<GroupByRollupNodeBase>(groupByExpressions.size());
        ArrayList<ExprNode> exprNodes = new ArrayList<ExprNode>();
        for (GroupByClauseElement element : groupByExpressions) {
            GroupByRollupNodeBase parent;
            if (element instanceof GroupByClauseElementExpr) {
                GroupByClauseElementExpr expr = (GroupByClauseElementExpr)element;
                exprNodes.add(expr.getExpr());
                parent = new GroupByRollupNodeSingleExpr(expr.getExpr());
            } else if (element instanceof GroupByClauseElementRollupOrCube) {
                spec = (GroupByClauseElementRollupOrCube)element;
                parent = new GroupByRollupNodeRollupOrCube(((GroupByClauseElementRollupOrCube)spec).isCube());
                GroupByExpressionHelper.groupByAddRollup((GroupByClauseElementRollupOrCube)spec, parent, exprNodes);
            } else if (element instanceof GroupByClauseElementGroupingSet) {
                spec = (GroupByClauseElementGroupingSet)element;
                parent = new GroupByRollupNodeGroupingSet();
                for (GroupByClauseElement groupElement : ((GroupByClauseElementGroupingSet)spec).getElements()) {
                    if (groupElement instanceof GroupByClauseElementExpr) {
                        GroupByClauseElementExpr single = (GroupByClauseElementExpr)groupElement;
                        exprNodes.add(single.getExpr());
                        parent.add(new GroupByRollupNodeSingleExpr(single.getExpr()));
                    }
                    if (groupElement instanceof GroupByClauseElementCombinedExpr) {
                        GroupByClauseElementCombinedExpr combined = (GroupByClauseElementCombinedExpr)groupElement;
                        exprNodes.addAll(combined.getExpressions());
                        parent.add(new GroupByRollupNodeCombinedExpr(combined.getExpressions()));
                    }
                    if (!(groupElement instanceof GroupByClauseElementRollupOrCube)) continue;
                    GroupByClauseElementRollupOrCube rollup = (GroupByClauseElementRollupOrCube)groupElement;
                    GroupByRollupNodeRollupOrCube node = new GroupByRollupNodeRollupOrCube(rollup.isCube());
                    GroupByExpressionHelper.groupByAddRollup(rollup, node, exprNodes);
                    parent.add(node);
                }
            } else {
                throw new IllegalStateException("Unexpected group-by clause element " + element);
            }
            parents.add(parent);
        }
        return new GroupByExpressionInfo(exprNodes, parents);
    }

    private static void groupByAddRollup(GroupByClauseElementRollupOrCube spec, GroupByRollupNodeBase parent, List<ExprNode> exprNodes) {
        for (GroupByClauseElement rolledUp : spec.getRollupExpressions()) {
            if (rolledUp instanceof GroupByClauseElementExpr) {
                GroupByClauseElementExpr expr = (GroupByClauseElementExpr)rolledUp;
                exprNodes.add(expr.getExpr());
                parent.add(new GroupByRollupNodeSingleExpr(expr.getExpr()));
                continue;
            }
            GroupByClauseElementCombinedExpr combined = (GroupByClauseElementCombinedExpr)rolledUp;
            exprNodes.addAll(combined.getExpressions());
            parent.add(new GroupByRollupNodeCombinedExpr(combined.getExpressions()));
        }
    }

    private static ExprNode copyVisitExpression(ExprNode expression, ExpressionCopier expressionCopier) {
        return expressionCopier.copy(expression);
    }

    private static class GroupByExpressionInfo {
        private final List<ExprNode> expressions;
        private final List<GroupByRollupNodeBase> nodes;

        private GroupByExpressionInfo(List<ExprNode> expressions, List<GroupByRollupNodeBase> nodes) {
            this.expressions = expressions;
            this.nodes = nodes;
        }

        public List<ExprNode> getExpressions() {
            return this.expressions;
        }

        public List<GroupByRollupNodeBase> getNodes() {
            return this.nodes;
        }
    }
}

