/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.classprovided.compiletime;

import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionClassCollection;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompilationContext;
import com.espertech.esper.common.internal.compile.compiler.CompilerAbstractionCompileSourcesResult;
import com.espertech.esper.common.internal.compile.stage3.StatementCompileTimeServices;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.common.internal.epl.classprovided.compiletime.ClassProvidedPrecompileResult;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ClassProvidedPrecompileUtil {
    public static ClassProvidedPrecompileResult compileClassProvided(List<String> classTexts, Consumer<Object> compileResultConsumer, StatementCompileTimeServices compileTimeServices, ClassProvidedPrecompileResult optionalPrior) throws ExprValidationException {
        Map<String, List<String>> classTextToClassName;
        if (classTexts == null || classTexts.isEmpty()) {
            return ClassProvidedPrecompileResult.EMPTY;
        }
        ArrayList<String> classWithText = new ArrayList<String>(classTexts.size());
        for (String classText : classTexts) {
            if (classText.trim().isEmpty()) continue;
            classWithText.add(classText);
        }
        if (classWithText.isEmpty()) {
            return ClassProvidedPrecompileResult.EMPTY;
        }
        if (!compileTimeServices.getConfiguration().getCompiler().getByteCode().isAllowInlinedClass()) {
            throw new ExprValidationException("Inlined-class compilation has been disabled by configuration");
        }
        CompilerAbstractionClassCollection allBytes = compileTimeServices.getCompilerAbstraction().newClassCollection();
        ArrayList<Class> allClasses = new ArrayList<Class>();
        if (optionalPrior != null) {
            allBytes.add(optionalPrior.getBytes());
        }
        try {
            CompilerAbstractionCompilationContext ctx = new CompilerAbstractionCompilationContext(compileTimeServices.getServices(), compileResultConsumer, Collections.emptyList());
            CompilerAbstractionCompileSourcesResult result = compileTimeServices.getCompilerAbstraction().compileSources(classTexts, ctx, allBytes);
            classTextToClassName = result.getCodeToClassNames();
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Failed to compile an inlined-class: " + ex.getMessage(), ex);
        }
        ByteArrayProvidingClassLoader cl = new ByteArrayProvidingClassLoader(allBytes.getClasses(), (ClassLoader)compileTimeServices.getServices().getParentClassLoader());
        for (Map.Entry<String, List<String>> entry : classTextToClassName.entrySet()) {
            if (entry.getKey().trim().isEmpty()) continue;
            for (String className : entry.getValue()) {
                Class<?> clazz;
                try {
                    clazz = Class.forName(className, false, cl);
                }
                catch (ClassNotFoundException | RuntimeException e) {
                    throw ClassProvidedPrecompileUtil.handleException(e, "Failed to load class '" + className + "'", entry.getKey());
                }
                allClasses.add(clazz);
            }
        }
        return new ClassProvidedPrecompileResult(allBytes.getClasses(), allClasses);
    }

    private static ExprValidationException handleException(Exception ex, String action, String classText) {
        return new ExprValidationException(action + ": " + ex.getMessage() + " for class [\"\"\"" + classText + "\"\"\"]", ex);
    }
}

