/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.classprovided.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.NameAccessModifier;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.util.ByteArrayProvidingClassLoader;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ClassProvided {
    public static final EPTypeClass EPTYPE = new EPTypeClass(ClassProvided.class);
    private Map<String, byte[]> bytes;
    private String className;
    private String moduleName;
    private NameAccessModifier visibility = NameAccessModifier.TRANSIENT;
    private List<Class> classesMayNull;

    public ClassProvided() {
    }

    public ClassProvided(Map<String, byte[]> bytes, String className) {
        this.bytes = bytes;
        this.className = className;
    }

    public void loadClasses(ClassLoader parentClassLoader) {
        this.classesMayNull = new ArrayList<Class>(2);
        ByteArrayProvidingClassLoader cl = new ByteArrayProvidingClassLoader(this.bytes, parentClassLoader);
        for (Map.Entry<String, byte[]> entry : this.getBytes().entrySet()) {
            try {
                Class<?> clazz = Class.forName(entry.getKey(), false, cl);
                this.classesMayNull.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new EPException("Unexpected exception loading class " + entry.getKey() + ": " + e.getMessage(), e);
            }
        }
    }

    public CodegenExpression make(CodegenMethodScope parent, CodegenClassScope classScope) {
        CodegenMethod method = parent.makeChild(EPTYPE, this.getClass(), (CodegenScope)classScope);
        if (this.bytes.isEmpty()) {
            method.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "bytes", CodegenExpressionBuilder.staticMethod(Collections.class, "emptyMap", new CodegenExpression[0]));
        } else {
            method.getBlock().declareVar(EPTypePremade.MAP.getEPType(), "bytes", CodegenExpressionBuilder.newInstance(EPTypePremade.HASHMAP.getEPType(), CodegenExpressionBuilder.constant(CollectionUtil.capacityHashMap(this.bytes.size()))));
            for (Map.Entry<String, byte[]> entry : this.bytes.entrySet()) {
                method.getBlock().exprDotMethod(CodegenExpressionBuilder.ref("bytes"), "put", CodegenExpressionBuilder.constant(entry.getKey()), CodegenExpressionBuilder.constant(entry.getValue()));
            }
        }
        method.getBlock().declareVarNewInstance(EPTYPE, "cp").exprDotMethod(CodegenExpressionBuilder.ref("cp"), "setBytes", CodegenExpressionBuilder.ref("bytes")).exprDotMethod(CodegenExpressionBuilder.ref("cp"), "setClassName", CodegenExpressionBuilder.constant(this.className)).exprDotMethod(CodegenExpressionBuilder.ref("cp"), "setModuleName", CodegenExpressionBuilder.constant(this.moduleName)).exprDotMethod(CodegenExpressionBuilder.ref("cp"), "setVisibility", CodegenExpressionBuilder.constant((Object)this.visibility)).methodReturn(CodegenExpressionBuilder.ref("cp"));
        return CodegenExpressionBuilder.localMethod(method, new CodegenExpression[0]);
    }

    public Map<String, byte[]> getBytes() {
        return this.bytes;
    }

    public void setBytes(Map<String, byte[]> bytes) {
        this.bytes = bytes;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public NameAccessModifier getVisibility() {
        return this.visibility;
    }

    public void setVisibility(NameAccessModifier visibility) {
        this.visibility = visibility;
    }

    public List<Class> getClassesMayNull() {
        return this.classesMayNull;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }
}

