/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.contained;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.epl.contained.ContainedEventEval;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityEvaluate;
import com.espertech.esper.common.internal.filterspec.PropertyEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEvaluatorSimple
implements PropertyEvaluator {
    public static final EPTypeClass EPTYPE = new EPTypeClass(PropertyEvaluatorSimple.class);
    private static final Logger log = LoggerFactory.getLogger(PropertyEvaluatorSimple.class);
    private ContainedEventEval containedEventEval;
    private ExprEvaluator filter;
    private boolean fragmentIsIndexed;
    private EventType eventType;
    private String expressionText;

    public void setContainedEventEval(ContainedEventEval containedEventEval) {
        this.containedEventEval = containedEventEval;
    }

    public void setFilter(ExprEvaluator filter) {
        this.filter = filter;
    }

    public void setFragmentIsIndexed(boolean fragmentIsIndexed) {
        this.fragmentIsIndexed = fragmentIsIndexed;
    }

    public void setExpressionText(String expressionText) {
        this.expressionText = expressionText;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public EventBean[] getProperty(EventBean theEvent, ExprEvaluatorContext exprEvaluatorContext) {
        try {
            Object result = this.containedEventEval.getFragment(theEvent, new EventBean[]{theEvent}, exprEvaluatorContext);
            EventBean[] rows = this.fragmentIsIndexed ? (EventBean[])result : new EventBean[]{(EventBean)result};
            if (this.filter == null) {
                return rows;
            }
            return ExprNodeUtilityEvaluate.applyFilterExpression(this.filter, theEvent, (EventBean[])result, exprEvaluatorContext);
        }
        catch (RuntimeException ex) {
            log.error("Unexpected error evaluating property expression for event of type '" + theEvent.getEventType().getName() + "' and property '" + this.expressionText + "': " + ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    @Override
    public EventType getFragmentEventType() {
        return this.eventType;
    }

    @Override
    public boolean compareTo(PropertyEvaluator otherEval) {
        if (!(otherEval instanceof PropertyEvaluatorSimple)) {
            return false;
        }
        PropertyEvaluatorSimple other = (PropertyEvaluatorSimple)otherEval;
        if (!other.getExpressionText().equals(this.getExpressionText())) {
            return false;
        }
        return other.getFilter() == null && this.getFilter() == null;
    }

    public ExprEvaluator getFilter() {
        return this.filter;
    }

    public String getExpressionText() {
        return this.expressionText;
    }
}

