/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.core;

import com.espertech.esper.common.client.dataflow.core.EPDataFlowAlreadyExistsException;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowDescriptor;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowInstance;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowInstantiationException;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowInstantiationOptions;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowNotFoundException;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowSavedConfiguration;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowService;
import com.espertech.esper.common.internal.context.aifactory.createdataflow.DataflowDesc;
import com.espertech.esper.common.internal.epl.dataflow.core.DataFlowConfigurationStateService;
import com.espertech.esper.common.internal.epl.dataflow.core.DataFlowConfigurationStateServiceImpl;
import com.espertech.esper.common.internal.epl.dataflow.core.DataflowDeployment;
import com.espertech.esper.common.internal.epl.dataflow.realize.DataflowInstantiator;
import com.espertech.esper.common.internal.util.DeploymentIdNamePair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPDataFlowServiceImpl
implements EPDataFlowService {
    public static final String OP_PACKAGE_NAME = "com.espertech.esper.runtime.internal.dataflow.op";
    private static final Logger log = LoggerFactory.getLogger(EPDataFlowServiceImpl.class);
    private final Map<String, DataflowDeployment> deployments = new HashMap<String, DataflowDeployment>();
    private final Map<String, EPDataFlowInstance> instances = new HashMap<String, EPDataFlowInstance>();
    private final DataFlowConfigurationStateService configurationState = new DataFlowConfigurationStateServiceImpl();
    private int agentInstanceNumCurrent;

    @Override
    public synchronized EPDataFlowDescriptor getDataFlow(String deploymentId, String dataflowName) {
        DataflowDesc entry = this.getEntryMayNull(deploymentId, dataflowName);
        return entry == null ? null : new EPDataFlowDescriptor(deploymentId, entry.getDataflowName(), entry.getStatementContext().getStatementName());
    }

    @Override
    public synchronized DeploymentIdNamePair[] getDataFlows() {
        ArrayList<DeploymentIdNamePair> ids = new ArrayList<DeploymentIdNamePair>();
        for (Map.Entry<String, DataflowDeployment> deployment : this.deployments.entrySet()) {
            for (Map.Entry<String, DataflowDesc> entry : deployment.getValue().getDataflows().entrySet()) {
                ids.add(new DeploymentIdNamePair(deployment.getKey(), entry.getKey()));
            }
        }
        return ids.toArray(new DeploymentIdNamePair[ids.size()]);
    }

    @Override
    public synchronized EPDataFlowInstance instantiate(String deploymentId, String dataflowName) throws EPDataFlowInstantiationException {
        return this.instantiate(deploymentId, dataflowName, new EPDataFlowInstantiationOptions());
    }

    @Override
    public synchronized EPDataFlowInstance instantiate(String deploymentId, String dataFlowName, EPDataFlowInstantiationOptions options) throws EPDataFlowInstantiationException {
        DataflowDesc entry = this.getEntryMayNull(deploymentId, dataFlowName);
        if (entry == null) {
            throw new EPDataFlowInstantiationException("Data flow by name '" + dataFlowName + "' for deployment id '" + deploymentId + "' has not been defined");
        }
        try {
            ++this.agentInstanceNumCurrent;
            return DataflowInstantiator.instantiate(this.agentInstanceNumCurrent, entry, options);
        }
        catch (Exception ex) {
            String message = "Failed to instantiate data flow '" + dataFlowName + "': " + ex.getMessage();
            log.debug(message, (Throwable)ex);
            throw new EPDataFlowInstantiationException(message, ex);
        }
    }

    @Override
    public synchronized void saveInstance(String instanceName, EPDataFlowInstance instance) throws EPDataFlowAlreadyExistsException {
        if (this.instances.containsKey(instanceName)) {
            throw new EPDataFlowAlreadyExistsException("Data flow instance name '" + instanceName + "' already saved");
        }
        this.instances.put(instanceName, instance);
    }

    @Override
    public synchronized String[] getSavedInstances() {
        Set<String> instanceids = this.instances.keySet();
        return instanceids.toArray(new String[instanceids.size()]);
    }

    @Override
    public synchronized EPDataFlowInstance getSavedInstance(String instanceName) {
        return this.instances.get(instanceName);
    }

    @Override
    public synchronized boolean removeSavedInstance(String instanceName) {
        return this.instances.remove(instanceName) != null;
    }

    public synchronized void addDataflow(String deploymentId, DataflowDesc dataflow) {
        DataflowDeployment deployment = this.deployments.get(deploymentId);
        if (deployment == null) {
            deployment = new DataflowDeployment();
            this.deployments.put(deploymentId, deployment);
        }
        deployment.add(dataflow.getDataflowName(), dataflow);
    }

    public synchronized void removeDataflow(String deploymentId, DataflowDesc dataflow) {
        DataflowDeployment deployment = this.deployments.get(deploymentId);
        if (deployment == null) {
            return;
        }
        deployment.remove(dataflow.getDataflowName());
    }

    @Override
    public synchronized void saveConfiguration(String dataflowConfigName, String deploymentId, String dataFlowName, EPDataFlowInstantiationOptions options) {
        DataflowDesc entry = this.getEntryMayNull(deploymentId, dataFlowName);
        if (entry == null) {
            String message = "Failed to locate data flow '" + dataFlowName + "'";
            throw new EPDataFlowNotFoundException(message);
        }
        if (this.configurationState.exists(dataflowConfigName)) {
            String message = "Data flow saved configuration by name '" + dataflowConfigName + "' already exists";
            throw new EPDataFlowAlreadyExistsException(message);
        }
        this.configurationState.add(new EPDataFlowSavedConfiguration(dataflowConfigName, deploymentId, dataFlowName, options));
    }

    @Override
    public synchronized String[] getSavedConfigurations() {
        return this.configurationState.getSavedConfigNames();
    }

    @Override
    public synchronized EPDataFlowSavedConfiguration getSavedConfiguration(String configurationName) {
        return this.configurationState.getSavedConfig(configurationName);
    }

    @Override
    public synchronized EPDataFlowInstance instantiateSavedConfiguration(String configurationName) throws EPDataFlowInstantiationException {
        EPDataFlowSavedConfiguration savedConfiguration = this.configurationState.getSavedConfig(configurationName);
        if (savedConfiguration == null) {
            throw new EPDataFlowInstantiationException("Dataflow saved configuration '" + configurationName + "' could not be found");
        }
        EPDataFlowInstantiationOptions options = savedConfiguration.getOptions();
        if (options == null) {
            options = new EPDataFlowInstantiationOptions();
            options.setDataFlowInstanceId(configurationName);
        }
        return this.instantiate(savedConfiguration.getDeploymentId(), savedConfiguration.getDataflowName(), options);
    }

    @Override
    public synchronized boolean removeSavedConfiguration(String configurationName) {
        return this.configurationState.removePrototype(configurationName) != null;
    }

    private DataflowDesc getEntryMayNull(String deploymentId, String dataFlowName) {
        DataflowDeployment deployment = this.deployments.get(deploymentId);
        return deployment == null ? null : deployment.getDataflow(dataFlowName);
    }
}

