/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.ops;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.dataflow.annotations.DataFlowOpParameter;
import com.espertech.esper.common.client.dataflow.util.DataFlowParameterValidation;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeBuilder;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeContext;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpForgeInitializeResult;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOpInputPort;
import com.espertech.esper.common.internal.epl.dataflow.interfaces.DataFlowOperatorForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import java.util.Map;

public class LogSinkForge
implements DataFlowOperatorForge {
    @DataFlowOpParameter
    private ExprNode title;
    @DataFlowOpParameter
    private ExprNode layout;
    @DataFlowOpParameter
    private ExprNode format;
    @DataFlowOpParameter
    private ExprNode log;
    @DataFlowOpParameter
    private ExprNode linefeed;
    private EventType[] eventTypes;

    @Override
    public DataFlowOpForgeInitializeResult initializeForge(DataFlowOpForgeInitializeContext context) throws ExprValidationException {
        if (!context.getOutputPorts().isEmpty()) {
            throw new IllegalArgumentException("LogSink operator does not provide an output stream");
        }
        this.eventTypes = new EventType[context.getInputPorts().size()];
        for (Map.Entry<Integer, DataFlowOpInputPort> entry : context.getInputPorts().entrySet()) {
            this.eventTypes[entry.getKey().intValue()] = entry.getValue().getTypeDesc().getEventType();
        }
        this.title = DataFlowParameterValidation.validate("title", this.title, String.class, context);
        this.layout = DataFlowParameterValidation.validate("layout", this.layout, String.class, context);
        this.format = DataFlowParameterValidation.validate("format", this.format, String.class, context);
        this.log = DataFlowParameterValidation.validate("log", this.log, Boolean.TYPE, context);
        this.linefeed = DataFlowParameterValidation.validate("linefeed", this.linefeed, Boolean.TYPE, context);
        return null;
    }

    @Override
    public CodegenExpression make(CodegenMethodScope parent, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        return new SAIFFInitializeBuilder("com.espertech.esper.runtime.internal.dataflow.op.logsink.LogSinkFactory", this.getClass(), "log", parent, symbols, classScope).exprnode("title", this.title).exprnode("layout", this.layout).exprnode("format", this.format).exprnode("log", this.log).exprnode("linefeed", this.linefeed).eventtypesMayNull("eventTypes", this.eventTypes).build();
    }
}

