/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.realize;

import com.espertech.esper.common.client.dataflow.core.EPDataFlowExceptionContext;
import com.espertech.esper.common.client.dataflow.core.EPDataFlowExceptionHandler;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EPDataFlowEmitterExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(EPDataFlowEmitterExceptionHandler.class);
    private final AgentInstanceContext agentInstanceContext;
    private final String dataFlowName;
    private final String instanceId;
    private final String operatorName;
    private final int operatorNumber;
    private final String operatorPrettyPrint;
    private final EPDataFlowExceptionHandler optionalExceptionHandler;

    public EPDataFlowEmitterExceptionHandler(AgentInstanceContext agentInstanceContext, String dataFlowName, String instanceId, String operatorName, int operatorNumber, String operatorPrettyPrint, EPDataFlowExceptionHandler optionalExceptionHandler) {
        this.agentInstanceContext = agentInstanceContext;
        this.dataFlowName = dataFlowName;
        this.instanceId = instanceId;
        this.operatorName = operatorName;
        this.operatorNumber = operatorNumber;
        this.operatorPrettyPrint = operatorPrettyPrint;
        this.optionalExceptionHandler = optionalExceptionHandler;
    }

    public void handleException(Object targetObject, Method fastMethod, InvocationTargetException ex, Object[] parameters) {
        log.error("Exception encountered: " + ex.getTargetException().getMessage(), ex.getTargetException());
        if (this.optionalExceptionHandler != null) {
            this.optionalExceptionHandler.handle(new EPDataFlowExceptionContext(this.dataFlowName, this.operatorName, this.operatorNumber, this.operatorPrettyPrint, ex.getTargetException()));
        }
    }

    public void handleException(Object targetObject, Method fastMethod, IllegalAccessException ex, Object[] parameters) {
        log.error("Exception encountered: " + ex.getMessage(), (Throwable)ex);
        if (this.optionalExceptionHandler != null) {
            this.optionalExceptionHandler.handle(new EPDataFlowExceptionContext(this.dataFlowName, this.operatorName, this.operatorNumber, this.operatorPrettyPrint, ex));
        }
    }

    public String getRuntimeURI() {
        return this.agentInstanceContext.getRuntimeURI();
    }

    public String getStatementName() {
        return this.agentInstanceContext.getStatementName();
    }

    public String getDataFlowName() {
        return this.dataFlowName;
    }

    public String getOperatorName() {
        return this.operatorName;
    }

    public int getOperatorNumber() {
        return this.operatorNumber;
    }

    public String getOperatorPrettyPrint() {
        return this.operatorPrettyPrint;
    }

    public EPDataFlowExceptionHandler getOptionalExceptionHandler() {
        return this.optionalExceptionHandler;
    }

    public String getDeploymentId() {
        return this.agentInstanceContext.getDeploymentId();
    }

    public void handleAudit(Object targetObject, Object[] parameters) {
        this.agentInstanceContext.getAuditProvider().dataflowOp(this.dataFlowName, this.instanceId, this.operatorName, this.operatorNumber, parameters, this.agentInstanceContext);
    }
}

