/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.dataflow.util;

import com.espertech.esper.common.client.dataflow.util.EPDataFlowSignal;
import com.espertech.esper.common.internal.epl.dataflow.util.DataFlowSignalListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataFlowSignalManager {
    private Map<Integer, List<DataFlowSignalListener>> listenersPerOp = new HashMap<Integer, List<DataFlowSignalListener>>();

    public void processSignal(int operatorNum, EPDataFlowSignal signal) {
        List<DataFlowSignalListener> listeners = this.listenersPerOp.get(operatorNum);
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (DataFlowSignalListener listener : listeners) {
            listener.processSignal(signal);
        }
    }

    public void addSignalListener(int producerOpNum, DataFlowSignalListener listener) {
        List<DataFlowSignalListener> listeners = this.listenersPerOp.get(producerOpNum);
        if (listeners == null) {
            listeners = new ArrayList<DataFlowSignalListener>();
            this.listenersPerOp.put(producerOpNum, listeners);
        }
        listeners.add(listener);
    }
}

