/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.epl.datetime.calop;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarOp;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarWithDateForgeOp;
import com.espertech.esper.common.internal.epl.datetime.calop.CalendarWithTimeForge;
import com.espertech.esper.common.internal.epl.expression.codegen.ExprForgeCodegenSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Calendar;

public class CalendarWithTimeForgeOp
implements CalendarOp {
    public static final String METHOD_ACTIONSETHMSMCALENDAR = "actionSetHMSMCalendar";
    private ExprEvaluator hour;
    private ExprEvaluator min;
    private ExprEvaluator sec;
    private ExprEvaluator msec;

    public CalendarWithTimeForgeOp(ExprEvaluator hour, ExprEvaluator min, ExprEvaluator sec, ExprEvaluator msec) {
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.msec = msec;
    }

    @Override
    public void evaluate(Calendar cal, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer hourNum = CalendarWithDateForgeOp.getInt(this.hour, eventsPerStream, isNewData, context);
        Integer minNum = CalendarWithDateForgeOp.getInt(this.min, eventsPerStream, isNewData, context);
        Integer secNum = CalendarWithDateForgeOp.getInt(this.sec, eventsPerStream, isNewData, context);
        Integer msecNum = CalendarWithDateForgeOp.getInt(this.msec, eventsPerStream, isNewData, context);
        CalendarWithTimeForgeOp.actionSetHMSMCalendar(cal, hourNum, minNum, secNum, msecNum);
    }

    public static CodegenExpression codegenCalendar(CalendarWithTimeForge forge, CodegenExpression cal, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.VOID.getEPType(), CalendarWithTimeForgeOp.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.CALENDAR.getEPType(), "cal");
        CodegenBlock block = methodNode.getBlock();
        CalendarWithTimeForgeOp.codegenDeclareInts(block, forge, methodNode, exprSymbol, codegenClassScope);
        block.staticMethod(CalendarWithTimeForgeOp.class, METHOD_ACTIONSETHMSMCALENDAR, CodegenExpressionBuilder.ref("cal"), CodegenExpressionBuilder.ref("hour"), CodegenExpressionBuilder.ref("minute"), CodegenExpressionBuilder.ref("second"), CodegenExpressionBuilder.ref("msec"));
        return CodegenExpressionBuilder.localMethod(methodNode, cal);
    }

    @Override
    public LocalDateTime evaluate(LocalDateTime ldt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer hourNum = CalendarWithDateForgeOp.getInt(this.hour, eventsPerStream, isNewData, context);
        Integer minNum = CalendarWithDateForgeOp.getInt(this.min, eventsPerStream, isNewData, context);
        Integer secNum = CalendarWithDateForgeOp.getInt(this.sec, eventsPerStream, isNewData, context);
        Integer msecNum = CalendarWithDateForgeOp.getInt(this.msec, eventsPerStream, isNewData, context);
        return CalendarWithTimeForgeOp.actionSetHMSMLocalDateTime(ldt, hourNum, minNum, secNum, msecNum);
    }

    public static CodegenExpression codegenLDT(CalendarWithTimeForge forge, CodegenExpression ldt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.LOCALDATETIME.getEPType(), CalendarWithTimeForgeOp.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.LOCALDATETIME.getEPType(), "ldt");
        CodegenBlock block = methodNode.getBlock();
        CalendarWithTimeForgeOp.codegenDeclareInts(block, forge, methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(CodegenExpressionBuilder.staticMethod(CalendarWithTimeForgeOp.class, "actionSetHMSMLocalDateTime", CodegenExpressionBuilder.ref("ldt"), CodegenExpressionBuilder.ref("hour"), CodegenExpressionBuilder.ref("minute"), CodegenExpressionBuilder.ref("second"), CodegenExpressionBuilder.ref("msec")));
        return CodegenExpressionBuilder.localMethod(methodNode, ldt);
    }

    @Override
    public ZonedDateTime evaluate(ZonedDateTime zdt, EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext context) {
        Integer hourNum = CalendarWithDateForgeOp.getInt(this.hour, eventsPerStream, isNewData, context);
        Integer minNum = CalendarWithDateForgeOp.getInt(this.min, eventsPerStream, isNewData, context);
        Integer secNum = CalendarWithDateForgeOp.getInt(this.sec, eventsPerStream, isNewData, context);
        Integer msecNum = CalendarWithDateForgeOp.getInt(this.msec, eventsPerStream, isNewData, context);
        return CalendarWithTimeForgeOp.actionSetHMSMZonedDateTime(zdt, hourNum, minNum, secNum, msecNum);
    }

    public static CodegenExpression codegenZDT(CalendarWithTimeForge forge, CodegenExpression zdt, CodegenMethodScope codegenMethodScope, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        CodegenMethod methodNode = codegenMethodScope.makeChild(EPTypePremade.ZONEDDATETIME.getEPType(), CalendarWithTimeForgeOp.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.ZONEDDATETIME.getEPType(), "zdt");
        CodegenBlock block = methodNode.getBlock();
        CalendarWithTimeForgeOp.codegenDeclareInts(block, forge, methodNode, exprSymbol, codegenClassScope);
        block.methodReturn(CodegenExpressionBuilder.staticMethod(CalendarWithTimeForgeOp.class, "actionSetHMSMZonedDateTime", CodegenExpressionBuilder.ref("zdt"), CodegenExpressionBuilder.ref("hour"), CodegenExpressionBuilder.ref("minute"), CodegenExpressionBuilder.ref("second"), CodegenExpressionBuilder.ref("msec")));
        return CodegenExpressionBuilder.localMethod(methodNode, zdt);
    }

    public static void actionSetHMSMCalendar(Calendar cal, Integer hour, Integer minute, Integer second, Integer msec) {
        if (hour != null) {
            cal.set(11, hour);
        }
        if (minute != null) {
            cal.set(12, minute);
        }
        if (second != null) {
            cal.set(13, second);
        }
        if (msec != null) {
            cal.set(14, msec);
        }
    }

    public static LocalDateTime actionSetHMSMLocalDateTime(LocalDateTime ldt, Integer hour, Integer minute, Integer second, Integer msec) {
        if (hour != null) {
            ldt = ldt.with(ChronoField.HOUR_OF_DAY, hour.intValue());
        }
        if (minute != null) {
            ldt = ldt.with(ChronoField.MINUTE_OF_HOUR, minute.intValue());
        }
        if (second != null) {
            ldt = ldt.with(ChronoField.SECOND_OF_MINUTE, second.intValue());
        }
        if (msec != null) {
            ldt = ldt.with(ChronoField.MILLI_OF_SECOND, msec.intValue());
        }
        return ldt;
    }

    public static ZonedDateTime actionSetHMSMZonedDateTime(ZonedDateTime zdt, Integer hour, Integer minute, Integer second, Integer msec) {
        if (hour != null) {
            zdt = zdt.with(ChronoField.HOUR_OF_DAY, hour.intValue());
        }
        if (minute != null) {
            zdt = zdt.with(ChronoField.MINUTE_OF_HOUR, minute.intValue());
        }
        if (second != null) {
            zdt = zdt.with(ChronoField.SECOND_OF_MINUTE, second.intValue());
        }
        if (msec != null) {
            zdt = zdt.with(ChronoField.MILLI_OF_SECOND, msec.intValue());
        }
        return zdt;
    }

    private static void codegenDeclareInts(CodegenBlock block, CalendarWithTimeForge forge, CodegenMethod methodNode, ExprForgeCodegenSymbol exprSymbol, CodegenClassScope codegenClassScope) {
        EPTypeClass hourType = (EPTypeClass)forge.hour.getEvaluationType();
        EPTypeClass minType = (EPTypeClass)forge.min.getEvaluationType();
        EPTypeClass secType = (EPTypeClass)forge.sec.getEvaluationType();
        EPTypeClass msecType = (EPTypeClass)forge.msec.getEvaluationType();
        block.declareVar(EPTypePremade.INTEGERBOXED.getEPType(), "hour", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.hour.evaluateCodegen(hourType, methodNode, exprSymbol, codegenClassScope), hourType, methodNode, codegenClassScope)).declareVar(EPTypePremade.INTEGERBOXED.getEPType(), "minute", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.min.evaluateCodegen(minType, methodNode, exprSymbol, codegenClassScope), minType, methodNode, codegenClassScope)).declareVar(EPTypePremade.INTEGERBOXED.getEPType(), "second", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.sec.evaluateCodegen(secType, methodNode, exprSymbol, codegenClassScope), secType, methodNode, codegenClassScope)).declareVar(EPTypePremade.INTEGERBOXED.getEPType(), "msec", SimpleNumberCoercerFactory.SimpleNumberCoercerInt.coerceCodegenMayNull(forge.msec.evaluateCodegen(msecType, methodNode, exprSymbol, codegenClassScope), msecType, methodNode, codegenClassScope));
    }
}

